/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.common.LibCommonProxy;
import com.teamwizardry.librarianlib.features.methodhandles.MethodHandleHelper;
import com.teamwizardry.librarianlib.features.structure.StructureMatchResult;
import com.teamwizardry.librarianlib.features.structure.TemplateBlockAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0018\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020!J \u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u0007J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0004J \u00107\u001a\u00020!2\u0006\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0007H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020!@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R$\u0010)\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020!@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%\u00a8\u0006="}, d2={"Lcom/teamwizardry/librarianlib/features/structure/Structure;", "", "loc", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "matchedRotation", "Lnet/minecraft/util/Rotation;", "getMatchedRotation", "()Lnet/minecraft/util/Rotation;", "setMatchedRotation", "(Lnet/minecraft/util/Rotation;)V", "template", "Lnet/minecraft/world/gen/structure/template/Template;", "getTemplate", "()Lnet/minecraft/world/gen/structure/template/Template;", "setTemplate", "(Lnet/minecraft/world/gen/structure/template/Template;)V", "templateBlocks", "", "Lnet/minecraft/world/gen/structure/template/Template$BlockInfo;", "getTemplateBlocks", "()Ljava/util/List;", "setTemplateBlocks", "(Ljava/util/List;)V", "value", "Lcom/teamwizardry/librarianlib/features/structure/TemplateBlockAccess;", "blockAccess", "getBlockAccess", "()Lcom/teamwizardry/librarianlib/features/structure/TemplateBlockAccess;", "setBlockAccess", "(Lcom/teamwizardry/librarianlib/features/structure/TemplateBlockAccess;)V", "origin", "Lnet/minecraft/util/math/BlockPos;", "getOrigin", "()Lnet/minecraft/util/math/BlockPos;", "setOrigin", "(Lnet/minecraft/util/math/BlockPos;)V", "min", "getMin", "setMin", "max", "getMax", "setMax", "blockInfos", "match", "Lcom/teamwizardry/librarianlib/features/structure/StructureMatchResult;", "world", "Lnet/minecraft/world/World;", "checkPos", "rot", "parse", "", "stream", "Ljava/io/InputStream;", "transformedBlockPos", "pos", "mirrorIn", "Lnet/minecraft/util/Mirror;", "rotationIn", "Companion", "LibrarianLib-Continuous-1.12.2"})
public class Structure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public Rotation matchedRotation;
    protected Template template;
    @Nullable
    private List<? extends Template.BlockInfo> templateBlocks;
    protected TemplateBlockAccess blockAccess;
    @NotNull
    private BlockPos origin;
    @NotNull
    private BlockPos min;
    @NotNull
    private BlockPos max;
    @NotNull
    private static final Function1<Template, Object> templateGetter;
    @JvmField
    @NotNull
    public static final List<IProperty<?>> IGNORE;
    @JvmField
    @NotNull
    public static final Multimap<IProperty<?>, List<?>> EQUIVALENTS;

    public Structure(@NotNull ResourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        BlockPos blockPos = BlockPos.field_177992_a;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"ORIGIN");
        this.origin = blockPos;
        BlockPos blockPos2 = BlockPos.field_177992_a;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"ORIGIN");
        this.min = blockPos2;
        BlockPos blockPos3 = BlockPos.field_177992_a;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"ORIGIN");
        this.max = blockPos3;
        LibCommonProxy libCommonProxy = LibrarianLib.INSTANCE.getPROXY();
        String string = loc.func_110624_b();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespace(...)");
        InputStream stream = libCommonProxy.getResource(string, "schematics/" + loc.func_110623_a() + ".nbt");
        if (stream != null) {
            try {
                this.parse(stream);
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final Rotation getMatchedRotation() {
        Rotation rotation = this.matchedRotation;
        if (rotation != null) {
            return rotation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"matchedRotation");
        return null;
    }

    public final void setMatchedRotation(@NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"<set-?>");
        this.matchedRotation = rotation;
    }

    @NotNull
    protected final Template getTemplate() {
        Template template = this.template;
        if (template != null) {
            return template;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"template");
        return null;
    }

    protected final void setTemplate(@NotNull Template template) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"<set-?>");
        this.template = template;
    }

    @Nullable
    protected final List<Template.BlockInfo> getTemplateBlocks() {
        return this.templateBlocks;
    }

    protected final void setTemplateBlocks(@Nullable List<? extends Template.BlockInfo> list) {
        this.templateBlocks = list;
    }

    @NotNull
    public final TemplateBlockAccess getBlockAccess() {
        TemplateBlockAccess templateBlockAccess = this.blockAccess;
        if (templateBlockAccess != null) {
            return templateBlockAccess;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockAccess");
        return null;
    }

    protected final void setBlockAccess(@NotNull TemplateBlockAccess templateBlockAccess) {
        Intrinsics.checkNotNullParameter((Object)templateBlockAccess, (String)"<set-?>");
        this.blockAccess = templateBlockAccess;
    }

    @NotNull
    public final BlockPos getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.origin = blockPos;
    }

    @NotNull
    public final BlockPos getMin() {
        return this.min;
    }

    protected final void setMin(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.min = blockPos;
    }

    @NotNull
    public final BlockPos getMax() {
        return this.max;
    }

    protected final void setMax(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.max = blockPos;
    }

    @NotNull
    public final List<Template.BlockInfo> blockInfos() {
        List list = this.templateBlocks;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final StructureMatchResult match(@NotNull World world, @NotNull BlockPos checkPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)checkPos, (String)"checkPos");
        StructureMatchResult none = this.match(world, checkPos, Rotation.NONE);
        StructureMatchResult reverse = this.match(world, checkPos, Rotation.CLOCKWISE_180);
        StructureMatchResult cw = this.match(world, checkPos, Rotation.CLOCKWISE_90);
        StructureMatchResult ccw = this.match(world, checkPos, Rotation.COUNTERCLOCKWISE_90);
        StructureMatchResult finalList = none;
        this.setMatchedRotation(Rotation.NONE);
        if (finalList == null || reverse != null && reverse.getAllErrors().size() < finalList.getAllErrors().size()) {
            finalList = reverse;
            this.setMatchedRotation(Rotation.CLOCKWISE_180);
        }
        if (finalList == null || cw != null && cw.getAllErrors().size() < finalList.getAllErrors().size()) {
            finalList = cw;
            this.setMatchedRotation(Rotation.CLOCKWISE_90);
        }
        if (finalList == null || ccw != null && ccw.getAllErrors().size() < finalList.getAllErrors().size()) {
            finalList = ccw;
            this.setMatchedRotation(Rotation.COUNTERCLOCKWISE_90);
        }
        return finalList;
    }

    @Nullable
    public final StructureMatchResult match(@NotNull World world, @NotNull BlockPos checkPos, @NotNull Rotation rot) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)checkPos, (String)"checkPos");
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        BlockPos blockPos = checkPos.func_177973_b((Vec3i)this.origin);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"subtract(...)");
        StructureMatchResult result = new StructureMatchResult(blockPos, rot, this);
        List<? extends Template.BlockInfo> list = this.templateBlocks;
        if (list == null) {
            return null;
        }
        List<? extends Template.BlockInfo> infos = list;
        for (Template.BlockInfo blockInfo : infos) {
            boolean bl;
            if (Intrinsics.areEqual((Object)blockInfo.field_186242_a, (Object)this.origin)) continue;
            BlockPos blockPos2 = blockInfo.field_186242_a.func_177973_b((Vec3i)this.origin);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"subtract(...)");
            BlockPos worldPos = this.transformedBlockPos(blockPos2, Mirror.NONE, rot).func_177971_a((Vec3i)checkPos);
            IBlockState worldState = world.func_180495_p(worldPos);
            IBlockState templateState = blockInfo.field_186243_b;
            boolean match = true;
            if (worldState.func_177230_c() != templateState.func_177230_c()) {
                boolean bl2;
                if (worldState.func_177230_c() == Blocks.field_150350_a) {
                    List<BlockPos> list2 = result.getAirErrors();
                    BlockPos blockPos3 = blockInfo.field_186242_a;
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"pos");
                    bl2 = list2.add(blockPos3);
                } else {
                    List<BlockPos> list3 = result.getNonAirErrors();
                    BlockPos blockPos4 = blockInfo.field_186242_a;
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"pos");
                    bl2 = list3.add(blockPos4);
                }
                match = false;
            } else {
                Collection worldProps = worldState.func_177227_a();
                for (IProperty prop : templateState.func_177227_a()) {
                    if (IGNORE.contains(prop) || Intrinsics.areEqual((Object)templateState.func_177230_c(), (Object)Blocks.field_150488_af)) continue;
                    if (!worldProps.contains(prop)) {
                        List<BlockPos> list4 = result.getPropertyErrors();
                        BlockPos blockPos5 = blockInfo.field_186242_a;
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"pos");
                        list4.add(blockPos5);
                        match = false;
                        break;
                    }
                    boolean propsMatch = false;
                    Intrinsics.checkNotNull((Object)prop, (String)"null cannot be cast to non-null type net.minecraft.block.properties.IProperty<kotlin.Comparable<kotlin.Any>>");
                    Comparable worldValue = worldState.func_177229_b(prop);
                    Comparable templateValue = templateState.func_177229_b(prop);
                    boolean bl3 = propsMatch = worldValue == templateValue;
                    if (!propsMatch) {
                        for (List list5 : EQUIVALENTS.get((Object)prop)) {
                            if (!list5.contains(worldValue) || !list5.contains(templateValue)) continue;
                            propsMatch = true;
                            break;
                        }
                    }
                    if (propsMatch) continue;
                    List<BlockPos> list5 = result.getPropertyErrors();
                    BlockPos blockPos6 = blockInfo.field_186242_a;
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos6, (String)"pos");
                    list5.add(blockPos6);
                    match = false;
                    break;
                }
            }
            if (match) {
                List<BlockPos> list6 = result.getMatches();
                BlockPos blockPos7 = blockInfo.field_186242_a;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos7, (String)"pos");
                bl = list6.add(blockPos7);
                continue;
            }
            List<BlockPos> list7 = result.getAllErrors();
            BlockPos blockPos8 = blockInfo.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos8, (String)"pos");
            bl = list7.add(blockPos8);
        }
        return result;
    }

    protected final void parse(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.setTemplate(new Template());
        this.templateBlocks = Companion.getBlocks(this.getTemplate());
        this.setBlockAccess(new TemplateBlockAccess(this.getTemplate()));
        try {
            int n;
            int i;
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)stream);
            this.getTemplate().func_186256_b(tag);
            NBTTagList list = tag.func_150295_c("palette", 10);
            int paletteID = -1;
            int i2 = 0;
            int n2 = list.func_74745_c() - 1;
            if (i2 <= n2) {
                while (true) {
                    NBTTagCompound compound;
                    if (Intrinsics.areEqual((Object)"minecraft:structure_block", (Object)(compound = list.func_150305_b(i2)).func_74779_i("Name"))) {
                        paletteID = i2;
                        break;
                    }
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            if (paletteID >= 0 && (i = 0) <= (n = (list = tag.func_150295_c("blocks", 10)).func_74745_c() - 1)) {
                while (true) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    NBTTagList posList = compound.func_150295_c("pos", 3);
                    BlockPos pos2 = new BlockPos(posList.func_186858_c(0), posList.func_186858_c(1), posList.func_186858_c(2));
                    if (compound.func_74762_e("state") == paletteID) {
                        this.origin = pos2;
                    }
                    minX = Math.min(minX, pos2.func_177958_n());
                    minY = Math.min(minY, pos2.func_177956_o());
                    minZ = Math.min(minZ, pos2.func_177952_p());
                    maxX = Math.max(maxX, pos2.func_177958_n());
                    maxY = Math.max(maxY, pos2.func_177956_o());
                    maxZ = Math.max(maxZ, pos2.func_177952_p());
                    if (i == n) break;
                    ++i;
                }
            }
            this.min = new BlockPos(minX, minY, minZ);
            this.max = new BlockPos(maxX, maxY, maxZ);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final BlockPos transformedBlockPos(BlockPos pos2, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos2.func_177958_n();
        int j = pos2.func_177956_o();
        int k = pos2.func_177952_p();
        boolean flag = true;
        switch (WhenMappings.$EnumSwitchMapping$0[mirrorIn.ordinal()]) {
            case 1: {
                k = -k;
                break;
            }
            case 2: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[rotationIn.ordinal()]) {
            case 1: {
                return new BlockPos(k, j, -i);
            }
            case 2: {
                return new BlockPos(-k, j, i);
            }
            case 3: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos2;
    }

    static {
        String[] stringArray = new String[]{"blocks", "field_186270_a"};
        templateGetter = MethodHandleHelper.wrapperForGetter(Template.class, stringArray);
        stringArray = new PropertyHelper[]{BlockSlab.field_176554_a, BlockStairs.field_176310_M, BlockStairs.field_176309_a, BlockPane.field_176242_M, BlockPane.field_176244_O, BlockPane.field_176241_b, BlockPane.field_176243_N, BlockRedstoneComparator.field_185512_D, BlockRedstoneComparator.field_176463_b, BlockRedstoneComparator.field_176464_a, BlockRedstoneRepeater.field_185512_D, BlockRedstoneRepeater.field_176410_b, BlockRedstoneRepeater.field_176411_a};
        IGNORE = new ArrayList(Arrays.asList(stringArray));
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        EQUIVALENTS = (Multimap)hashMultimap;
        stringArray = new BlockQuartz.EnumType[]{BlockQuartz.EnumType.LINES_X, BlockQuartz.EnumType.LINES_Y, BlockQuartz.EnumType.LINES_Z};
        EQUIVALENTS.put((Object)BlockQuartz.field_176335_a, Arrays.asList(stringArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00068F\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/teamwizardry/librarianlib/features/structure/Structure$Companion;", "", "<init>", "()V", "templateGetter", "Lkotlin/Function1;", "Lnet/minecraft/world/gen/structure/template/Template;", "getTemplateGetter", "()Lkotlin/jvm/functions/Function1;", "blocks", "", "Lnet/minecraft/world/gen/structure/template/Template$BlockInfo;", "getBlocks$annotations", "(Lnet/minecraft/world/gen/structure/template/Template;)V", "getBlocks", "(Lnet/minecraft/world/gen/structure/template/Template;)Ljava/util/List;", "IGNORE", "", "Lnet/minecraft/block/properties/IProperty;", "EQUIVALENTS", "Lcom/google/common/collect/Multimap;", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Template, Object> getTemplateGetter() {
            return templateGetter;
        }

        @NotNull
        public final List<Template.BlockInfo> getBlocks(@NotNull Template $this$blocks) {
            Intrinsics.checkNotNullParameter((Object)$this$blocks, (String)"<this>");
            Object object = this.getTemplateGetter().invoke((Object)$this$blocks);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<net.minecraft.world.gen.structure.template.Template.BlockInfo>");
            return (List)object;
        }

        public static /* synthetic */ void getBlocks$annotations(Template template) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Mirror.values().length];
            try {
                nArray[Mirror.LEFT_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mirror.FRONT_BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Rotation.values().length];
            try {
                nArray[Rotation.COUNTERCLOCKWISE_90.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.CLOCKWISE_90.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.CLOCKWISE_180.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

