/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.structure;

import com.teamwizardry.librarianlib.features.structure.Structure;
import com.teamwizardry.librarianlib.features.structure.TemplateBlockAccess;
import com.teamwizardry.librarianlib.features.utilities.client.BlockRenderUtils;
import java.awt.Color;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/teamwizardry/librarianlib/features/structure/StructureRenderUtil;", "", "<init>", "()V", "blockBuf", "Lnet/minecraft/client/renderer/BufferBuilder;", "render", "", "structure", "Lcom/teamwizardry/librarianlib/features/structure/Structure;", "color", "Ljava/awt/Color;", "brightness", "", "LibrarianLib-Continuous-1.12.2"})
public final class StructureRenderUtil {
    @NotNull
    public static final StructureRenderUtil INSTANCE = new StructureRenderUtil();
    @NotNull
    private static final BufferBuilder blockBuf = new BufferBuilder(50000);

    private StructureRenderUtil() {
    }

    @NotNull
    public final int[] render(@NotNull Structure structure, @NotNull Color color, float brightness) {
        IBlockState state;
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        TemplateBlockAccess access = structure.getBlockAccess();
        blockBuf.func_178965_a();
        blockBuf.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (Template.BlockInfo info : structure.blockInfos()) {
            BlockPos blockPos = info.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos");
            state = access.func_180495_p(blockPos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE || state.func_177230_c().func_180664_k() != BlockRenderLayer.SOLID) continue;
            IBlockAccess iBlockAccess = access;
            BlockPos blockPos2 = info.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"pos");
            BlockPos blockPos3 = info.field_186242_a.func_177973_b((Vec3i)structure.getOrigin());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"subtract(...)");
            BlockRenderUtils.renderBlockToVB(state, iBlockAccess, blockPos2, blockPos3, blockBuf, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, brightness, (float)color.getAlpha() / 255.0f);
        }
        for (Template.BlockInfo info : structure.blockInfos()) {
            BlockPos blockPos = info.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos");
            state = access.func_180495_p(blockPos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE || state.func_177230_c().func_180664_k() != BlockRenderLayer.CUTOUT && state.func_177230_c().func_180664_k() != BlockRenderLayer.CUTOUT_MIPPED) continue;
            IBlockAccess iBlockAccess = access;
            BlockPos blockPos4 = info.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"pos");
            BlockPos blockPos5 = info.field_186242_a.func_177973_b((Vec3i)structure.getOrigin());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"subtract(...)");
            BlockRenderUtils.renderBlockToVB(state, iBlockAccess, blockPos4, blockPos5, blockBuf, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, brightness, (float)color.getAlpha() / 255.0f);
        }
        for (Template.BlockInfo info : structure.blockInfos()) {
            BlockPos blockPos = info.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"pos");
            state = access.func_180495_p(blockPos);
            if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE || state.func_177230_c().func_180664_k() != BlockRenderLayer.TRANSLUCENT) continue;
            IBlockAccess iBlockAccess = access;
            BlockPos blockPos6 = info.field_186242_a;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos6, (String)"pos");
            BlockPos blockPos7 = info.field_186242_a.func_177973_b((Vec3i)structure.getOrigin());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos7, (String)"subtract(...)");
            BlockRenderUtils.renderBlockToVB(state, iBlockAccess, blockPos6, blockPos7, blockBuf, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, brightness, (float)color.getAlpha() / 255.0f);
        }
        blockBuf.func_178977_d();
        IntBuffer intBuf = blockBuf.func_178966_f().asIntBuffer();
        int[] bufferInts = new int[intBuf.limit()];
        int n = bufferInts.length;
        for (int i = 0; i < n; ++i) {
            bufferInts[i] = intBuf.get(i);
        }
        return bufferInts;
    }
}

