/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.text;

import com.teamwizardry.librarianlib.features.math.Align2d;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.methodhandles.MethodHandleHelper;
import com.teamwizardry.librarianlib.features.text.TextLayoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 K2\u00020\u0001:\u0002JKB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020CJ\b\u0010E\u001a\u00020CH\u0002J\b\u0010F\u001a\u00020CH\u0002J\u0016\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020)R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R$\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R(\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R$\u0010 \u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R$\u0010$\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u0010/\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u001a\u00102\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010,\"\u0004\b4\u0010.R$\u00105\u001a\f\u0012\b\u0012\u000607R\u00020\u000006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006L"}, d2={"Lcom/teamwizardry/librarianlib/features/text/TextLayout;", "", "<init>", "()V", "value", "Lnet/minecraft/client/gui/FontRenderer;", "fontRenderer", "getFontRenderer", "()Lnet/minecraft/client/gui/FontRenderer;", "setFontRenderer", "(Lnet/minecraft/client/gui/FontRenderer;)V", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "", "wrapWidth", "getWrapWidth", "()I", "setWrapWidth", "(I)V", "maxWidth", "getMaxWidth", "setMaxWidth", "maxLines", "getMaxLines", "setMaxLines", "truncationText", "getTruncationText", "setTruncationText", "lineSpacing", "getLineSpacing", "setLineSpacing", "Lcom/teamwizardry/librarianlib/features/math/Align2d;", "align", "getAlign", "()Lcom/teamwizardry/librarianlib/features/math/Align2d;", "setAlign", "(Lcom/teamwizardry/librarianlib/features/math/Align2d;)V", "", "unicode", "getUnicode", "()Z", "setUnicode", "(Z)V", "enableUnicodeBidi", "getEnableUnicodeBidi", "setEnableUnicodeBidi", "changed", "getChanged", "setChanged", "runs", "", "Lcom/teamwizardry/librarianlib/features/text/TextLayout$TextRun;", "getRuns", "()Ljava/util/List;", "setRuns", "(Ljava/util/List;)V", "bounds", "Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "getBounds", "()Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "setBounds", "(Lcom/teamwizardry/librarianlib/features/math/Rect2d;)V", "genIfNeeded", "", "genRuns", "createRuns", "truncateRuns", "render", "color", "dropShadow", "TextRun", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nTextLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLayout.kt\ncom/teamwizardry/librarianlib/features/text/TextLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RectHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/RectHelpersKt\n*L\n1#1,199:1\n1863#2,2:200\n1863#2,2:205\n8#3:202\n8#3:203\n8#3:204\n*S KotlinDebug\n*F\n+ 1 TextLayout.kt\ncom/teamwizardry/librarianlib/features/text/TextLayout\n*L\n93#1:200,2\n167#1:205,2\n96#1:202\n131#1:203\n152#1:204\n*E\n"})
public final class TextLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FontRenderer fontRenderer;
    @NotNull
    private String text;
    private int wrapWidth;
    private int maxWidth;
    private int maxLines;
    @Nullable
    private String truncationText;
    private int lineSpacing;
    @NotNull
    private Align2d align;
    private boolean unicode;
    private boolean enableUnicodeBidi;
    private boolean changed;
    @NotNull
    private List<TextRun> runs;
    @NotNull
    private Rect2d bounds;
    @NotNull
    private static final Function2<FontRenderer, Object[], Object> sizeStringToWidth_mh;

    public TextLayout() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Intrinsics.checkNotNullExpressionValue((Object)fontRenderer, (String)"fontRenderer");
        this.fontRenderer = fontRenderer;
        this.text = "";
        this.wrapWidth = Integer.MAX_VALUE;
        this.maxWidth = Integer.MAX_VALUE;
        this.maxLines = Integer.MAX_VALUE;
        this.align = Align2d.TOP_LEFT;
        this.enableUnicodeBidi = true;
        this.runs = new ArrayList();
        this.bounds = Rect2d.ZERO;
    }

    @NotNull
    public final FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public final void setFontRenderer(@NotNull FontRenderer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.fontRenderer, (Object)value)) {
            this.changed = true;
        }
        this.fontRenderer = value;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.text, (Object)value)) {
            this.changed = true;
        }
        this.text = value;
    }

    public final int getWrapWidth() {
        return this.wrapWidth;
    }

    public final void setWrapWidth(int value) {
        if (this.wrapWidth != value) {
            this.changed = true;
        }
        this.wrapWidth = value;
    }

    public final int getMaxWidth() {
        return this.maxWidth;
    }

    public final void setMaxWidth(int value) {
        if (this.maxWidth != value) {
            this.changed = true;
        }
        this.maxWidth = value;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final void setMaxLines(int value) {
        if (this.maxLines != value) {
            this.changed = true;
        }
        this.maxLines = value;
    }

    @Nullable
    public final String getTruncationText() {
        return this.truncationText;
    }

    public final void setTruncationText(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.truncationText, (Object)value)) {
            this.changed = true;
        }
        this.truncationText = value;
    }

    public final int getLineSpacing() {
        return this.lineSpacing;
    }

    public final void setLineSpacing(int value) {
        if (this.lineSpacing != value) {
            this.changed = true;
        }
        this.lineSpacing = value;
    }

    @NotNull
    public final Align2d getAlign() {
        return this.align;
    }

    public final void setAlign(@NotNull Align2d value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.align != value) {
            this.changed = true;
        }
        this.align = value;
    }

    public final boolean getUnicode() {
        return this.unicode;
    }

    public final void setUnicode(boolean value) {
        if (this.unicode != value) {
            this.changed = true;
        }
        this.unicode = value;
    }

    public final boolean getEnableUnicodeBidi() {
        return this.enableUnicodeBidi;
    }

    public final void setEnableUnicodeBidi(boolean value) {
        if (this.enableUnicodeBidi != value) {
            this.changed = true;
        }
        this.enableUnicodeBidi = value;
    }

    public final boolean getChanged() {
        return this.changed;
    }

    public final void setChanged(boolean bl) {
        this.changed = bl;
    }

    @NotNull
    public final List<TextRun> getRuns() {
        return this.runs;
    }

    public final void setRuns(@NotNull List<TextRun> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.runs = list;
    }

    @NotNull
    public final Rect2d getBounds() {
        return this.bounds;
    }

    public final void setBounds(@NotNull Rect2d rect2d) {
        Intrinsics.checkNotNullParameter((Object)rect2d, (String)"<set-?>");
        this.bounds = rect2d;
    }

    public final void genIfNeeded() {
        if (this.changed) {
            this.changed = false;
            this.genRuns();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void genRuns() {
        this.runs.clear();
        this.bounds = Rect2d.ZERO;
        if (((CharSequence)this.text).length() == 0) {
            return;
        }
        if (this.unicode) {
            if (this.enableUnicodeBidi) {
                this.fontRenderer.func_78275_b(true);
            }
            this.fontRenderer.func_78264_a(true);
        }
        this.createRuns();
        this.truncateRuns();
        Rect2d bounds = null;
        Iterable $this$forEach$iv = this.runs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRun run = (TextRun)element$iv;
            boolean bl = false;
            Rect2d rect2d = bounds;
            if (rect2d == null || (rect2d = rect2d.expandToFit(run.getRect())) == null) {
                rect2d = run.getRect();
            }
            bounds = rect2d;
        }
        Rect2d rect2d = bounds;
        if (rect2d == null) {
            void width$iv;
            void y$iv;
            void x$iv;
            $i$f$forEach = false;
            boolean bl = false;
            boolean element$iv = false;
            boolean height$iv = false;
            boolean $i$f$rect = false;
            rect2d = this.bounds = new Rect2d((double)x$iv, (double)y$iv, (double)width$iv, (double)height$iv);
        }
        if (this.unicode) {
            if (this.enableUnicodeBidi) {
                this.fontRenderer.func_78275_b(false);
            }
            this.fontRenderer.func_78264_a(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createRuns() {
        int y = 0;
        String remaining = this.text;
        while (((CharSequence)remaining).length() > 0) {
            void height$iv;
            void width$iv;
            void y$iv;
            void x$iv;
            int x;
            int n;
            int i;
            int n2 = i = this.wrapWidth == 0 ? remaining.length() : TextLayout.Companion.sizeStringToWidth(this.fontRenderer, remaining, this.wrapWidth);
            if (i == 0 && !CharsKt.isWhitespace((char)remaining.charAt(0))) {
                throw new TextLayoutException("Could not wrap `" + remaining + "` to width " + this.wrapWidth);
            }
            String runString = null;
            if (remaining.length() <= i) {
                runString = remaining;
                remaining = "";
            } else {
                String string = remaining.substring(0, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                runString = string;
                char c0 = remaining.charAt(i);
                boolean flag = c0 == ' ' || c0 == '\n';
                StringBuilder stringBuilder = new StringBuilder().append(FontRenderer.func_78282_e((String)runString));
                String string2 = remaining.substring(i + (flag ? 1 : 0));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                remaining = stringBuilder.append(string2).toString();
            }
            int width = this.fontRenderer.func_78256_a(runString);
            switch (WhenMappings.$EnumSwitchMapping$0[this.align.getX().ordinal()]) {
                case 1: {
                    n = -width;
                    break;
                }
                case 2: {
                    n = -width / 2;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            int n3 = x = n;
            int n4 = y;
            int n5 = width;
            int n6 = this.fontRenderer.field_78288_b;
            boolean $i$f$rect = false;
            Rect2d rect = new Rect2d((double)x$iv, (double)y$iv, (double)width$iv, (double)height$iv);
            y += this.fontRenderer.field_78288_b + this.lineSpacing;
            TextRun run = new TextRun(runString, rect);
            this.runs.add(run);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void truncateRuns() {
        String truncationText = this.truncationText;
        if (truncationText != null && (this.runs.size() > this.maxLines || ((TextRun)CollectionsKt.last(this.runs)).getRect().getWidth() > (double)this.maxWidth)) {
            int truncationWidth;
            this.runs = CollectionsKt.toMutableList((Collection)CollectionsKt.dropLast(this.runs, (int)(this.runs.size() - this.maxLines)));
            TextRun lastRun = (TextRun)CollectionsKt.last(this.runs);
            int maxWidth = Math.min(this.wrapWidth, this.maxWidth);
            int remainingWidth = maxWidth - (truncationWidth = this.fontRenderer.func_78256_a(truncationText));
            if (remainingWidth > 0) {
                void height$iv;
                void width$iv;
                void y$iv;
                void x$iv;
                String truncatedString = this.fontRenderer.func_78269_a(lastRun.getText(), remainingWidth) + truncationText;
                double d = lastRun.getRect().getX();
                double d2 = lastRun.getRect().getY();
                int n = this.fontRenderer.func_78256_a(truncatedString);
                double d3 = lastRun.getRect().getHeight();
                boolean $i$f$rect = false;
                this.runs.set(CollectionsKt.getLastIndex(this.runs), new TextRun(truncatedString, new Rect2d((double)x$iv, (double)y$iv, (double)width$iv, (double)height$iv)));
            }
        }
    }

    public final void render(int color, boolean dropShadow) {
        if (this.unicode) {
            if (this.enableUnicodeBidi) {
                this.fontRenderer.func_78275_b(true);
            }
            this.fontRenderer.func_78264_a(true);
        }
        Iterable $this$forEach$iv = this.runs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRun it = (TextRun)element$iv;
            boolean bl = false;
            it.render(color, dropShadow);
        }
        if (this.unicode) {
            if (this.enableUnicodeBidi) {
                this.fontRenderer.func_78275_b(false);
            }
            this.fontRenderer.func_78264_a(false);
        }
    }

    static {
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        sizeStringToWidth_mh = MethodHandleHelper.wrapperForMethod(FontRenderer.class, "sizeStringToWidth", "func_78259_e", classArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/teamwizardry/librarianlib/features/text/TextLayout$Companion;", "", "<init>", "()V", "sizeStringToWidth_mh", "Lkotlin/Function2;", "Lnet/minecraft/client/gui/FontRenderer;", "", "sizeStringToWidth", "", "str", "", "wrapWidth", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        private final int sizeStringToWidth(FontRenderer $this$sizeStringToWidth, String str, int wrapWidth) {
            Object[] objectArray = new Object[]{str, wrapWidth};
            Object object = sizeStringToWidth_mh.invoke((Object)$this$sizeStringToWidth, (Object)objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            return (Integer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/teamwizardry/librarianlib/features/text/TextLayout$TextRun;", "", "text", "", "rect", "Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "<init>", "(Lcom/teamwizardry/librarianlib/features/text/TextLayout;Ljava/lang/String;Lcom/teamwizardry/librarianlib/features/math/Rect2d;)V", "getText", "()Ljava/lang/String;", "getRect", "()Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "render", "", "color", "", "dropShadow", "", "LibrarianLib-Continuous-1.12.2"})
    public final class TextRun {
        @NotNull
        private final String text;
        @NotNull
        private final Rect2d rect;

        public TextRun(@NotNull String text, Rect2d rect) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            this.text = text;
            this.rect = rect;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Rect2d getRect() {
            return this.rect;
        }

        public final void render(int color, boolean dropShadow) {
            TextLayout.this.getFontRenderer().func_175065_a(this.text, this.rect.getXf(), this.rect.getYf(), color, dropShadow);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Align2d.X.values().length];
            try {
                nArray[Align2d.X.RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align2d.X.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

