/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.text;

import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/teamwizardry/librarianlib/features/text/UnicodeBlock;", "", "name", "", "range", "Lkotlin/ranges/IntRange;", "<init>", "(Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getName", "()Ljava/lang/String;", "getRange", "()Lkotlin/ranges/IntRange;", "Companion", "LibrarianLib-Continuous-1.12.2"})
public final class UnicodeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final IntRange range;
    @NotNull
    private static final Map<String, UnicodeBlock> blocks = new LinkedHashMap();
    private static final TreeRangeMap<Integer, UnicodeBlock> ranges = TreeRangeMap.create();

    private UnicodeBlock(String name, IntRange range) {
        this.name = name;
        this.range = range;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final IntRange getRange() {
        return this.range;
    }

    static {
        URL uRL = UnicodeBlock.class.getResource("ucd/Blocks.txt");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String blocksFile = new String(byArray, charset);
        Regex lineRegex = new Regex("([0-9A-F]+)\\.\\.([0-9A-F]+); (.+)");
        for (String line : StringsKt.lineSequence((CharSequence)blocksFile)) {
            MatchResult matchResult;
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)line) || (matchResult = lineRegex.matchEntire((CharSequence)line)) == null || (matchResult = matchResult.getDestructured()) == null) continue;
            MatchResult matchResult2 = matchResult;
            String min = (String)matchResult2.getMatch().getGroupValues().get(1);
            String max = (String)matchResult2.getMatch().getGroupValues().get(2);
            String name = (String)matchResult2.getMatch().getGroupValues().get(3);
            UnicodeBlock block = new UnicodeBlock(name, new IntRange(Integer.parseInt(min, CharsKt.checkRadix((int)16)), Integer.parseInt(max, CharsKt.checkRadix((int)16))));
            blocks.put(name, block);
            ranges.put(Range.closed((Comparable)block.range.getStart(), (Comparable)block.range.getEndInclusive()), (Object)block);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\nH\u0086\u0002J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u0007 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\r\u0012\u0004\b\f\u0010\u0003\u00a8\u0006\u0011"}, d2={"Lcom/teamwizardry/librarianlib/features/text/UnicodeBlock$Companion;", "", "<init>", "()V", "blocks", "", "", "Lcom/teamwizardry/librarianlib/features/text/UnicodeBlock;", "ranges", "Lcom/google/common/collect/TreeRangeMap;", "", "kotlin.jvm.PlatformType", "getRanges$annotations", "Lcom/google/common/collect/TreeRangeMap;", "get", "ch", "name", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getRanges$annotations() {
        }

        @Nullable
        public final UnicodeBlock get(int ch) {
            return (UnicodeBlock)ranges.get((Comparable)Integer.valueOf(ch));
        }

        @Nullable
        public final UnicodeBlock get(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (UnicodeBlock)blocks.get(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

