/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.utilities;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u000f"}, d2={"MATCHER", "Lkotlin/text/Regex;", "TOKENIZER", "getObject", "Lnet/minecraft/nbt/NBTBase;", "Lnet/minecraft/nbt/NBTTagCompound;", "key", "", "CLASSES", "", "Ljava/lang/Class;", "[Ljava/lang/Class;", "setObject", "", "tag", "LibrarianLib-Continuous-1.12.2"})
public final class NBTUtilKt {
    @NotNull
    private static final Regex MATCHER = new Regex("(?:(?:(?:\\[\\d+])|(?:[^.\\[\\]]+))(\\.|$|(?=\\[)))+");
    @NotNull
    private static final Regex TOKENIZER = new Regex("((?:\\[\\d+])|(?:[^.\\[\\]]+))(?=[.\\[]|$)");
    @NotNull
    private static final Class<? extends NBTBase>[] CLASSES;

    @Nullable
    public static final NBTBase getObject(@NotNull NBTTagCompound $this$getObject, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!MATCHER.matches((CharSequence)key)) {
            return null;
        }
        NBTBase currentElement = (NBTBase)$this$getObject;
        Sequence matched = Regex.findAll$default((Regex)TOKENIZER, (CharSequence)key, (int)0, (int)2, null);
        for (MatchResult match : matched) {
            String m = (String)match.getGroupValues().get(1);
            if (StringsKt.startsWith$default((String)m, (String)"[", (boolean)false, (int)2, null)) {
                NBTBase nBTBase;
                int ind = Integer.parseInt(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)m, (CharSequence)"["), (CharSequence)"]"));
                NBTBase nBTBase2 = currentElement;
                if (nBTBase2 instanceof NBTTagList) {
                    if (((NBTTagList)currentElement).func_74745_c() < ind + 1) {
                        return null;
                    }
                    nBTBase = ((NBTTagList)currentElement).func_179238_g(ind);
                } else if (nBTBase2 instanceof NBTTagByteArray) {
                    if (((NBTTagByteArray)currentElement).func_150292_c().length < ind + 1) {
                        return null;
                    }
                    nBTBase = (NBTBase)new NBTTagByte(((NBTTagByteArray)currentElement).func_150292_c()[ind]);
                } else if (nBTBase2 instanceof NBTTagIntArray) {
                    if (((NBTTagIntArray)currentElement).func_150302_c().length < ind + 1) {
                        return null;
                    }
                    nBTBase = (NBTBase)new NBTTagInt(((NBTTagIntArray)currentElement).func_150302_c()[ind]);
                } else {
                    return null;
                }
                currentElement = nBTBase;
                continue;
            }
            if (currentElement instanceof NBTTagCompound) {
                if (!((NBTTagCompound)currentElement).func_74764_b(m)) {
                    return null;
                }
                currentElement = ((NBTTagCompound)currentElement).func_74781_a(m);
                continue;
            }
            return null;
        }
        return currentElement;
    }

    public static final boolean setObject(@NotNull NBTTagCompound $this$setObject, @NotNull String key, @NotNull NBTBase tag) {
        Intrinsics.checkNotNullParameter((Object)$this$setObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!MATCHER.matches((CharSequence)key)) {
            return false;
        }
        NBTBase currentElement = (NBTBase)$this$setObject;
        List matched = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)TOKENIZER, (CharSequence)key, (int)0, (int)2, null));
        int max = matched.size() - 1;
        Iterator iterator2 = ((Iterable)matched).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            boolean done;
            int index = n++;
            MatchResult match = (MatchResult)iterator2.next();
            String m = (String)match.getGroupValues().get(1);
            boolean bl = done = index == max;
            if (StringsKt.startsWith$default((String)m, (String)"[", (boolean)false, (int)2, null)) {
                int ind = Integer.parseInt(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)m, (CharSequence)"["), (CharSequence)"]"));
                if (currentElement instanceof NBTTagList) {
                    if (((NBTTagList)currentElement).func_74745_c() < ind + 1 && !done) {
                        NBTBase nBTBase;
                        if ((((NBTTagList)currentElement).func_150303_d() == 0 || ((NBTTagList)currentElement).func_150303_d() == 9) && StringsKt.startsWith$default((String)((String)((MatchResult)matched.get(index + 1)).getGroupValues().get(1)), (String)"[", (boolean)false, (int)2, null)) {
                            nBTBase = (NBTBase)new NBTTagList();
                        } else if (((NBTTagList)currentElement).func_150303_d() == 0 || ((NBTTagList)currentElement).func_150303_d() == 10) {
                            nBTBase = (NBTBase)new NBTTagCompound();
                        } else {
                            return false;
                        }
                        NBTBase nBTBase2 = nBTBase;
                        ((NBTTagList)currentElement).func_74742_a(nBTBase2);
                        currentElement = nBTBase2;
                        continue;
                    }
                    if (!done) {
                        currentElement = ((NBTTagList)currentElement).func_179238_g(ind);
                        continue;
                    }
                    int type = ((NBTTagList)currentElement).func_150303_d();
                    if (type == 0) {
                        type = 6;
                    }
                    NBTBase transformedTag = NBTHelper.castOrDefault(tag, CLASSES[type]);
                    if (ind >= ((NBTTagList)currentElement).func_74745_c()) {
                        ((NBTTagList)currentElement).func_74742_a(transformedTag);
                        continue;
                    }
                    ((NBTTagList)currentElement).func_150304_a(ind, transformedTag);
                    continue;
                }
                if (currentElement instanceof NBTTagByteArray) {
                    if (((NBTTagByteArray)currentElement).func_150292_c().length < ind + 1 || !done || !(tag instanceof NBTPrimitive)) {
                        return false;
                    }
                    ((NBTTagByteArray)currentElement).func_150292_c()[ind] = ((NBTPrimitive)tag).func_150290_f();
                    continue;
                }
                if (currentElement instanceof NBTTagIntArray) {
                    if (((NBTTagIntArray)currentElement).func_150302_c().length < ind + 1 || !done || !(tag instanceof NBTPrimitive)) {
                        return false;
                    }
                    ((NBTTagIntArray)currentElement).func_150302_c()[ind] = ((NBTPrimitive)tag).func_150287_d();
                    continue;
                }
                return false;
            }
            if (currentElement instanceof NBTTagCompound) {
                if (!((NBTTagCompound)currentElement).func_74764_b(m) && !done) {
                    NBTBase nBTBase = StringsKt.startsWith$default((String)((String)((MatchResult)matched.get(index + 1)).getGroupValues().get(1)), (String)"[", (boolean)false, (int)2, null) ? (NBTBase)new NBTTagList() : (NBTBase)new NBTTagCompound();
                    ((NBTTagCompound)currentElement).func_74782_a(m, nBTBase);
                    currentElement = nBTBase;
                    continue;
                }
                if (!done) {
                    currentElement = ((NBTTagCompound)currentElement).func_74781_a(m);
                    continue;
                }
                ((NBTTagCompound)currentElement).func_74782_a(m, tag);
                continue;
            }
            return false;
        }
        return true;
    }

    static {
        Class[] classArray = new Class[]{NBTTagEnd.class, NBTTagByte.class, NBTTagShort.class, NBTTagInt.class, NBTTagLong.class, NBTTagFloat.class, NBTTagDouble.class, NBTTagByteArray.class, NBTTagString.class, NBTTagList.class, NBTTagCompound.class, NBTTagIntArray.class};
        CLASSES = classArray;
    }
}

