/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.utilities;

import com.teamwizardry.librarianlib.features.utilities.ClientRayWorldCollider;
import com.teamwizardry.librarianlib.features.utilities.RayHitResult;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013JJ\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u0018H\u0007J`\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0002J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/teamwizardry/librarianlib/features/utilities/RayWorldCollider;", "", "world", "Lnet/minecraft/world/World;", "<init>", "(Lnet/minecraft/world/World;)V", "worldRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getWorld", "()Lnet/minecraft/world/World;", "cache", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "countdown", "", "cacheResetTimer", "requestRefresh", "", "collide", "result", "Lcom/teamwizardry/librarianlib/features/utilities/RayHitResult;", "posX", "", "posY", "posZ", "velX", "velY", "velZ", "maxBounds", "aabb", "blockX", "blockY", "blockZ", "invVelX", "invVelY", "invVelZ", "mutablePos", "Lnet/minecraft/util/math/BlockPos$MutableBlockPos;", "infiniteAABB", "getAABBs", "x", "y", "z", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nRayWorldCollider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RayWorldCollider.kt\ncom/teamwizardry/librarianlib/features/utilities/RayWorldCollider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1#2:363\n*E\n"})
public final class RayWorldCollider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<World> worldRef;
    @NotNull
    private final Long2ObjectOpenHashMap<List<AxisAlignedBB>> cache;
    private int countdown;
    @JvmField
    public int cacheResetTimer;
    @NotNull
    private final BlockPos.MutableBlockPos mutablePos;
    @NotNull
    private final AxisAlignedBB infiniteAABB;
    @NotNull
    private static final WeakHashMap<World, RayWorldCollider> worldMap = new WeakHashMap();

    private RayWorldCollider(World world) {
        this.worldRef = new WeakReference<World>(world);
        this.cache = new Long2ObjectOpenHashMap();
        this.cacheResetTimer = 10;
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.infiniteAABB = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private final World getWorld() {
        Object t = this.worldRef.get();
        Intrinsics.checkNotNull(t);
        return (World)t;
    }

    public final void requestRefresh() {
        this.cache.clear();
    }

    @JvmOverloads
    public final void collide(@NotNull RayHitResult result, double posX, double posY, double posZ, double velX, double velY, double velZ, double maxBounds) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.collisionFraction = 1.0;
        result.collisionNormalX = 0.0;
        result.collisionNormalY = 0.0;
        result.collisionNormalZ = 0.0;
        result.collisionBlockX = 0;
        result.collisionBlockY = 0;
        result.collisionBlockZ = 0;
        double velX2 = Math.min(maxBounds, Math.max(-maxBounds, velX));
        double velY2 = Math.min(maxBounds, Math.max(-maxBounds, velY));
        double velZ2 = Math.min(maxBounds, Math.max(-maxBounds, velZ));
        int minX = (int)Math.floor(Math.min(posX, posX + velX2));
        int minY = (int)Math.floor(Math.min(posY, posY + velY2));
        int minZ = (int)Math.floor(Math.min(posZ, posZ + velZ2));
        int maxX = (int)Math.floor(Math.max(posX, posX + velX2));
        int maxY = (int)Math.floor(Math.max(posY, posY + velY2));
        int maxZ = (int)Math.floor(Math.max(posZ, posZ + velZ2));
        double invVelX = 1.0 / velX2;
        double invVelY = 1.0 / velY2;
        double invVelZ = 1.0 / velZ2;
        int x = minX;
        if (x <= maxX) {
            while (true) {
                int y;
                if ((y = minY) <= maxY) {
                    while (true) {
                        int z;
                        if ((z = minZ) <= maxZ) {
                            while (true) {
                                List<AxisAlignedBB> list = this.getAABBs(x, y, z);
                                int n = list.size();
                                for (int i = 0; i < n; ++i) {
                                    this.collide(result, list.get(i), x, y, z, posX, posY, posZ, invVelX, invVelY, invVelZ);
                                }
                                if (z == maxZ) break;
                                ++z;
                            }
                        }
                        if (y == maxY) break;
                        ++y;
                    }
                }
                if (x == maxX) break;
                ++x;
            }
        }
    }

    public static /* synthetic */ void collide$default(RayWorldCollider rayWorldCollider, RayHitResult rayHitResult, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, Object object) {
        if ((n & 0x80) != 0) {
            d7 = 5.0;
        }
        rayWorldCollider.collide(rayHitResult, d, d2, d3, d4, d5, d6, d7);
    }

    private final void collide(RayHitResult result, AxisAlignedBB aabb, int blockX, int blockY, int blockZ, double posX, double posY, double posZ, double invVelX, double invVelY, double invVelZ) {
        double tx1 = (aabb.field_72340_a - posX) * invVelX;
        double tx2 = (aabb.field_72336_d - posX) * invVelX;
        double tmin = Math.min(tx1, tx2);
        double tmax = Math.max(tx1, tx2);
        double ty1 = (aabb.field_72338_b - posY) * invVelY;
        double ty2 = (aabb.field_72337_e - posY) * invVelY;
        tmin = Math.max(tmin, Math.min(ty1, ty2));
        tmax = Math.min(tmax, Math.max(ty1, ty2));
        double tz1 = (aabb.field_72339_c - posZ) * invVelZ;
        double tz2 = (aabb.field_72334_f - posZ) * invVelZ;
        tmin = Math.max(tmin, Math.min(tz1, tz2));
        if ((tmax = Math.min(tmax, Math.max(tz1, tz2))) >= tmin && tmax >= 0.0 && tmin >= 0.0 && tmin < result.collisionFraction) {
            result.collisionNormalX = tmin == tx1 ? -1.0 : (tmin == tx2 ? 1.0 : 0.0);
            result.collisionNormalY = tmin == ty1 ? -1.0 : (tmin == ty2 ? 1.0 : 0.0);
            result.collisionNormalZ = tmin == tz1 ? -1.0 : (tmin == tz2 ? 1.0 : 0.0);
            result.collisionBlockX = blockX;
            result.collisionBlockY = blockY;
            result.collisionBlockZ = blockZ;
            result.collisionFraction = tmin;
            return;
        }
    }

    private final List<AxisAlignedBB> getAABBs(int x, int y, int z) {
        this.mutablePos.func_181079_c(x, y, z);
        List list = (List)this.cache.get(this.mutablePos.func_177986_g());
        if (list != null) {
            List it = list;
            boolean bl = false;
            return it;
        }
        List list2 = null;
        if (!this.getWorld().func_175667_e((BlockPos)this.mutablePos) || this.mutablePos.func_177956_o() < 0 || this.mutablePos.func_177956_o() > this.getWorld().func_72940_L()) {
            list2 = CollectionsKt.emptyList();
        } else {
            IBlockState iBlockState = this.getWorld().func_180495_p((BlockPos)this.mutablePos);
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBlockState(...)");
            IBlockState blockstate = iBlockState;
            if (Intrinsics.areEqual((Object)blockstate.func_185904_a(), (Object)Material.field_151579_a) || !blockstate.func_185904_a().func_76230_c() || blockstate.func_185904_a().func_76224_d()) {
                list2 = CollectionsKt.emptyList();
            } else {
                list2 = new ArrayList(1);
                blockstate.func_185908_a(this.getWorld(), (BlockPos)this.mutablePos, this.infiniteAABB, list2, null, false);
            }
        }
        ((Map)this.cache).put(this.mutablePos.func_177986_g(), list2);
        return list2;
    }

    @JvmOverloads
    public final void collide(@NotNull RayHitResult result, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        RayWorldCollider.collide$default(this, result, posX, posY, posZ, velX, velY, velZ, 0.0, 128, null);
    }

    @SubscribeEvent
    @JvmStatic
    public static final void tick(@NotNull TickEvent.ClientTickEvent e) {
        Companion.tick(e);
    }

    @JvmStatic
    @NotNull
    public static final RayWorldCollider get(@NotNull World world) {
        return Companion.get(world);
    }

    @Nullable
    public static final RayWorldCollider getClient() {
        return Companion.getClient();
    }

    public /* synthetic */ RayWorldCollider(World world, DefaultConstructorMarker $constructor_marker) {
        this(world);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0011\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0087\u0002R\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/teamwizardry/librarianlib/features/utilities/RayWorldCollider$Companion;", "", "<init>", "()V", "worldMap", "Ljava/util/WeakHashMap;", "Lnet/minecraft/world/World;", "Lcom/teamwizardry/librarianlib/features/utilities/RayWorldCollider;", "getWorldMap$annotations", "tick", "", "e", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "get", "world", "client", "getClient$annotations", "getClient", "()Lcom/teamwizardry/librarianlib/features/utilities/RayWorldCollider;", "LibrarianLib-Continuous-1.12.2"})
    @SourceDebugExtension(value={"SMAP\nRayWorldCollider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RayWorldCollider.kt\ncom/teamwizardry/librarianlib/features/utilities/RayWorldCollider$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,362:1\n381#2,7:363\n*S KotlinDebug\n*F\n+ 1 RayWorldCollider.kt\ncom/teamwizardry/librarianlib/features/utilities/RayWorldCollider$Companion\n*L\n242#1:363,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getWorldMap$annotations() {
        }

        @SubscribeEvent
        @JvmStatic
        public final void tick(@NotNull TickEvent.ClientTickEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            for (RayWorldCollider value : worldMap.values()) {
                if (value.cacheResetTimer == -1) {
                    return;
                }
                if (value.cache.size() == 0) {
                    value.countdown = value.cacheResetTimer;
                    return;
                }
                if (value.countdown <= 0) {
                    value.cache.clear();
                    value.countdown = value.cacheResetTimer;
                }
                int n = value.countdown;
                value.countdown = n + -1;
            }
        }

        @JvmStatic
        @NotNull
        public final RayWorldCollider get(@NotNull World world) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Map $this$getOrPut$iv = worldMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(world);
            if (value$iv == null) {
                boolean bl = false;
                RayWorldCollider answer$iv = new RayWorldCollider(world, null);
                $this$getOrPut$iv.put(world, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (RayWorldCollider)object;
        }

        @Nullable
        public final RayWorldCollider getClient() {
            Ref.ObjectRef handler = new Ref.ObjectRef();
            ClientRunnable.run(() -> Companion._get_client_$lambda$1(handler));
            return (RayWorldCollider)handler.element;
        }

        @JvmStatic
        public static /* synthetic */ void getClient$annotations() {
        }

        private static final void _get_client_$lambda$1(Ref.ObjectRef $handler) {
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            $handler.element = ClientRayWorldCollider.INSTANCE.get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

