/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.utilities;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J4\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\tH\u0007\u00a8\u0006\u0015"}, d2={"Lcom/teamwizardry/librarianlib/features/utilities/RaycastUtils;", "", "<init>", "()V", "raycast", "Lnet/minecraft/util/math/RayTraceResult;", "e", "Lnet/minecraft/entity/Entity;", "len", "", "stopOnLiquid", "", "world", "Lnet/minecraft/world/World;", "origin", "Lnet/minecraft/util/math/Vec3d;", "ray", "start", "end", "getEntityLookedAt", "maxDistance", "LibrarianLib-Continuous-1.12.2"})
public final class RaycastUtils {
    @NotNull
    public static final RaycastUtils INSTANCE = new RaycastUtils();

    private RaycastUtils() {
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final RayTraceResult raycast(@NotNull Entity e, double len, boolean stopOnLiquid) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityPlayer entityPlayer = e instanceof EntityPlayer ? (EntityPlayer)e : null;
        Vec3d vec = e.func_174791_d().func_72441_c(0.0, entityPlayer != null ? (double)entityPlayer.func_70047_e() : 0.0, 0.0);
        Vec3d look = e.func_70040_Z();
        World world = e.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
        Intrinsics.checkNotNull((Object)vec);
        Intrinsics.checkNotNull((Object)look);
        return RaycastUtils.raycast(world, vec, look, len, stopOnLiquid);
    }

    public static /* synthetic */ RayTraceResult raycast$default(Entity entity, double d, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return RaycastUtils.raycast(entity, d, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final RayTraceResult raycast(@NotNull World world, @NotNull Vec3d origin, @NotNull Vec3d ray, double len, boolean stopOnLiquid) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)ray, (String)"ray");
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        Intrinsics.checkNotNull((Object)end);
        return RaycastUtils.raycast(world, origin, end, stopOnLiquid);
    }

    public static /* synthetic */ RayTraceResult raycast$default(World world, Vec3d vec3d, Vec3d vec3d2, double d, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return RaycastUtils.raycast(world, vec3d, vec3d2, d, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final RayTraceResult raycast(@NotNull World world, @NotNull Vec3d start, @NotNull Vec3d end, boolean stopOnLiquid) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return world.func_147447_a(start, end, stopOnLiquid, false, true);
    }

    public static /* synthetic */ RayTraceResult raycast$default(World world, Vec3d vec3d, Vec3d vec3d2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return RaycastUtils.raycast(world, vec3d, vec3d2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Entity getEntityLookedAt(@NotNull Entity e, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Entity foundEntity = null;
        double distance = maxDistance;
        RayTraceResult pos2 = RaycastUtils.raycast$default(e, maxDistance, false, 4, null);
        Vec3d positionVector = e.func_174791_d();
        if (e instanceof EntityPlayer) {
            positionVector = positionVector.func_72441_c(0.0, (double)((EntityPlayer)e).func_70047_e(), 0.0);
        }
        if (pos2 != null) {
            distance = pos2.field_72307_f.func_72438_d(positionVector);
        }
        Vec3d lookVector = e.func_70040_Z();
        Vec3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * maxDistance, lookVector.field_72448_b * maxDistance, lookVector.field_72449_c * maxDistance);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.field_70170_p.func_72839_b(e, e.func_174813_aQ().func_72321_a(lookVector.field_72450_a * maxDistance, lookVector.field_72448_b * maxDistance, lookVector.field_72449_c * maxDistance).func_72321_a(1.0, 1.0, 1.0));
        double minDistance = distance;
        Iterator var14 = entitiesInBoundingBox.iterator();
        while (var14.hasNext()) {
            Entity next = (Entity)var14.next();
            if (next.func_70067_L()) {
                double distanceToEntity;
                float collisionBorderSize = next.func_70111_Y();
                AxisAlignedBB hitbox = next.func_174813_aQ().func_72321_a((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                RayTraceResult interceptPosition = hitbox.func_72327_a(positionVector, reachVector);
                if (hitbox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = next;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition != null && ((distanceToEntity = positionVector.func_72438_d(interceptPosition.field_72307_f)) < minDistance || minDistance == 0.0)) {
                    lookedEntity = next;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || minDistance >= distance && pos2 != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    public static /* synthetic */ Entity getEntityLookedAt$default(Entity entity, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 32.0;
        }
        return RaycastUtils.getEntityLookedAt(entity, d);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final RayTraceResult raycast(@NotNull Entity e, double len) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return RaycastUtils.raycast$default(e, len, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final RayTraceResult raycast(@NotNull World world, @NotNull Vec3d origin, @NotNull Vec3d ray, double len) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)ray, (String)"ray");
        return RaycastUtils.raycast$default(world, origin, ray, len, false, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final RayTraceResult raycast(@NotNull World world, @NotNull Vec3d start, @NotNull Vec3d end) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return RaycastUtils.raycast$default(world, start, end, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Entity getEntityLookedAt(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return RaycastUtils.getEntityLookedAt$default(e, 0.0, 2, null);
    }
}

