/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.worlddata;

import com.teamwizardry.librarianlib.features.chunkdata.ChunkDataRegistry;
import com.teamwizardry.librarianlib.features.chunkdata.ChunkDataRegistryItem;
import com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.helpers.ThreadLocalDelegate;
import com.teamwizardry.librarianlib.features.worlddata.WorldData;
import com.teamwizardry.librarianlib.features.worlddata.WorldDataRegistry;
import com.teamwizardry.librarianlib.features.worlddata.WorldDataRegistryItem;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer;", "Lnet/minecraft/world/storage/WorldSavedData;", "ident", "", "<init>", "(Ljava/lang/String;)V", "world", "Lnet/minecraft/world/World;", "getWorld", "()Lnet/minecraft/world/World;", "datas", "", "Ljava/lang/Class;", "Lcom/teamwizardry/librarianlib/features/worlddata/WorldData;", "getDatas", "()Ljava/util/Map;", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "", "nbt", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nWorldDataContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldDataContainer.kt\ncom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,75:1\n1863#2,2:76\n216#3,2:78\n216#3,2:80\n*S KotlinDebug\n*F\n+ 1 WorldDataContainer.kt\ncom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer\n*L\n47#1:76,2\n57#1:78,2\n68#1:80,2\n*E\n"})
public final class WorldDataContainer
extends WorldSavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    @NotNull
    private final Map<Class<?>, WorldData> datas;
    @NotNull
    public static final String NAME = "librarianlib:worlddata";
    @NotNull
    private static final ThreadLocalDelegate<World> gettingWorld$delegate = CommonUtilMethods.threadLocal();

    public WorldDataContainer(@NotNull String ident) {
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        super(NAME);
        World world = WorldDataContainer.Companion.getGettingWorld();
        if (world == null) {
            throw new IllegalStateException("WorldDataContainer.gettingWorld is null! Did you not call WorldDataContainer.get()?");
        }
        this.world = world;
        this.datas = new LinkedHashMap();
        Iterable $this$forEach$iv = WorldDataRegistry.getApplicable(this.world);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorldDataRegistryItem it = (WorldDataRegistryItem)element$iv;
            boolean bl = false;
            WorldData data = (WorldData)it.getConstructor().invoke((Object)this);
            data.setName(it.getName());
            this.datas.put(it.getClazz(), data);
        }
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final Map<Class<?>, WorldData> getDatas() {
        return this.datas;
    }

    @NotNull
    public NBTTagCompound func_189551_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        NBTTagCompound parent2 = new NBTTagCompound();
        compound.func_74782_a("data", (NBTBase)parent2);
        Map<Class<?>, WorldData> $this$forEach$iv = this.datas;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<?>, WorldData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Class<?>, WorldData> element$iv;
            Map.Entry<Class<?>, WorldData> it = element$iv = iterator2.next();
            boolean bl = false;
            Object object = ChunkDataRegistry.get(it.getKey());
            if (object == null || (object = ((ChunkDataRegistryItem)object).getName()) == null || (object = object.toString()) == null) continue;
            Object name = object;
            NBTTagCompound tag = new NBTTagCompound();
            it.getValue().saveToNBT(tag);
            parent2.func_74782_a((String)name, (NBTBase)tag);
        }
        return compound;
    }

    public void func_76184_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        NBTTagCompound parent2 = nbt.func_74775_l("data");
        Map<Class<?>, WorldData> $this$forEach$iv = this.datas;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<?>, WorldData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Class<?>, WorldData> element$iv;
            Map.Entry<Class<?>, WorldData> it = element$iv = iterator2.next();
            boolean bl = false;
            Object object = ChunkDataRegistry.get(it.getKey());
            if (object == null || (object = ((ChunkDataRegistryItem)object).getName()) == null || (object = object.toString()) == null) continue;
            Object name = object;
            NBTTagCompound tag = parent2.func_74775_l((String)name);
            Intrinsics.checkNotNull((Object)tag);
            it.getValue().loadFromNBT(tag);
        }
    }

    @JvmStatic
    @SubscribeEvent
    public static final void load(@NotNull WorldEvent.Load e) {
        Companion.load(e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R/\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer$Companion;", "", "<init>", "()V", "NAME", "", "load", "", "e", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "get", "Lcom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer;", "world", "Lnet/minecraft/world/World;", "<set-?>", "gettingWorld", "getGettingWorld", "()Lnet/minecraft/world/World;", "setGettingWorld", "(Lnet/minecraft/world/World;)V", "gettingWorld$delegate", "Lcom/teamwizardry/librarianlib/features/helpers/ThreadLocalDelegate;", "LibrarianLib-Continuous-1.12.2"})
    @SourceDebugExtension(value={"SMAP\nWorldDataContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldDataContainer.kt\ncom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @JvmStatic
        @SubscribeEvent
        public final void load(@NotNull WorldEvent.Load e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            World world = e.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            this.get(world);
        }

        @NotNull
        public final WorldDataContainer get(@NotNull World world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            this.setGettingWorld(world);
            WorldSavedData worldSavedData = world.getPerWorldStorage().func_75742_a(WorldDataContainer.class, WorldDataContainer.NAME);
            WorldDataContainer worldDataContainer = worldSavedData instanceof WorldDataContainer ? (WorldDataContainer)worldSavedData : null;
            if (worldDataContainer == null) {
                WorldSavedData it = worldSavedData = new WorldDataContainer(WorldDataContainer.NAME);
                boolean bl = false;
                world.getPerWorldStorage().func_75745_a(WorldDataContainer.NAME, it);
                worldDataContainer = worldSavedData;
            }
            WorldDataContainer wdc = worldDataContainer;
            this.setGettingWorld(null);
            return wdc;
        }

        private final World getGettingWorld() {
            return (World)gettingWorld$delegate.getValue(this, $$delegatedProperties[0]);
        }

        private final void setGettingWorld(World world) {
            gettingWorld$delegate.setValue(this, $$delegatedProperties[0], world);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Companion.class, "gettingWorld", "getGettingWorld()Lnet/minecraft/world/World;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

