/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.configure;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public abstract class SubGuiModeSelector
extends SubGuiConfigure {
    public LittleGridContext context;
    public PlacementMode mode;
    public List<String> names;

    public SubGuiModeSelector(ItemStack stack, LittleGridContext context, PlacementMode mode) {
        super(150, 150, stack);
        this.context = context;
        this.mode = mode;
    }

    public void createControls() {
        this.names = new ArrayList<String>(PlacementMode.getModeNames());
        GuiComboBox box = new GuiComboBox("mode", 0, 0, 120, new ArrayList<String>(PlacementMode.getLocalizedModeNames()));
        box.select(I18n.func_74838_a((String)this.mode.name));
        this.controls.add(box);
        this.controls.add(new GuiTextBox("text", "", 0, 22, 120));
        GuiComboBox contextBox = new GuiComboBox("grid", 128, 0, 15, LittleGridContext.getNames());
        contextBox.select(ItemMultiTiles.currentContext.size + "");
        this.controls.add(contextBox);
        this.onControlChanged(new GuiControlChangedEvent((GuiControl)box));
    }

    public PlacementMode getMode() {
        GuiComboBox box = (GuiComboBox)this.get("mode");
        if (box.index == -1) {
            return PlacementMode.getDefault();
        }
        return PlacementMode.getModeOrDefault(this.names.get(box.index));
    }

    @CustomEventSubscribe
    public void onControlChanged(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"mode"})) {
            PlacementMode mode = this.getMode();
            ((GuiTextBox)this.get("text")).setText((mode.canPlaceStructures() ? ChatFormatting.BOLD + I18n.func_74838_a((String)"placement.mode.placestructure") + '\n' + ChatFormatting.WHITE : "") + I18n.func_74838_a((String)(mode.name + ".tooltip")));
        }
    }

    public abstract void saveConfiguration(LittleGridContext var1, PlacementMode var2);

    @Override
    public void saveConfiguration() {
        this.mode = this.getMode();
        GuiComboBox contextBox = (GuiComboBox)this.get("grid");
        try {
            this.context = LittleGridContext.get(Integer.parseInt(contextBox.getCaption()));
        }
        catch (NumberFormatException e) {
            this.context = LittleGridContext.get();
        }
        this.saveConfiguration(this.context, this.mode);
    }
}

