/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayeredRenderBoxCache {
    private List<LittleRenderBox> solid = null;
    private List<LittleRenderBox> cutout_mipped = null;
    private List<LittleRenderBox> cutout = null;
    private List<LittleRenderBox> translucent = null;

    public List<LittleRenderBox> get(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                return this.solid;
            }
            case CUTOUT_MIPPED: {
                return this.cutout_mipped;
            }
            case CUTOUT: {
                return this.cutout;
            }
            case TRANSLUCENT: {
                return this.translucent;
            }
        }
        return null;
    }

    public void set(List<LittleRenderBox> cubes, BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                this.solid = cubes;
                break;
            }
            case CUTOUT_MIPPED: {
                this.cutout_mipped = cubes;
                break;
            }
            case CUTOUT: {
                this.cutout = cubes;
                break;
            }
            case TRANSLUCENT: {
                this.translucent = cubes;
            }
        }
    }

    public boolean needUpdate() {
        return this.solid == null || this.cutout_mipped == null || this.cutout == null || this.translucent == null;
    }

    public void clear() {
        this.solid = null;
        this.cutout_mipped = null;
        this.cutout = null;
        this.translucent = null;
    }

    public void sort() {
        if (!OptifineHelper.isActive()) {
            return;
        }
        Iterator<LittleRenderBox> iterator = this.solid.iterator();
        while (iterator.hasNext()) {
            LittleRenderBox littleRenderingCube = iterator.next();
            if (!littleRenderingCube.needsResorting) continue;
            this.cutout_mipped.add(littleRenderingCube);
            iterator.remove();
        }
    }
}

