/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.tile;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.type.LittleItemHolder;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class LittleRenderBoxItem
extends LittleRenderBox {
    private static final Vector3f defaultDirection = new Vector3f(1.0f, 1.0f, 0.0f);
    private static final Vector3f center = new Vector3f(0.5f, 0.5f, 0.5f);
    public final LittleItemHolder structure;

    public LittleRenderBoxItem(LittleItemHolder structure, AlignedBox cube, LittleBox box) {
        super(cube, box, Blocks.field_150350_a, 0);
        this.structure = structure;
        this.allowOverlap = true;
        this.keepVU = true;
    }

    public List<BakedQuad> getBakedQuad(IBlockAccess world, @Nullable BlockPos pos, BlockPos offset, IBlockState state, IBakedModel blockModel, EnumFacing facing, BlockRenderLayer layer, long rand, boolean overrideTint, int defaultColor) {
        float scale;
        Rotation rotation;
        if (facing != this.structure.facing) {
            return Collections.EMPTY_LIST;
        }
        IBakedModel bakedmodel = Minecraft.func_71410_x().func_175599_af().func_184393_a(this.structure.stack, null, null);
        ArrayList blockQuads = new ArrayList(bakedmodel.func_188616_a(null, null, 0L));
        for (EnumFacing face : EnumFacing.values()) {
            List newQuads = bakedmodel.func_188616_a(null, face, 0L);
            blockQuads.addAll(newQuads);
        }
        Vector3f topRight = new Vector3f(defaultDirection);
        int rotationSteps = 1;
        boolean flipX = false;
        boolean flipY = false;
        boolean flipZ = false;
        switch (this.structure.facing) {
            case EAST: {
                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                flipX = true;
                break;
            }
            case WEST: {
                rotation = Rotation.Y_CLOCKWISE;
                flipX = true;
                break;
            }
            case UP: {
                flipY = true;
                rotation = Rotation.X_CLOCKWISE;
                break;
            }
            case DOWN: {
                rotation = Rotation.X_CLOCKWISE;
                break;
            }
            case SOUTH: {
                rotation = null;
                break;
            }
            case NORTH: {
                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                rotationSteps = 2;
                flipZ = true;
                break;
            }
            default: {
                rotation = null;
            }
        }
        if (rotation != null) {
            for (int i = 0; i < rotationSteps; ++i) {
                RotationUtils.rotate((Vector3f)topRight, (Rotation)rotation);
            }
        }
        if (this.structure.topRight.x != 0.0f && this.structure.topRight.x == topRight.x) {
            flipX = true;
        }
        if (this.structure.topRight.y != 0.0f && this.structure.topRight.y != topRight.y) {
            flipY = true;
        }
        if (this.structure.topRight.z != 0.0f && this.structure.topRight.z == topRight.z) {
            flipZ = true;
        }
        switch (this.structure.facing.func_176740_k()) {
            case X: {
                scale = Math.min(this.getSize(EnumFacing.Axis.Y), this.getSize(EnumFacing.Axis.Z));
                break;
            }
            case Y: {
                scale = Math.min(this.getSize(EnumFacing.Axis.X), this.getSize(EnumFacing.Axis.Z));
                break;
            }
            case Z: {
                scale = Math.min(this.getSize(EnumFacing.Axis.X), this.getSize(EnumFacing.Axis.Y));
                break;
            }
            default: {
                scale = 1.0f;
            }
        }
        float offsetX = (this.minX + this.maxX) * 0.5f - 0.5f;
        float offsetY = (this.minY + this.maxY) * 0.5f - 0.5f;
        float offsetZ = (this.minZ + this.maxZ) * 0.5f - 0.5f;
        boolean reverse = ((flipX ? 1 : 0) + (flipY ? 1 : 0) + (flipZ ? 1 : 0)) % 2 == 1;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            int[] originalData = ((BakedQuad)blockQuads.get(i)).func_178209_a();
            CreativeBakedQuad quad = new CreativeBakedQuad((BakedQuad)blockQuads.get(i), (RenderBox)this, defaultColor, overrideTint, null);
            for (int k = 0; k < 4; ++k) {
                int index = k * quad.getFormat().func_181719_f();
                Vector3f vec = new Vector3f(Float.intBitsToFloat(originalData[index]), Float.intBitsToFloat(originalData[index + 1]), Float.intBitsToFloat(originalData[index + 2]));
                vec.sub((Tuple3f)center);
                if (rotation != null) {
                    for (int j = 0; j < rotationSteps; ++j) {
                        RotationUtils.rotate((Vector3f)vec, (Rotation)rotation);
                    }
                }
                if (flipX) {
                    vec.x = -vec.x;
                }
                if (flipY) {
                    vec.y = -vec.y;
                }
                if (flipZ) {
                    vec.z = -vec.z;
                }
                vec.x *= scale;
                vec.y *= scale;
                vec.z *= scale;
                vec.x += offsetX;
                vec.y += offsetY;
                vec.z += offsetZ;
                vec.add((Tuple3f)center);
                int newIndex = index;
                if (reverse) {
                    newIndex = (3 - k) * quad.getFormat().func_181719_f();
                }
                quad.func_178209_a()[newIndex] = Float.floatToIntBits(vec.x + (float)offset.func_177958_n());
                quad.func_178209_a()[newIndex + 1] = Float.floatToIntBits(vec.y + (float)offset.func_177956_o());
                quad.func_178209_a()[newIndex + 2] = Float.floatToIntBits(vec.z + (float)offset.func_177952_p());
                if (!reverse) continue;
                for (int j = 3; j < quad.getFormat().func_181719_f(); ++j) {
                    quad.func_178209_a()[newIndex + j] = originalData[index + j];
                }
            }
            quads.add((BakedQuad)quad);
        }
        return quads;
    }

    public boolean intersectsWithFace(EnumFacing facing, RenderBox.RenderInformationHolder holder, BlockPos offset) {
        return true;
    }
}

