/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.world;

import com.creativemd.creativecore.client.rendering.IRenderChunkSupplier;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.client.render.world.RenderUtils;
import java.util.LinkedHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleRenderChunkSuppilier
implements IRenderChunkSupplier {
    @SideOnly(value=Side.CLIENT)
    public LinkedHashMap<BlockPos, LittleRenderChunk> renderChunks = new LinkedHashMap();

    @SideOnly(value=Side.CLIENT)
    public void backToRAM() {
        if (this.renderChunks == null) {
            return;
        }
        for (LittleRenderChunk chunk : this.renderChunks.values()) {
            chunk.backToRAM();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void unloadRenderCache() {
        if (this.renderChunks == null) {
            return;
        }
        for (LittleRenderChunk chunk : this.renderChunks.values()) {
            chunk.unload();
        }
        this.renderChunks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public LittleRenderChunk getRenderChunk(World world, BlockPos pos) {
        LinkedHashMap<BlockPos, LittleRenderChunk> linkedHashMap = this.renderChunks;
        synchronized (linkedHashMap) {
            BlockPos renderChunkPos = RenderUtils.getRenderChunkPos(pos);
            LittleRenderChunk chunk = this.renderChunks.get(renderChunkPos);
            if (chunk == null) {
                chunk = new LittleRenderChunk(renderChunkPos);
                this.renderChunks.put(renderChunkPos, chunk);
            }
            return chunk;
        }
    }

    protected void finalize() throws Throwable {
        this.unloadRenderCache();
    }
}

