/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.world;

import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static Field viewFrustumField;
    private static Minecraft mc;
    private static Method getRenderChunk;

    public static ViewFrustum getViewFrustum() {
        if (viewFrustumField == null) {
            viewFrustumField = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"viewFrustum", "field_175008_n"});
        }
        try {
            return (ViewFrustum)viewFrustumField.get(RenderUtils.mc.field_71438_f);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BlockPos getRenderChunkPos(BlockPos pos) {
        int i = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        int j = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
        int k = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
        return new BlockPos(i, j, k);
    }

    public static RenderChunk getRenderChunk(ViewFrustum frustum, BlockPos pos) {
        try {
            return (RenderChunk)getRenderChunk.invoke((Object)frustum, pos);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleRenderChunk getRenderChunk(IOrientatedWorld world, BlockPos pos) {
        if (world instanceof CreativeWorld && ((CreativeWorld)world).renderChunkSupplier != null) {
            return (LittleRenderChunk)((CreativeWorld)world).renderChunkSupplier.getRenderChunk((World)world, pos);
        }
        return null;
    }

    static {
        mc = Minecraft.func_71410_x();
        getRenderChunk = ReflectionHelper.findMethod(ViewFrustum.class, (String)"getRenderChunk", (String)"func_178161_a", (Class[])new Class[]{BlockPos.class});
    }
}

