/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;

public class LittleActionPlaceAbsolute
extends LittleAction {
    public LittleAbsolutePreviews previews;
    public PlacementMode mode;
    public boolean toVanilla;
    public LittleBoxes boxes;
    public LittleAbsolutePreviews destroyed;

    public LittleActionPlaceAbsolute(LittleAbsolutePreviews previews, PlacementMode mode, boolean toVanilla) {
        this.previews = previews;
        this.mode = mode;
        this.toVanilla = toVanilla;
        this.checkMode();
    }

    public LittleActionPlaceAbsolute(LittleAbsolutePreviews previews, PlacementMode mode) {
        this(previews, mode, false);
    }

    public LittleActionPlaceAbsolute() {
    }

    public void checkMode() {
        if (this.previews != null && this.previews.hasStructure() && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) {
        this.boxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.destroyed, PlacementMode.normal, true));
        }
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        LittleInventory inventory = new LittleInventory(player);
        if (this.canDrainIngredientsBeforePlacing(player, inventory)) {
            Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(player.field_70170_p, this.previews, this.previews.pos, this.mode));
            PlacementResult placedTiles = placement.place();
            if (placedTiles != null) {
                this.boxes = placedTiles.placedBoxes;
                this.drainIngredientsAfterPlacing(player, inventory, placedTiles, this.previews);
                if (!player.field_70170_p.field_72995_K) {
                    LittleActionPlaceAbsolute.checkAndGive(player, inventory, LittleActionPlaceAbsolute.getIngredients(placement.unplaceableTiles));
                    LittleActionPlaceAbsolute.checkAndGive(player, inventory, placement.overflow());
                }
                if (!placement.removedTiles.isEmpty()) {
                    this.destroyed = placement.removedTiles.copy();
                }
                if (this.toVanilla) {
                    for (TileEntityLittleTiles te : placedTiles.tileEntities) {
                        te.convertBlockToVanilla();
                    }
                }
            } else {
                this.boxes = new LittleBoxesSimple(this.previews.pos, LittleGridContext.get());
            }
            return placedTiles != null;
        }
        return false;
    }

    protected boolean canDrainIngredientsBeforePlacing(EntityPlayer player, LittleInventory inventory) throws LittleActionException {
        return LittleActionPlaceAbsolute.canTake(player, inventory, this.mode.getBeforePlaceIngredients(this.previews));
    }

    protected void drainIngredientsAfterPlacing(EntityPlayer player, LittleInventory inventory, PlacementResult placedTiles, LittlePreviews previews) throws LittleActionException {
        LittleIngredients ingredients = LittleIngredient.extractStructureOnly(previews);
        ingredients.add(LittleActionPlaceAbsolute.getIngredients(placedTiles.placedPreviews));
        LittleActionPlaceAbsolute.take(player, inventory, ingredients);
    }

    public void writeBytes(ByteBuf buf) {
        LittleActionPlaceAbsolute.writePreviews(this.previews, buf);
        LittleActionPlaceAbsolute.writePlacementMode(this.mode, buf);
        buf.writeBoolean(this.toVanilla);
    }

    public void readBytes(ByteBuf buf) {
        this.previews = (LittleAbsolutePreviews)LittleActionPlaceAbsolute.readPreviews(buf);
        this.mode = LittleActionPlaceAbsolute.readPlacementMode(buf);
        this.toVanilla = buf.readBoolean();
        this.checkMode();
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        LittleAbsolutePreviews newPreviews = this.previews.copy();
        if (newPreviews.getContext() != box.context) {
            if (newPreviews.getContext().size > box.context.size) {
                box.convertTo(newPreviews.getContext());
            } else {
                newPreviews.convertTo(box.context);
            }
        }
        newPreviews.flipPreviews(axis, box.getDoubledCenter(newPreviews.pos));
        newPreviews.convertToSmallest();
        box.convertToSmallest();
        return new LittleActionPlaceAbsolute(newPreviews, this.mode, this.toVanilla);
    }

    public static class LittleActionPlaceAbsolutePremade
    extends LittleActionPlaceAbsolute {
        public LittleActionPlaceAbsolutePremade(LittleAbsolutePreviews previews, PlacementMode mode, boolean toVanilla) {
            super(previews, mode, toVanilla);
        }

        public LittleActionPlaceAbsolutePremade() {
        }

        @Override
        protected void drainIngredientsAfterPlacing(EntityPlayer player, LittleInventory inventory, PlacementResult placedTiles, LittlePreviews previews) throws LittleActionException {
            LittleActionPlaceAbsolutePremade.take(player, inventory, LittleStructurePremade.getStructurePremadeEntry((String)previews.getStructureId()).stack);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean canDrainIngredientsBeforePlacing(EntityPlayer player, LittleInventory inventory) throws LittleActionException {
            LittleStructurePremade.LittleStructurePremadeEntry entry = LittleStructurePremade.getStructurePremadeEntry(this.previews.getStructureId());
            try {
                inventory.startSimulation();
                boolean bl = LittleActionPlaceAbsolutePremade.take(player, inventory, entry.stack) && entry.arePreviewsEqual(this.previews);
                return bl;
            }
            finally {
                inventory.stopSimulation();
            }
        }

        @Override
        public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
            LittleAbsolutePreviews newPreviews = this.previews.copy();
            if (newPreviews.getContext() != box.context) {
                if (newPreviews.getContext().size > box.context.size) {
                    box.convertTo(newPreviews.getContext());
                } else {
                    newPreviews.convertTo(box.context);
                }
            }
            newPreviews.flipPreviews(axis, box.getDoubledCenter(newPreviews.pos));
            newPreviews.convertToSmallest();
            box.convertToSmallest();
            return new LittleActionPlaceAbsolutePremade(newPreviews, this.mode, this.toVanilla);
        }
    }
}

