/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerHeldItem;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.controls.SlotControlBlockIngredient;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.item.ItemBlockIngredient;
import com.creativemd.littletiles.common.item.ItemColorIngredient;
import com.creativemd.littletiles.common.item.ItemLittleBag;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerBag
extends SubContainerHeldItem {
    public LittleIngredients bag;
    public InventoryBasic input = new InventoryBasic("input", false, 1);
    public InventoryBasic bagInventory;

    public SubContainerBag(EntityPlayer player, ItemStack stack, int index) {
        super(player, stack, index);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p().func_74737_b();
        nbt.func_74757_a("reload", true);
        this.sendNBTToGui(nbt);
    }

    @CustomEventSubscribe
    public void onSlotChange(SlotChangeEvent event) {
        if (event.source instanceof SlotControl) {
            if (event.source instanceof SlotControlBlockIngredient) {
                SlotControlBlockIngredient slot = (SlotControlBlockIngredient)event.source;
                BlockIngredient blocks = new BlockIngredient().setLimits(ItemLittleBag.inventorySize, ItemLittleBag.maxStackSize);
                for (int y = 0; y < ItemLittleBag.inventoryHeight; ++y) {
                    for (int x = 0; x < ItemLittleBag.inventoryWidth; ++x) {
                        int index = x + y * ItemLittleBag.inventoryWidth;
                        BlockIngredientEntry ingredient = ((SlotControlBlockIngredient)this.get("item" + index)).getIngredient();
                        if (ingredient == null) continue;
                        blocks.add(ingredient);
                    }
                }
                this.bag.set(blocks.getClass(), blocks);
                ((ItemLittleBag)this.stack.func_77973_b()).setInventory(this.stack, this.bag, null);
                if (this.player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)this.player).func_71120_a(this.player.field_71069_bz);
                }
                this.reloadControls();
            } else if (event.source.name.startsWith("input")) {
                ItemStack input = ((SlotControl)event.source).slot.func_75211_c();
                if (input.func_77973_b() instanceof ILittleIngredientInventory) {
                    LittleIngredients ingredients = ((ILittleIngredientInventory)input.func_77973_b()).getInventory(input);
                    boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                    boolean containsColor = ingredients.contains(ColorIngredient.class);
                    LittleIngredients remaining = this.bag.add(ingredients);
                    ((ItemLittleBag)this.stack.func_77973_b()).setInventory(this.stack, this.bag, null);
                    if (remaining == null) {
                        remaining = new LittleIngredients();
                    }
                    if (remaining.copy().sub(ingredients.copy()) != null) {
                        if (containsBlocks) {
                            this.updateSlots();
                            this.player.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
                        }
                        if (containsColor) {
                            this.reloadControls();
                            this.player.func_184185_a(SoundEvents.field_187621_J, 1.0f, 1.0f);
                        }
                    }
                    if (!remaining.isEmpty()) {
                        LittleIngredients in = new LittleIngredients();
                        BlockIngredient blocks = new BlockIngredient().setLimits(ItemLittleBag.inventorySize, ItemLittleBag.maxStackSize);
                        in.set(BlockIngredient.class, blocks);
                        in.add(remaining);
                        remaining = in;
                    }
                    ((ILittleIngredientInventory)input.func_77973_b()).setInventory(input, remaining, null);
                } else {
                    LittleIngredients ingredients = LittleIngredient.extractWithoutCount(input, true);
                    if (ingredients != null) {
                        ingredients.scale(input.func_190916_E());
                        boolean containsBlocks = ingredients.contains(BlockIngredient.class);
                        boolean containsColor = ingredients.contains(ColorIngredient.class);
                        LittleIngredients overflow = this.bag.add(ingredients);
                        if (overflow == null || !overflow.contains(BlockIngredient.class) && !overflow.contains(ColorIngredient.class)) {
                            input.func_190920_e(0);
                            ((ItemLittleBag)this.stack.func_77973_b()).setInventory(this.stack, this.bag, null);
                            LittleInventory inventory = new LittleInventory(this.player);
                            try {
                                if (overflow != null) {
                                    inventory.give(overflow);
                                }
                            }
                            catch (NotEnoughIngredientsException.NotEnoughSpaceException notEnoughSpaceException) {
                                // empty catch block
                            }
                            if (containsBlocks) {
                                this.updateSlots();
                                this.player.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
                            }
                            if (containsColor) {
                                this.reloadControls();
                                this.player.func_184185_a(SoundEvents.field_187621_J, 1.0f, 1.0f);
                            }
                        } else {
                            this.bag = ((ItemLittleBag)this.stack.func_77973_b()).getInventory(this.stack);
                        }
                    }
                }
                if (this.player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)this.player).func_71120_a(this.player.field_71069_bz);
                }
            }
        }
    }

    public void reloadControls() {
        this.controls.clear();
        this.createControls();
        this.refreshControls();
        NBTTagCompound nbt = this.stack.func_77978_p().func_74737_b();
        nbt.func_74757_a("reload", true);
        this.sendNBTToGui(nbt);
    }

    public void updateSlots() {
        List<BlockIngredientEntry> inventory = this.bag.get(BlockIngredient.class).getContent();
        for (int y = 0; y < ItemLittleBag.inventoryHeight; ++y) {
            for (int x = 0; x < ItemLittleBag.inventoryWidth; ++x) {
                ItemStack stack;
                int index = x + y * ItemLittleBag.inventoryWidth;
                if (index < inventory.size()) {
                    stack = new ItemStack(LittleTiles.blockIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ItemBlockIngredient.saveIngredient(stack, inventory.get(index));
                } else {
                    stack = ItemStack.field_190927_a;
                }
                this.bagInventory.func_70299_a(index, stack);
            }
        }
        if (this.player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.player).func_71120_a(this.player.field_71069_bz);
        }
    }

    public void createControls() {
        this.bag = ((ItemLittleBag)this.stack.func_77973_b()).getInventory(this.stack);
        List<BlockIngredientEntry> inventory = this.bag.get(BlockIngredient.class).getContent();
        this.bagInventory = new InventoryBasic("item", false, ItemLittleBag.inventorySize){

            public int func_70297_j_() {
                return ItemLittleBag.maxStackSizeOfTiles;
            }
        };
        for (int y = 0; y < ItemLittleBag.inventoryHeight; ++y) {
            for (int x = 0; x < ItemLittleBag.inventoryWidth; ++x) {
                ItemStack stack;
                int index = x + y * ItemLittleBag.inventoryWidth;
                if (index < inventory.size()) {
                    stack = new ItemStack(LittleTiles.blockIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ItemBlockIngredient.saveIngredient(stack, inventory.get(index));
                } else {
                    stack = ItemStack.field_190927_a;
                }
                this.bagInventory.func_70299_a(index, stack);
                this.controls.add(new SlotControlBlockIngredient(new Slot((IInventory)this.bagInventory, index, 5 + x * 18, 5 + y * 18){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }
                }));
            }
        }
        this.addSlotToContainer(new Slot((IInventory)this.input, 0, 120, 5));
        this.addPlayerSlotsToContainer(this.player);
    }

    public void onClosed() {
        ItemStack stack = ((SlotControl)this.get((String)"input0")).slot.func_75211_c();
        if (!stack.func_190926_b()) {
            WorldUtils.dropItem((EntityPlayer)this.player, (ItemStack)stack);
        }
        if (this.player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.player).func_71120_a(this.player.field_71069_bz);
        }
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        if (nbt.func_74767_n("color")) {
            int amount;
            ItemColorIngredient.ColorIngredientType type = ItemColorIngredient.ColorIngredientType.getType(nbt.func_74779_i("type"));
            ColorIngredient color = this.bag.get(ColorIngredient.class);
            if (color != null && !color.isEmpty() && (amount = Math.min(type.getIngredient(color), ColorIngredient.bottleSize)) > 0) {
                type.setIngredient(color, type.getIngredient(color) - amount);
                LittleInventory inventory = new LittleInventory(this.player);
                ItemStack colorStack = ItemColorIngredient.generateItemStack(type, amount);
                if (!inventory.addStack(colorStack)) {
                    WorldUtils.dropItem((EntityPlayer)this.player, (ItemStack)colorStack);
                }
                ((ItemLittleBag)this.stack.func_77973_b()).setInventory(this.stack, this.bag, null);
                if (this.player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)this.player).func_71120_a(this.player.field_71069_bz);
                }
                this.onTick();
                this.reloadControls();
            }
        }
    }
}

