/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.render.cache.ChunkBlockLayerManager;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.client.render.world.RenderUploader;
import com.creativemd.littletiles.client.render.world.RenderUtils;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.World;

public class LittleAnimationDestroyPacket
extends CreativeCorePacket {
    public UUID uuid;
    public boolean placed;

    public LittleAnimationDestroyPacket(UUID uuid, boolean placed) {
        this.uuid = uuid;
        this.placed = placed;
    }

    public LittleAnimationDestroyPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAnimationDestroyPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        buf.writeBoolean(this.placed);
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleAnimationDestroyPacket.readString((ByteBuf)buf));
        this.placed = buf.readBoolean();
    }

    public void remove(EntityAnimation animation) {
        block14: {
            try {
                if (!this.placed || animation.field_70128_L) break block14;
                animation.getRenderChunkSuppilier().backToRAM();
                World world = animation.field_70170_p;
                boolean subWorld = world instanceof IOrientatedWorld;
                HashMapList chunks = new HashMapList();
                for (TileEntity te : animation.fakeWorld.field_147482_g) {
                    if (!(te instanceof TileEntityLittleTiles)) continue;
                    if (subWorld) {
                        chunks.add((Object)RenderUtils.getRenderChunk((IOrientatedWorld)te.func_145831_w(), te.func_174877_v()), (Object)((TileEntityLittleTiles)te));
                        continue;
                    }
                    chunks.add((Object)RenderUtils.getRenderChunk(RenderUtils.getViewFrustum(), te.func_174877_v()), (Object)((TileEntityLittleTiles)te));
                }
                if (subWorld) {
                    for (Object chunk : chunks.keySet()) {
                        ((LittleRenderChunk)chunk).backToRAM();
                    }
                } else {
                    for (Object chunk : chunks.keySet()) {
                        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                            ChunkBlockLayerManager manager;
                            VertexBuffer buffer = ((RenderChunk)chunk).func_178565_b(i);
                            if (buffer == null || (manager = ChunkBlockLayerManager.get(buffer)) == null) continue;
                            manager.backToRAM();
                        }
                    }
                }
                for (Map.Entry entry : chunks.entrySet()) {
                    ArrayList<TileEntityLittleTiles> newBlocks = new ArrayList<TileEntityLittleTiles>();
                    for (TileEntityLittleTiles oldTe : (ArrayList)entry.getValue()) {
                        TileEntity newTE = world.func_175625_s(oldTe.func_174877_v());
                        if (newTE instanceof TileEntityLittleTiles) {
                            ((TileEntityLittleTiles)newTE).render.getBufferCache().additional(oldTe.render.getBufferCache());
                            newBlocks.add((TileEntityLittleTiles)newTE);
                            continue;
                        }
                        world.func_175656_a(oldTe.func_174877_v(), BlockTile.getState(oldTe));
                        newTE = world.func_175625_s(oldTe.func_174877_v());
                        ((TileEntityLittleTiles)newTE).render.getBufferCache().additional(oldTe.render.getBufferCache());
                        newBlocks.add((TileEntityLittleTiles)newTE);
                    }
                    ((ArrayList)entry.getValue()).clear();
                    ((ArrayList)entry.getValue()).addAll(newBlocks);
                }
                if (!subWorld) {
                    for (Map.Entry entry : chunks.entrySet()) {
                        RenderUploader.uploadRenderData((RenderChunk)entry.getKey(), (List)entry.getValue());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        animation.destroyAnimation();
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
        if (animation != null) {
            this.remove(animation);
            return;
        }
        for (Entity entity : player.field_70170_p.func_175644_a(EntityAnimation.class, (Predicate)new Predicate<EntityAnimation>(){

            public boolean apply(EntityAnimation input) {
                return true;
            }
        })) {
            if (!(entity instanceof EntityAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            this.remove((EntityAnimation)entity);
            return;
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

