/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import com.creativemd.littletiles.common.structure.signal.schedule.ISignalScheduleTicket;
import com.creativemd.littletiles.common.structure.signal.schedule.SignalTicker;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum SignalMode {
    EQUAL("signal.mode.equal"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, NBTTagCompound nbt, boolean hasWorld) {
            SignalOutputHandler handler = new SignalOutputHandler(component, delay, nbt){

                @Override
                public SignalMode getMode() {
                    return EQUAL;
                }

                @Override
                public void queue(boolean[] state) {
                    SignalTicker.schedule(this, state, this.delay);
                }

                @Override
                public void write(boolean preview, NBTTagCompound nbt) {
                    if (preview) {
                        return;
                    }
                    List<ISignalScheduleTicket> tickets = SignalTicker.findTickets(this.component, this);
                    NBTTagList list = new NBTTagList();
                    for (int i = 0; i < tickets.size(); ++i) {
                        ISignalScheduleTicket ticket = tickets.get(i);
                        list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{ticket.getDelay(), BooleanUtils.boolToInt((boolean[])ticket.getState())}));
                    }
                    nbt.func_74782_a("tickets", (NBTBase)list);
                }
            };
            if (hasWorld) {
                NBTTagList list = nbt.func_150295_c("tickets", 11);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    int[] array = list.func_150306_c(i);
                    if (array.length != 2) continue;
                    try {
                        boolean[] state = new boolean[component.getBandwidth()];
                        BooleanUtils.intToBool((int)array[1], (boolean[])state);
                        SignalTicker.schedule(handler, state, array[0]);
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
            return handler;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(NBTTagCompound nbt) {
            if (nbt == null) {
                return new GuiSignalModeConfigurationEqual(1);
            }
            return new GuiSignalModeConfigurationEqual(nbt);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationEqual(delay);
        }
    }
    ,
    TOGGLE("signal.mode.toggle"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, NBTTagCompound nbt, boolean hasWorld) {
            boolean[] result;
            boolean[] before;
            int bandwidth = nbt.func_74762_e("bandwidth");
            if (bandwidth > 0) {
                before = new boolean[bandwidth];
                result = new boolean[bandwidth];
                BooleanUtils.intToBool((int)nbt.func_74762_e("before"), (boolean[])before);
                BooleanUtils.intToBool((int)nbt.func_74762_e("result"), (boolean[])result);
            } else {
                before = null;
                result = null;
            }
            SignalOutputHandlerToggle handler = new SignalOutputHandlerToggle(component, delay, nbt, before, result);
            if (hasWorld) {
                NBTTagList list = nbt.func_150295_c("tickets", 11);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    int[] array = list.func_150306_c(i);
                    if (array.length != 2) continue;
                    try {
                        boolean[] state = new boolean[component.getBandwidth()];
                        BooleanUtils.intToBool((int)array[1], (boolean[])state);
                        SignalTicker.schedule(handler, state, array[0]);
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
            return handler;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(NBTTagCompound nbt) {
            return new GuiSignalModeConfigurationToggle(nbt);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationToggle(delay);
        }
    }
    ,
    PULSE("signal.mode.pulse"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, NBTTagCompound nbt, boolean hasWorld) {
            SignalOutputHandlerPulse condition = new SignalOutputHandlerPulse(component, delay, nbt);
            if (hasWorld) {
                if (nbt.func_74764_b("start")) {
                    SignalTicker.schedule(condition, BooleanUtils.asArray((boolean)true), nbt.func_74762_e("start"));
                    SignalTicker.schedule(condition, BooleanUtils.asArray((boolean)false), nbt.func_74762_e("end"));
                } else if (nbt.func_74764_b("end")) {
                    SignalTicker.schedule(condition, BooleanUtils.asArray((boolean)false), nbt.func_74762_e("end"));
                }
            }
            return condition;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(NBTTagCompound nbt) {
            return new GuiSignalModeConfigurationPulse(nbt);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
            parent.addControl((GuiControl)new GuiLabel("length:", 0, 43));
            parent.addControl((GuiControl)new GuiTextfield("length", "" + (configuration instanceof GuiSignalModeConfigurationPulse ? ((GuiSignalModeConfigurationPulse)configuration).length : 10), 40, 41, 50, 12).setNumbersOnly());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            GuiTextfield length = (GuiTextfield)parent.get("length");
            return new GuiSignalModeConfigurationPulse(delay, Math.max(1, length.parseInteger()));
        }
    }
    ,
    THRESHOLD("signal.mode.threshold"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, NBTTagCompound nbt, boolean hasWorld) {
            int[] array;
            SignalOutputHandlerStoreOne handler = new SignalOutputHandlerStoreOne(component, delay, nbt){

                @Override
                public void queue(boolean[] state) {
                    if (this.ticket != null) {
                        this.ticket.overwriteState(state);
                    } else {
                        this.ticket = SignalTicker.schedule(this, state, this.delay);
                    }
                }

                @Override
                public void performStateChange(boolean[] state) {
                    this.ticket = null;
                    super.performStateChange(state);
                }

                @Override
                public SignalMode getMode() {
                    return THRESHOLD;
                }

                @Override
                public void write(boolean preview, NBTTagCompound nbt) {
                    if (!preview && this.ticket != null) {
                        nbt.func_74783_a("ticket", new int[]{this.ticket.getDelay(), BooleanUtils.boolToInt((boolean[])this.ticket.getState())});
                    }
                }
            };
            if (hasWorld && nbt.func_74764_b("ticket") && (array = nbt.func_74759_k("ticket")).length == 2) {
                try {
                    boolean[] state = new boolean[component.getBandwidth()];
                    BooleanUtils.intToBool((int)array[1], (boolean[])state);
                    handler.ticket = SignalTicker.schedule(handler, state, array[0]);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return handler;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(NBTTagCompound nbt) {
            return new GuiSignalModeConfigurationThreshold(nbt);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationThreshold(delay);
        }
    }
    ,
    STABILIZER("signal.mode.stabilizer"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, NBTTagCompound nbt, boolean hasWorld) {
            int[] array;
            SignalOutputHandlerStoreOne handler = new SignalOutputHandlerStoreOne(component, delay, nbt){

                @Override
                public void queue(boolean[] state) {
                    if (this.ticket != null) {
                        this.ticket.markObsolete();
                    }
                    this.ticket = SignalTicker.schedule(this, state, this.delay);
                }

                @Override
                public void performStateChange(boolean[] state) {
                    this.ticket = null;
                    super.performStateChange(state);
                }

                @Override
                public SignalMode getMode() {
                    return THRESHOLD;
                }

                @Override
                public void write(boolean preview, NBTTagCompound nbt) {
                    if (preview) {
                        return;
                    }
                    if (this.ticket != null) {
                        nbt.func_74783_a("ticket", new int[]{this.ticket.getDelay(), BooleanUtils.boolToInt((boolean[])this.ticket.getState())});
                    }
                }
            };
            if (hasWorld && nbt.func_74764_b("ticket") && (array = nbt.func_74759_k("ticket")).length == 2) {
                try {
                    boolean[] state = new boolean[component.getBandwidth()];
                    BooleanUtils.intToBool((int)array[1], (boolean[])state);
                    handler.ticket = SignalTicker.schedule(handler, state, array[0]);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return handler;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(NBTTagCompound nbt) {
            return new GuiSignalModeConfigurationStabilizer(nbt);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationStabilizer(delay);
        }
    }
    ,
    EXTENDER("signal.mode.extender"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, NBTTagCompound nbt, boolean hasWorld) {
            SignalOutputHandlerExtender condition = new SignalOutputHandlerExtender(component, delay, nbt);
            if (hasWorld) {
                if (nbt.func_74764_b("start")) {
                    SignalTicker.schedule(condition, BooleanUtils.asArray((boolean)true), nbt.func_74762_e("start"));
                    SignalTicker.schedule(condition, BooleanUtils.asArray((boolean)false), nbt.func_74762_e("end"));
                } else if (nbt.func_74764_b("end")) {
                    SignalTicker.schedule(condition, BooleanUtils.asArray((boolean)false), nbt.func_74762_e("end"));
                }
            }
            return condition;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(NBTTagCompound nbt) {
            return new GuiSignalModeConfigurationExtender(nbt);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
            parent.addControl((GuiControl)new GuiLabel("length:", 0, 43));
            parent.addControl((GuiControl)new GuiTextfield("length", "" + (configuration instanceof GuiSignalModeConfigurationExtender ? ((GuiSignalModeConfigurationExtender)configuration).length : 10), 40, 41, 50, 12).setNumbersOnly());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            GuiTextfield length = (GuiTextfield)parent.get("length");
            return new GuiSignalModeConfigurationExtender(delay, Math.max(1, length.parseInteger()));
        }
    };

    public final String translateKey;

    private SignalMode(String translateKey) {
        this.translateKey = translateKey;
    }

    public abstract SignalOutputHandler create(ISignalComponent var1, int var2, NBTTagCompound var3, boolean var4);

    @SideOnly(value=Side.CLIENT)
    public abstract GuiSignalModeConfiguration createConfiguration(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void createControls(GuiParent var1, GuiSignalModeConfiguration var2);

    @SideOnly(value=Side.CLIENT)
    public abstract GuiSignalModeConfiguration parseControls(GuiParent var1, int var2);

    @SideOnly(value=Side.CLIENT)
    public static GuiSignalModeConfiguration getConfigDefault() {
        return EQUAL.createConfiguration(null);
    }

    @SideOnly(value=Side.CLIENT)
    public static GuiSignalModeConfiguration getConfig(NBTTagCompound nbt, SignalMode defaultMode) {
        return SignalMode.get(nbt.func_74779_i("mode"), defaultMode).createConfiguration(nbt);
    }

    public static SignalMode get(String test) {
        try {
            return SignalMode.valueOf(test);
        }
        catch (IllegalArgumentException e) {
            return EQUAL;
        }
    }

    public static SignalMode get(String test, SignalMode defaultMode) {
        try {
            return SignalMode.valueOf(test);
        }
        catch (IllegalArgumentException e) {
            return defaultMode;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiSignalModeConfigurationStabilizer
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationStabilizer(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationStabilizer(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public SignalMode getMode() {
            return STABILIZER;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationStabilizer(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiSignalModeConfigurationThreshold
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationThreshold(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationThreshold(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public SignalMode getMode() {
            return THRESHOLD;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationThreshold(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiSignalModeConfigurationExtender
    extends GuiSignalModeConfiguration {
        public int length;

        public GuiSignalModeConfigurationExtender(int delay, int length) {
            super(delay);
            this.length = length;
        }

        public GuiSignalModeConfigurationExtender(NBTTagCompound nbt) {
            super(nbt);
            this.length = nbt.func_74764_b("length") ? nbt.func_74762_e("length") : 10;
        }

        @Override
        public SignalMode getMode() {
            return EXTENDER;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationExtender(this.delay, this.length);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("delay", this.delay);
            nbt.func_74768_a("length", this.length);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiSignalModeConfigurationPulse
    extends GuiSignalModeConfiguration {
        public int length;

        public GuiSignalModeConfigurationPulse(int delay, int length) {
            super(delay);
            this.length = length;
        }

        public GuiSignalModeConfigurationPulse(NBTTagCompound nbt) {
            super(nbt);
            this.length = nbt.func_74764_b("length") ? nbt.func_74762_e("length") : 10;
        }

        @Override
        public SignalMode getMode() {
            return PULSE;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationPulse(this.delay, this.length);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("delay", this.delay);
            nbt.func_74768_a("length", this.length);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiSignalModeConfigurationToggle
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationToggle(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationToggle(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public SignalMode getMode() {
            return TOGGLE;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationToggle(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiSignalModeConfigurationEqual
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationEqual(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationEqual(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public SignalMode getMode() {
            return EQUAL;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationEqual(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class GuiSignalModeConfiguration {
        public int delay;

        public GuiSignalModeConfiguration(NBTTagCompound nbt) {
            this(nbt.func_74762_e("delay"));
        }

        public GuiSignalModeConfiguration(int delay) {
            this.delay = delay;
        }

        public abstract SignalMode getMode();

        public abstract GuiSignalModeConfiguration copy();

        public abstract SignalOutputHandler getHandler(ISignalComponent var1, LittleStructure var2);
    }

    public static class SignalOutputHandlerExtender
    extends SignalOutputHandler {
        public final int pulseLength;
        public boolean stateBefore;
        public ISignalScheduleTicket pulseStart;
        public ISignalScheduleTicket pulseEnd;

        public SignalOutputHandlerExtender(ISignalComponent component, int delay, NBTTagCompound nbt) {
            super(component, delay, nbt);
            this.pulseLength = nbt.func_74764_b("length") ? nbt.func_74762_e("length") : 10;
            this.stateBefore = nbt.func_74767_n("before");
        }

        @Override
        public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
            return super.getBandwidth();
        }

        @Override
        public SignalMode getMode() {
            return EXTENDER;
        }

        @Override
        public void performStateChange(boolean[] state) {
            super.performStateChange(state);
            if (BooleanUtils.any((boolean[])state)) {
                this.pulseStart = null;
            } else {
                this.pulseStart = null;
                this.pulseEnd = null;
            }
        }

        @Override
        public void queue(boolean[] state) {
            boolean current = BooleanUtils.any((boolean[])state);
            if (!this.stateBefore && current) {
                if (this.pulseEnd != null) {
                    this.pulseEnd.markObsolete();
                    this.pulseEnd = null;
                } else if (this.pulseStart == null) {
                    boolean[] startState = new boolean[state.length];
                    Arrays.fill(startState, true);
                    this.pulseStart = SignalTicker.schedule(this, startState, this.delay);
                }
            } else if (this.stateBefore && !current) {
                if (this.pulseEnd != null) {
                    this.pulseEnd.markObsolete();
                    this.pulseEnd = null;
                }
                this.pulseEnd = SignalTicker.schedule(this, new boolean[state.length], this.delay + this.pulseLength);
            }
            this.stateBefore = current;
        }

        @Override
        public void write(boolean preview, NBTTagCompound nbt) {
            nbt.func_74768_a("length", this.pulseLength);
            nbt.func_74757_a("before", this.stateBefore);
            if (preview) {
                return;
            }
            if (this.pulseStart != null) {
                nbt.func_74768_a("start", this.pulseStart.getDelay());
            }
            if (this.pulseEnd != null) {
                nbt.func_74768_a("end", this.pulseEnd.getDelay());
            }
        }
    }

    public static class SignalOutputHandlerPulse
    extends SignalOutputHandler {
        public final int pulseLength;
        public boolean stateBefore;
        public ISignalScheduleTicket pulseStart;
        public ISignalScheduleTicket pulseEnd;

        public SignalOutputHandlerPulse(ISignalComponent component, int delay, NBTTagCompound nbt) {
            super(component, delay, nbt);
            this.pulseLength = nbt.func_74764_b("length") ? nbt.func_74762_e("length") : 10;
            this.stateBefore = nbt.func_74767_n("before");
        }

        @Override
        public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
            return super.getBandwidth();
        }

        @Override
        public SignalMode getMode() {
            return PULSE;
        }

        @Override
        public void performStateChange(boolean[] state) {
            super.performStateChange(state);
            if (BooleanUtils.any((boolean[])state)) {
                this.pulseStart = null;
            } else {
                this.pulseStart = null;
                this.pulseEnd = null;
            }
        }

        @Override
        public void queue(boolean[] state) {
            boolean current = BooleanUtils.any((boolean[])state);
            if (this.pulseEnd == null && !this.stateBefore && current) {
                boolean[] startState = new boolean[state.length];
                Arrays.fill(startState, true);
                boolean[] endState = new boolean[state.length];
                this.pulseStart = SignalTicker.schedule(this, startState, this.delay);
                this.pulseEnd = SignalTicker.schedule(this, endState, this.delay + this.pulseLength);
            }
            this.stateBefore = current;
        }

        @Override
        public void write(boolean preview, NBTTagCompound nbt) {
            nbt.func_74768_a("length", this.pulseLength);
            nbt.func_74757_a("before", this.stateBefore);
            if (preview) {
                return;
            }
            if (this.pulseStart != null) {
                nbt.func_74768_a("start", this.pulseStart.getDelay());
            }
            if (this.pulseEnd != null) {
                nbt.func_74768_a("end", this.pulseEnd.getDelay());
            }
        }
    }

    public static class SignalOutputHandlerToggle
    extends SignalOutputHandler {
        public boolean[] stateBefore;
        public boolean[] result;

        public SignalOutputHandlerToggle(ISignalComponent component, int delay, NBTTagCompound nbt, boolean[] stateBefore, boolean[] result) {
            super(component, delay, nbt);
            this.stateBefore = stateBefore;
            this.result = result;
        }

        @Override
        public SignalMode getMode() {
            return TOGGLE;
        }

        public void triggerToggle() {
            if (this.result == null) {
                try {
                    int bandwidth = this.component.getBandwidth();
                    this.result = new boolean[bandwidth];
                    BooleanUtils.set((boolean[])this.result, (boolean[])this.component.getState());
                }
                catch (CorruptedConnectionException | NotYetConnectedException bandwidth) {
                    // empty catch block
                }
            }
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = !this.result[i];
            }
            this.performStateChange(this.result);
        }

        @Override
        public void queue(boolean[] state) {
            if (this.stateBefore == null || this.stateBefore.length != state.length) {
                this.stateBefore = new boolean[state.length];
                this.result = new boolean[state.length];
            }
            boolean toggled = false;
            for (int i = 0; i < state.length; ++i) {
                if (!this.stateBefore[i] && state[i]) {
                    this.result[i] = !this.result[i];
                    toggled = true;
                }
                this.stateBefore[i] = state[i];
            }
            SignalTicker.schedule(this, this.result, this.delay);
        }

        @Override
        public void write(boolean preview, NBTTagCompound nbt) {
            if (this.stateBefore != null) {
                nbt.func_74768_a("bandwidth", this.stateBefore.length);
                nbt.func_74768_a("before", BooleanUtils.boolToInt((boolean[])this.stateBefore));
                nbt.func_74768_a("result", BooleanUtils.boolToInt((boolean[])this.result));
            }
            if (preview) {
                return;
            }
            List<ISignalScheduleTicket> tickets = SignalTicker.findTickets(this.component, this);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < tickets.size(); ++i) {
                ISignalScheduleTicket ticket = tickets.get(i);
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{ticket.getDelay(), BooleanUtils.boolToInt((boolean[])ticket.getState())}));
            }
            nbt.func_74782_a("tickets", (NBTBase)list);
        }
    }

    public static abstract class SignalOutputHandlerStoreOne
    extends SignalOutputHandler {
        ISignalScheduleTicket ticket;

        public SignalOutputHandlerStoreOne(ISignalComponent component, int delay, NBTTagCompound nbt) {
            super(component, delay, nbt);
        }
    }
}

