/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleNoClipStructure
extends LittleStructure {
    public HashSet<Entity> entities = new HashSet();
    public boolean web = true;

    public LittleNoClipStructure(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.web = nbt.func_74767_n("web");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74757_a("web", this.web);
    }

    @Override
    public void onEntityCollidedWithBlock(World worldIn, IParentTileList parent, BlockPos pos, Entity entityIn) {
        if (this.web) {
            entityIn.func_70110_aj();
        }
        if (worldIn.field_72995_K) {
            return;
        }
        boolean intersected = false;
        for (LittleTile tile : parent) {
            if (!tile.getBox().getBox(parent.getContext(), pos).func_72326_a(entityIn.func_174813_aQ())) continue;
            intersected = true;
            break;
        }
        if (intersected) {
            this.entities.add(entityIn);
        }
        this.queueForNextTick();
    }

    @Override
    public void onEntityCollidedWithBlockAnimation(EntityAnimation animation, HashMap<Entity, AxisAlignedBB> entities) {
        if (this.web) {
            entities.keySet().forEach(x -> x.func_70110_aj());
        }
        if (animation.field_70170_p.field_72995_K) {
            return;
        }
        this.entities.addAll(entities.keySet());
        this.queueForNextTick();
    }

    @Override
    public boolean queueTick() {
        int players = 0;
        for (Entity entity : this.entities) {
            if (!(entity instanceof EntityPlayer)) continue;
            ++players;
        }
        this.getInput(0).updateState(BooleanUtils.toBits((int)players, (int)4));
        this.getInput(1).updateState(BooleanUtils.toBits((int)this.entities.size(), (int)4));
        boolean wasEmpty = this.entities.isEmpty();
        this.entities.clear();
        return !wasEmpty;
    }

    public static class LittleNoClipStructureParser
    extends LittleStructureGuiParser {
        public LittleNoClipStructureParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            boolean slowness = true;
            if (structure instanceof LittleNoClipStructure) {
                slowness = ((LittleNoClipStructure)structure).web;
            }
            this.parent.controls.add(new GuiCheckBox("web", "slowness (cobwebs)", 3, 0, slowness));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleNoClipStructure parseStructure(LittlePreviews previews) {
            LittleNoClipStructure structure = this.createStructure(LittleNoClipStructure.class, null);
            structure.web = ((GuiCheckBox)this.parent.get((String)"web")).value;
            return structure;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleNoClipStructure.class);
        }
    }
}

