/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.packet.gui.GuiLayerPacket;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.block.BlockStorageTile;
import com.creativemd.littletiles.common.container.SubContainerStorage;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.StackIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleStorage
extends LittleStructure {
    private List<SubContainerStorage> openContainers = new ArrayList<SubContainerStorage>();
    public static int maxSlotStackSize = 64;
    public int inventorySize = 0;
    public int stackSizeLimit = 0;
    public int numberOfSlots = 0;
    public int lastSlotStackSize = 0;
    public InventoryBasic inventory = null;
    public boolean invisibleStorageTiles = false;

    public LittleStorage(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void updateNumberOfSlots() {
        float slots = (float)this.inventorySize / (float)this.stackSizeLimit;
        this.numberOfSlots = (int)Math.ceil(slots);
        this.lastSlotStackSize = (int)(slots % 1.0f * (float)this.stackSizeLimit);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.inventorySize = nbt.func_74762_e("inventorySize");
        this.stackSizeLimit = nbt.func_74762_e("stackSizeLimit");
        this.numberOfSlots = nbt.func_74762_e("numberOfSlots");
        this.lastSlotStackSize = nbt.func_74762_e("lastSlot");
        this.inventory = nbt.func_74764_b("inventory") ? InventoryUtils.loadInventoryBasic((NBTTagCompound)nbt.func_74775_l("inventory")) : null;
        if (this.inventory != null) {
            this.inventory.func_110134_a(x -> this.onInventoryChanged());
        }
        this.invisibleStorageTiles = nbt.func_74767_n("invisibleStorage");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        if (this.inventory != null) {
            nbt.func_74768_a("inventorySize", this.inventorySize);
            nbt.func_74768_a("stackSizeLimit", this.stackSizeLimit);
            nbt.func_74768_a("numberOfSlots", this.numberOfSlots);
            nbt.func_74768_a("lastSlot", this.lastSlotStackSize);
            nbt.func_74782_a("inventory", (NBTBase)InventoryUtils.saveInventoryBasic((IInventory)this.inventory));
        }
        nbt.func_74757_a("invisibleStorage", this.invisibleStorageTiles);
    }

    @Override
    public void onStructureDestroyed() {
        super.onStructureDestroyed();
        if (!this.getWorld().field_72995_K) {
            for (SubContainerStorage container : this.openContainers) {
                container.storage = null;
                NBTTagCompound nbt = new NBTTagCompound();
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new GuiLayerPacket(nbt, container.getLayerID(), true), (EntityPlayerMP)((EntityPlayerMP)container.player));
                container.closeLayer(nbt, true);
            }
        }
    }

    public static int getSizeOfInventory(LittlePreviews previews) {
        double size = 0.0;
        String name = LittleTiles.storageBlock.getRegistryName().toString();
        for (int i = 0; i < previews.size(); ++i) {
            if (!previews.get(i).getBlockName().equals(name)) continue;
            size += previews.get((int)i).box.getSize().getPercentVolume(previews.getContext()) * (double)LittleGridContext.get().maxTilesPerBlock * (double)LittleTiles.CONFIG.general.storagePerPixel;
        }
        return (int)size;
    }

    public boolean hasPlayerOpened(EntityPlayer player) {
        for (SubContainerStorage container : this.openContainers) {
            if (container.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (!worldIn.field_72995_K && !this.hasPlayerOpened(playerIn)) {
            LittleStructureGuiHandler.openGui("littleStorageStructure", new NBTTagCompound(), playerIn, this);
        }
        return true;
    }

    protected void updateInput() {
        this.getInput(0).updateState(new boolean[]{!this.openContainers.isEmpty()});
    }

    public void onInventoryChanged() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        int used = 0;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            used += stack.func_190916_E();
        }
        int filled = (int)((double)used / (double)this.inventorySize * 65535.0);
        this.getInput(1).updateState(BooleanUtils.toBits((int)filled, (int)16));
    }

    public void openContainer(SubContainerStorage container) {
        this.openContainers.add(container);
        this.updateInput();
    }

    public void closeContainer(SubContainerStorage container) {
        this.openContainers.remove((Object)container);
        this.updateInput();
        this.onInventoryChanged();
    }

    @Override
    public void afterPlaced() {
        super.afterPlaced();
        double volume = 0.0;
        try {
            for (IStructureTileList list : this.blocksList()) {
                for (LittleTile tile : list) {
                    if (!(tile.getBlock() instanceof BlockStorageTile)) continue;
                    volume += tile.getPercentVolume(list.getContext());
                }
            }
            this.inventorySize = (int)(volume *= (double)((float)LittleGridContext.get().maxTilesPerBlock * LittleTiles.CONFIG.general.storagePerPixel));
            this.stackSizeLimit = maxSlotStackSize;
            this.updateNumberOfSlots();
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public static class LittleStorageType
    extends LittleStructureType {
        public LittleStorageType(String id, String category, Class<? extends LittleStructure> structureClass, int attribute) {
            super(id, category, structureClass, attribute);
        }

        @Override
        public void addIngredients(LittlePreviews previews, LittleIngredients ingredients) {
            super.addIngredients(previews, ingredients);
            InventoryBasic inventory = InventoryUtils.loadInventoryBasic((NBTTagCompound)previews.structureNBT.func_74775_l("inventory"));
            if (inventory != null) {
                ingredients.add(new StackIngredient((IInventory)inventory));
            }
        }
    }

    public static class LittleStorageParser
    extends LittleStructureGuiParser {
        public LittleStorageParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            this.parent.controls.add(new GuiLabel("space: " + LittleStorage.getSizeOfInventory(previews), 5, 0));
            boolean invisible = false;
            if (structure instanceof LittleStorage) {
                invisible = ((LittleStorage)structure).invisibleStorageTiles;
            }
            this.parent.controls.add(new GuiCheckBox("invisible", "invisible storage tiles", 5, 18, invisible));
        }

        @Override
        public LittleStorage parseStructure(LittlePreviews previews) {
            LittleStorage storage = this.createStructure(LittleStorage.class, null);
            storage.invisibleStorageTiles = ((GuiCheckBox)this.parent.get((String)"invisible")).value;
            for (int i = 0; i < previews.size(); ++i) {
                if (!(previews.get(i).getBlock() instanceof BlockStorageTile)) continue;
                previews.get(i).setInvisibile(storage.invisibleStorageTiles);
            }
            storage.inventorySize = LittleStorage.getSizeOfInventory(previews);
            storage.stackSizeLimit = maxSlotStackSize;
            storage.updateNumberOfSlots();
            storage.inventory = new InventoryBasic("basic", false, storage.numberOfSlots);
            return storage;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleStorage.class);
        }
    }
}

