/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.mc.NBTUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.item.ItemPremadeStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.type.premade.LittleBlankOMatic;
import com.creativemd.littletiles.common.structure.type.premade.LittleExporter;
import com.creativemd.littletiles.common.structure.type.premade.LittleImporter;
import com.creativemd.littletiles.common.structure.type.premade.LittleParticleEmitter;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructureBuilder;
import com.creativemd.littletiles.common.structure.type.premade.LittleWorkbench;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCable;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalDisplay;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.google.common.base.Charsets;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

public abstract class LittleStructurePremade
extends LittleStructure {
    private static LinkedHashMap<String, LittleStructurePremadeEntry> structurePreviews = new LinkedHashMap();
    private static List<LittleStructureTypePremade> premadeStructures = new ArrayList<LittleStructureTypePremade>();
    private static JsonParser parser = new JsonParser();

    public LittleStructurePremade(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public static void reloadPremadeStructures() {
        structurePreviews.clear();
        ItemPremadeStructure.clearCache();
        for (LittleStructureTypePremade type : premadeStructures) {
            try {
                ItemStack stack = type.createItemStackEmpty();
                NBTTagCompound structureNBT = new NBTTagCompound();
                structureNBT.func_74778_a("id", type.id);
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)IOUtils.toString((InputStream)LittleStructurePremade.class.getClassLoader().getResourceAsStream("assets/" + type.modid + "/premade/" + type.id + ".struct"), (Charset)Charsets.UTF_8));
                NBTTagCompound originalNBT = nbt.func_74764_b("structure") ? nbt.func_74775_l("structure") : null;
                nbt.func_74782_a("structure", (NBTBase)structureNBT);
                if (originalNBT != null) {
                    NBTUtils.mergeNotOverwrite((NBTTagCompound)structureNBT, (NBTTagCompound)originalNBT);
                }
                stack.func_77982_d(nbt);
                LittlePreviews previews = LittlePreview.getPreview(stack);
                NBTTagCompound stackNBT = new NBTTagCompound();
                stackNBT.func_74782_a("structure", (NBTBase)structureNBT);
                stack.func_77982_d(stackNBT);
                structurePreviews.put(type.id, new LittleStructurePremadeEntry(previews, stack));
                System.out.println("Loaded " + type.id + " model");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not load '" + type.id + "'! Structure will not be registered");
            }
        }
    }

    public static LittleStructureTypePremade registerPremadeStructureType(String id, String modid, Class<? extends LittleStructurePremade> classStructure) {
        return LittleStructurePremade.registerPremadeStructureType(id, modid, classStructure, 0);
    }

    public static LittleStructureTypePremade registerPremadeStructureType(String id, String modid, Class<? extends LittleStructurePremade> classStructure, int attribute) {
        LittleStructureTypePremade type = (LittleStructureTypePremade)LittleStructureRegistry.registerStructureType(new LittleStructureTypePremade(id, "premade", classStructure, attribute, modid), null);
        premadeStructures.add(type);
        return type;
    }

    public static LittleStructureTypePremade registerPremadeStructureType(LittleStructureTypePremade type) {
        premadeStructures.add((LittleStructureTypePremade)LittleStructureRegistry.registerStructureType(type, null));
        return type;
    }

    public static LittlePreviews getPreviews(String id) {
        LittleStructurePremadeEntry type = LittleStructurePremade.getStructurePremadeEntry(id);
        if (type != null) {
            return type.previews;
        }
        return null;
    }

    public static LittleStructurePremadeEntry getStructurePremadeEntry(String id) {
        return structurePreviews.get(id);
    }

    public static Collection<LittleStructurePremadeEntry> getPremadeStructures() {
        return structurePreviews.values();
    }

    public static List<LittleStructureTypePremade> getPremadeStructureTypes() {
        return premadeStructures;
    }

    public static Set<String> getPremadeStructureIds() {
        return structurePreviews.keySet();
    }

    public static LittleStructureTypePremade getType(String id) {
        LittleStructureType type = LittleStructureRegistry.getStructureType(id);
        if (type instanceof LittleStructureTypePremade) {
            return (LittleStructureTypePremade)type;
        }
        return null;
    }

    public static ItemStack tryGetPremadeStack(String id) {
        LittleStructurePremadeEntry entry = structurePreviews.get(id);
        if (entry != null) {
            return entry.stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getPremadeStack(String id) {
        return LittleStructurePremade.structurePreviews.get((Object)id).stack.func_77946_l();
    }

    @Override
    public ItemStack getStructureDrop() throws CorruptedConnectionException, NotYetConnectedException {
        ItemStack stack = LittleStructurePremade.getPremadeStack(this.type.id).func_77946_l();
        this.load();
        BlockPos.MutableBlockPos pos = this.getMinPos(new BlockPos.MutableBlockPos(this.getPos()));
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, (BlockPos)pos);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("structure", (NBTBase)structureNBT);
        if (this.name != null) {
            NBTTagCompound display = new NBTTagCompound();
            display.func_74778_a("Name", this.name);
            stack.func_77978_p().func_74782_a("display", (NBTBase)display);
        }
        return stack;
    }

    public static void initPremadeStructures() {
        LittleStructurePremade.registerPremadeStructureType("workbench", "littletiles", LittleWorkbench.class);
        LittleStructurePremade.registerPremadeStructureType("importer", "littletiles", LittleImporter.class);
        LittleStructurePremade.registerPremadeStructureType("exporter", "littletiles", LittleExporter.class);
        LittleStructurePremade.registerPremadeStructureType(new LittleParticleEmitter.LittleStructureTypeParticleEmitter("particle_emitter", "premade", LittleParticleEmitter.class, 1024, "littletiles")).addOutput("disabled", 1, SignalMode.TOGGLE, true).setFieldDefault("facing", EnumFacing.UP);
        LittleStructurePremade.registerPremadeStructureType("blankomatic", "littletiles", LittleBlankOMatic.class);
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalCable.LittleStructureTypeCable("single_cable1", "premade", LittleSignalCable.class, 512, "littletiles", 1));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalCable.LittleStructureTypeCable("single_cable4", "premade", LittleSignalCable.class, 512, "littletiles", 4));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalCable.LittleStructureTypeCable("single_cable16", "premade", LittleSignalCable.class, 512, "littletiles", 16));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalOutput.LittleStructureTypeOutput("single_output1", "premade", LittleSignalOutput.class, 512, "littletiles", 1));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalOutput.LittleStructureTypeOutput("single_output4", "premade", LittleSignalOutput.class, 512, "littletiles", 4));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalOutput.LittleStructureTypeOutput("single_output16", "premade", LittleSignalOutput.class, 512, "littletiles", 16));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalInput.LittleStructureTypeInput("single_input1", "premade", LittleSignalInput.class, 512, "littletiles", 1));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalInput.LittleStructureTypeInput("single_input4", "premade", LittleSignalInput.class, 512, "littletiles", 4));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalInput.LittleStructureTypeInput("single_input16", "premade", LittleSignalInput.class, 512, "littletiles", 16));
        LittleStructurePremade.registerPremadeStructureType("signal_display_16", "littletiles", LittleSignalDisplay.class, 2048).addOutput("pixels", 16, SignalMode.EQUAL, true);
        LittleStructurePremade.registerPremadeStructureType("structure_builder", "littletiles", LittleStructureBuilder.class);
        LittleStructureRegistry.registerGuiParserNotFoundHandler(new LittleStructureGuiParser.LittleStructureGuiParserNotFoundHandler(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public LittleStructureGuiParser create(final LittleStructure structure, GuiParent parent, AnimationGuiHandler handler) {
                if (structure instanceof LittleStructurePremade) {
                    return new LittleStructureGuiParser(parent, handler){

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        protected void createControls(LittlePreviews previews, LittleStructure structure2) {
                        }

                        @Override
                        protected LittleStructure parseStructure(LittlePreviews previews) {
                            LittleStructure parsedStructure = structure.type.createStructure(null);
                            parsedStructure.loadFromNBT(previews.structureNBT);
                            return parsedStructure;
                        }

                        @Override
                        protected LittleStructureType getStructureType() {
                            return structure.type;
                        }
                    };
                }
                return null;
            }
        });
    }

    public static class LittleStructurePremadeEntry {
        public final LittlePreviews previews;
        public final ItemStack stack;

        public LittleStructurePremadeEntry(LittlePreviews previews, ItemStack stack) {
            this.previews = previews;
            this.stack = stack;
        }

        public boolean arePreviewsEqual(LittlePreviews previews) {
            return this.previews.isVolumeEqual(previews);
        }
    }

    public static class LittleStructureTypePremade
    extends LittleStructureType {
        public final String modid;
        public boolean showInCreativeTab = true;
        public boolean snapToGrid = true;

        public LittleStructureTypePremade(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid) {
            super(id, category, structureClass, 4 | attribute);
            this.modid = modid;
        }

        public ItemStack createItemStackEmpty() {
            return new ItemStack(LittleTiles.premade);
        }

        public CreativeTabs getCustomTab() {
            return null;
        }

        public ItemStack createItemStack() {
            ItemStack stack = this.createItemStackEmpty();
            NBTTagCompound structureNBT = new NBTTagCompound();
            structureNBT.func_74778_a("id", this.id);
            NBTTagCompound stackNBT = new NBTTagCompound();
            stackNBT.func_74782_a("structure", (NBTBase)structureNBT);
            stack.func_77982_d(stackNBT);
            return stack;
        }

        public LittleStructureTypePremade setNotShowCreativeTab() {
            this.showInCreativeTab = false;
            return this;
        }

        public LittleStructureTypePremade setNotSnapToGrid() {
            this.snapToGrid = false;
            return this;
        }

        @SideOnly(value=Side.CLIENT)
        public List<RenderBox> getRenderingCubes(LittlePreviews previews) {
            return null;
        }

        @Override
        public boolean canOnlyBePlacedByItemStack() {
            return true;
        }
    }
}

