/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.combine;

import com.creativemd.littletiles.common.tile.combine.ICombinable;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import java.util.List;

public class BasicCombiner {
    public static boolean combineBoxes(List<LittleBox> boxes) {
        int sizeBefore = boxes.size();
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = 0; i < boxes.size(); ++i) {
                int j = 0;
                while (j < boxes.size()) {
                    LittleBox box;
                    if (i != j && (box = boxes.get(i).combineBoxes(boxes.get(j))) != null) {
                        boxes.set(i, box);
                        boxes.remove(j);
                        modified = true;
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
        return sizeBefore != boxes.size();
    }

    public static boolean combineBoxesOnlyLast(List<LittleBox> boxes) {
        int sizeBefore = boxes.size();
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = boxes.size() - 1; i < boxes.size(); ++i) {
                int j = 0;
                while (j < boxes.size()) {
                    LittleBox box;
                    if (i != j && (box = boxes.get(i).combineBoxes(boxes.get(j))) != null) {
                        boxes.set(i, box);
                        boxes.remove(j);
                        modified = true;
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
        return sizeBefore != boxes.size();
    }

    public static <T extends ICombinable> boolean combine(List<T> tiles) {
        int sizeBefore = tiles.size();
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = 0; i < tiles.size(); ++i) {
                int j = 0;
                while (j < tiles.size()) {
                    LittleBox box;
                    if (i != j && ((ICombinable)tiles.get(i)).canCombine((ICombinable)tiles.get(j)) && (box = ((ICombinable)tiles.get(i)).getBox().combineBoxes(((ICombinable)tiles.get(j)).getBox())) != null) {
                        ((ICombinable)tiles.get(i)).setBox(box);
                        tiles.remove(j);
                        if (i > j) {
                            --i;
                        }
                        modified = true;
                        continue;
                    }
                    ++j;
                }
            }
        }
        return sizeBefore != tiles.size();
    }
}

