/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.IntegerUtils;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.math.box.BoxFace;
import com.creativemd.creativecore.common.utils.math.geo.NormalPlane;
import com.creativemd.creativecore.common.utils.math.geo.Ray2d;
import com.creativemd.creativecore.common.utils.math.geo.Ray3f;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import com.creativemd.creativecore.common.utils.type.SingletonList;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.client.render.tile.LittleRenderBoxTransformable;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.box.TransformableAxisBox;
import com.creativemd.littletiles.common.tile.math.box.face.LittleBoxFace;
import com.creativemd.littletiles.common.tile.math.box.slice.LittleSlice;
import com.creativemd.littletiles.common.tile.math.vec.LittleRay;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTransformableBox
extends LittleBox {
    private static boolean[][] flipRotationMatrix = new boolean[][]{{false, false, false, false, true, true}, {false, false, false, false, true, true}, {true, true, false, false, false, false}, {true, true, false, false, false, false}, {true, true, true, true, true, true}, {true, true, true, true, true, true}};
    private static boolean[][] flipMirrorMatrix = new boolean[][]{{true, true, true, true, true, true}, {true, true, true, true, true, true}, {true, true, true, true, true, true}};
    private static final Vector3f ZERO = new Vector3f();
    private static final int sliceIterations = 2000;
    private static final int sliceMin = -5000;
    private static final int sliceMax = 5000;
    private static final double sliceConvertEPSILON = 1.0E-4;
    private static final int dataStartIndex = 0;
    private static final int dataEndIndex = 23;
    private static final int flipStartIndex = 24;
    private static final int flipEndIndex = 29;
    private int[] data;
    private SoftReference<VectorFanCache> cache;

    private static boolean[][] buildFlipRotationCache() {
        boolean[][] cache = new boolean[Rotation.values().length][EnumFacing.field_82609_l.length];
        AlignedBox box = new AlignedBox();
        Vector3f center = new Vector3f(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < cache.length; ++i) {
            Rotation rotation = Rotation.values()[i];
            boolean[] flipped = cache[i];
            for (int j = 0; j < EnumFacing.field_82609_l.length; ++j) {
                EnumFacing facing = EnumFacing.field_82609_l[j];
                BoxFace face = BoxFace.get((EnumFacing)facing);
                BoxCorner corner = face.getCornerInQuestion(false, false);
                Vector3f vec = box.getCorner(corner);
                vec.sub((Tuple3f)center);
                RotationUtils.rotate((Vector3f)vec, (Rotation)rotation);
                vec.add((Tuple3f)center);
                EnumFacing rotatedFacing = RotationUtils.rotate((EnumFacing)facing, (Rotation)rotation);
                BoxFace rotatedFace = BoxFace.get((EnumFacing)rotatedFacing);
                flipped[j] = !vec.epsilonEquals((Tuple3f)box.getCorner(rotatedFace.getCornerInQuestion(false, false)), 1.0E-4f) && !vec.epsilonEquals((Tuple3f)box.getCorner(rotatedFace.getCornerInQuestion(true, false)), 1.0E-4f);
            }
        }
        return cache;
    }

    private static boolean[][] buildFlipMirrorCache() {
        boolean[][] cache = new boolean[EnumFacing.Axis.values().length][EnumFacing.field_82609_l.length];
        AlignedBox box = new AlignedBox();
        Vector3f center = new Vector3f(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < cache.length; ++i) {
            EnumFacing.Axis axis = EnumFacing.Axis.values()[i];
            boolean[] flipped = cache[i];
            for (int j = 0; j < EnumFacing.field_82609_l.length; ++j) {
                EnumFacing facing = EnumFacing.field_82609_l[j];
                BoxFace face = BoxFace.get((EnumFacing)facing);
                BoxCorner corner = face.getCornerInQuestion(false, false);
                Vector3f vec = box.getCorner(corner);
                vec.sub((Tuple3f)center);
                RotationUtils.flip((Vector3f)vec, (EnumFacing.Axis)axis);
                vec.add((Tuple3f)center);
                EnumFacing rotatedFacing = RotationUtils.flip((EnumFacing)facing, (EnumFacing.Axis)axis);
                BoxFace rotatedFace = BoxFace.get((EnumFacing)rotatedFacing);
                flipped[j] = !vec.epsilonEquals((Tuple3f)box.getCorner(rotatedFace.getCornerInQuestion(false, false)), 1.0E-4f) && !vec.epsilonEquals((Tuple3f)box.getCorner(rotatedFace.getCornerInQuestion(true, false)), 1.0E-4f);
            }
        }
        return cache;
    }

    public LittleTransformableBox(int[] data) {
        super(data[0], data[1], data[2], data[3], data[4], data[5]);
        this.data = Arrays.copyOfRange(data, 6, data.length);
    }

    public LittleTransformableBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LittleSlice slice) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.data = new int[1];
        LittleVec size = this.getSize();
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)slice.axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)slice.axis);
        EnumFacing preferedSide = slice.getPreferedSide(size);
        CornerCache corners = new CornerCache(true);
        BoxCorner emptyCorner1 = slice.getEmptyCorner();
        BoxCorner emptyCorner2 = emptyCorner1.flip(slice.axis);
        EnumFacing.Axis axis = preferedSide.func_176740_k();
        int direction = preferedSide.func_176734_d().func_176743_c().func_179524_a();
        corners.setRelative(emptyCorner1, axis, direction * size.get(axis));
        corners.setRelative(emptyCorner2, axis, direction * size.get(axis));
        this.data = corners.getData();
    }

    public LittleTransformableBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LittleSlice slice, float startOne, float startTwo, float endOne, float endTwo) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.data = new int[1];
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)slice.axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)slice.axis);
        Vector3d size = new Vector3d((double)(maxX - minX), (double)(maxY - minY), (double)(maxZ - minZ));
        VectorUtils.set((Tuple3d)size, (double)Math.abs(startOne - endOne), (EnumFacing.Axis)one);
        VectorUtils.set((Tuple3d)size, (double)Math.abs(startTwo - endTwo), (EnumFacing.Axis)two);
        EnumFacing preferedSide = slice.getPreferedSide(size);
        CornerCache corners = new CornerCache(false);
        int minOne = this.getMin(one);
        int minTwo = this.getMin(two);
        int maxOne = this.getMax(one);
        int maxTwo = this.getMax(two);
        Ray2d ray = new Ray2d(one, two, (double)((float)minOne + endOne), (double)((float)minTwo + endTwo), (double)((float)minOne + startOne), (double)((float)minTwo + startTwo));
        int counter = maxOne;
        int rayPosOne1 = 0;
        int rayPosTwo1 = 0;
        Double distance1 = null;
        for (int i = 0; i < 2000; ++i) {
            double value = ray.get(one, (double)counter);
            if ((value <= (double)minTwo || value >= (double)maxTwo) && -5000.0 <= value && value < 5000.0) {
                double tempDistance = Math.abs(value - (double)((int)value));
                if (distance1 == null || tempDistance < distance1) {
                    distance1 = tempDistance;
                    rayPosOne1 = counter;
                    rayPosTwo1 = (int)Math.round(value);
                    if (distance1 <= 1.0E-4) break;
                }
            }
            ++counter;
        }
        counter = minOne;
        int rayPosOne2 = 0;
        int rayPosTwo2 = 0;
        Double distance2 = null;
        for (int i = 0; i < 2000; ++i) {
            double value = ray.get(one, (double)counter);
            if ((value <= (double)minTwo || value >= (double)maxTwo) && -5000.0 <= value && value < 5000.0) {
                double tempDistance = Math.abs(value - (double)((int)value));
                if (distance2 == null || tempDistance < distance2) {
                    distance2 = tempDistance;
                    rayPosOne2 = counter;
                    rayPosTwo2 = (int)Math.round(value);
                    if (distance2 <= 1.0E-4) break;
                }
            }
            --counter;
        }
        int newMinOne = Math.min(rayPosOne1, rayPosOne2);
        int newMinTwo = Math.min(rayPosTwo1, rayPosTwo2);
        int newMaxOne = Math.max(rayPosOne1, rayPosOne2);
        int newMaxTwo = Math.max(rayPosTwo1, rayPosTwo2);
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            LittleVec vec = this.get(corner);
            if (corner.isFacingPositive(one)) {
                vec.set(one, newMaxOne);
            } else {
                vec.set(one, newMinOne);
            }
            if (corner.isFacingPositive(two)) {
                vec.set(two, newMaxTwo);
            } else {
                vec.set(two, newMinTwo);
            }
            corners.setAbsolute(corner, vec);
        }
        BoxCorner emptyCorner1 = slice.getEmptyCorner();
        BoxCorner emptyCorner2 = emptyCorner1.flip(slice.axis);
        EnumFacing.Axis axis = preferedSide.func_176740_k();
        int newValue = preferedSide.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? (axis == one ? newMinOne : newMinTwo) : (axis == one ? newMaxOne : newMaxTwo);
        corners.setAbsolute(emptyCorner1, axis, newValue);
        corners.setAbsolute(emptyCorner2, axis, newValue);
        this.data = corners.getData();
    }

    public LittleTransformableBox(LittleBox box, int[] data) {
        super(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
        this.data = data;
    }

    public TransformableAxisBox getBox(LittleGridContext context, BlockPos offset) {
        return new TransformableAxisBox(this, context, context.toVanillaGrid(this.minX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.minY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.minZ) + (double)offset.func_177952_p(), context.toVanillaGrid(this.maxX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.maxY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.maxZ) + (double)offset.func_177952_p());
    }

    public TransformableAxisBox getBox(LittleGridContext context) {
        return new TransformableAxisBox(this, context, context.toVanillaGrid(this.minX), context.toVanillaGrid(this.minY), context.toVanillaGrid(this.minZ), context.toVanillaGrid(this.maxX), context.toVanillaGrid(this.maxY), context.toVanillaGrid(this.maxZ));
    }

    public int getIndicator() {
        return this.data[0];
    }

    public void setFlipped(int facing, boolean value) {
        this.data[0] = IntegerUtils.set((int)this.getIndicator(), (int)(24 + facing), (boolean)value);
        this.changed();
    }

    public boolean getFlipped(int facing) {
        return IntegerUtils.bitIs((int)this.getIndicator(), (int)(24 + facing));
    }

    public void setFlipped(EnumFacing facing, boolean value) {
        this.data[0] = IntegerUtils.set((int)this.getIndicator(), (int)(24 + facing.ordinal()), (boolean)value);
        this.changed();
    }

    public boolean getFlipped(EnumFacing facing) {
        return IntegerUtils.bitIs((int)this.getIndicator(), (int)(24 + facing.ordinal()));
    }

    public void setData(int[] data) {
        this.data = data;
        this.cache = null;
    }

    public void setData(int index, short value) {
        int realIndex = index / 2 + 1;
        this.data[realIndex] = index % 2 == 1 ? this.data[realIndex] & 0xFFFF0000 | value & 0xFFFF : value << 16 | this.data[realIndex] & 0xFFFF;
        this.changed();
    }

    public short getData(int index) {
        int realIndex = index / 2 + 1;
        if (index % 2 == 1) {
            return (short)(this.data[realIndex] & 0xFFFF);
        }
        return (short)(this.data[realIndex] >> 16 & 0xFFFF);
    }

    public Vector3f[] getTiltedCorners() {
        Vector3f[] corners = new Vector3f[BoxCorner.values().length];
        int indicator = this.getIndicator();
        int activeBits = 0;
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            short x = 0;
            short y = 0;
            short z = 0;
            int index = i * 3;
            if (IntegerUtils.bitIs((int)indicator, (int)index)) {
                x = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 1))) {
                y = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 2))) {
                z = this.getData(activeBits);
                ++activeBits;
            }
            corners[i] = new Vector3f((float)(x + this.get(corner.x)), (float)(y + this.get(corner.y)), (float)(z + this.get(corner.z)));
        }
        return corners;
    }

    @Override
    public void changed() {
        super.changed();
        this.cache = null;
    }

    private static boolean checkEqual(Vector3f[] corners, LittleVec[] otherCorners, BoxCorner[] toCheck, EnumFacing.Axis axis) {
        block5: for (int j = 0; j < toCheck.length; ++j) {
            BoxCorner corner = toCheck[j];
            switch (axis) {
                case X: {
                    if (corners[corner.ordinal()].x == (float)otherCorners[corner.ordinal()].x) continue block5;
                    return false;
                }
                case Y: {
                    if (corners[corner.ordinal()].y == (float)otherCorners[corner.ordinal()].y) continue block5;
                    return false;
                }
                case Z: {
                    if (corners[corner.ordinal()].z == (float)otherCorners[corner.ordinal()].z) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    private static VectorFan createStrip(BoxCorner[] corners, Vector3f[] vec) {
        Vector3f[] coords = new Vector3f[corners.length];
        int index = 0;
        block0: for (int i = 0; i < coords.length; ++i) {
            for (int j = 0; j < index; ++j) {
                if (vec[corners[i].ordinal()].epsilonEquals((Tuple3f)coords[j], 1.0E-4f)) continue block0;
            }
            coords[index] = vec[corners[i].ordinal()];
            ++index;
        }
        if (index < coords.length) {
            if (index < 3) {
                return null;
            }
            return new VectorFan(Arrays.copyOf(coords, index));
        }
        return new VectorFan(coords);
    }

    public synchronized VectorFanCache requestCache() {
        boolean inverted;
        BoxFace face;
        EnumFacing facing;
        int i;
        VectorFanCache temp;
        if (this.cache != null && (temp = this.cache.get()) != null) {
            return temp;
        }
        VectorFanCache cache = new VectorFanCache();
        NormalPlane[] planes = new NormalPlane[EnumFacing.field_82609_l.length];
        for (int i2 = 0; i2 < planes.length; ++i2) {
            EnumFacing facing2 = EnumFacing.field_82609_l[i2];
            EnumFacing.Axis axis = facing2.func_176740_k();
            NormalPlane plane = new NormalPlane(new Vector3f(), new Vector3f());
            plane.origin.set(0.0f, 0.0f, 0.0f);
            VectorUtils.set((Tuple3f)plane.origin, (float)this.get(facing2), (EnumFacing.Axis)axis);
            plane.normal.set(0.0f, 0.0f, 0.0f);
            VectorUtils.set((Tuple3f)plane.normal, (float)facing2.func_176743_c().func_179524_a(), (EnumFacing.Axis)axis);
            planes[i2] = plane;
            cache.faces[i2] = new VectorFanFaceCache();
        }
        NormalPlane[] tiltedPlanes = new NormalPlane[EnumFacing.field_82609_l.length * 2];
        Vector3f[] corners = this.getTiltedCorners();
        LittleVec[] boxCorners = this.getCorners();
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            int j;
            facing = EnumFacing.field_82609_l[i];
            face = BoxFace.get((EnumFacing)facing);
            inverted = this.getFlipped(facing);
            VectorFanFaceCache faceCache = cache.faces[i];
            BoxCorner[] first = face.getTriangleFirst(inverted);
            Vector3f firstNormal = BoxFace.getTraingleNormal((BoxCorner[])first, (Vector3f[])corners);
            boolean firstSame = LittleTransformableBox.checkEqual(corners, boxCorners, first, facing.func_176740_k());
            BoxCorner[] second = face.getTriangleSecond(inverted);
            Vector3f secondNormal = BoxFace.getTraingleNormal((BoxCorner[])second, (Vector3f[])corners);
            boolean secondSame = LittleTransformableBox.checkEqual(corners, boxCorners, second, facing.func_176740_k());
            if (firstSame && secondSame) continue;
            firstNormal.normalize();
            secondNormal.normalize();
            boolean parallel = firstNormal.epsilonEquals((Tuple3f)secondNormal, 1.0E-4f);
            if (parallel) {
                if (!firstSame && !firstNormal.epsilonEquals((Tuple3f)ZERO, 1.0E-4f)) {
                    faceCache.tiltedStrip1 = LittleTransformableBox.createStrip(face.corners, corners);
                    if (faceCache.tiltedStrip1 != null) {
                        tiltedPlanes[i * 2] = new NormalPlane(corners[first[0].ordinal()], firstNormal);
                    }
                }
            } else {
                if (!firstSame && !firstNormal.epsilonEquals((Tuple3f)ZERO, 1.0E-4f)) {
                    faceCache.tiltedStrip1 = LittleTransformableBox.createStrip(first, corners);
                    if (faceCache.tiltedStrip1 != null) {
                        tiltedPlanes[i * 2] = new NormalPlane(corners[first[0].ordinal()], firstNormal);
                    }
                }
                if (!secondSame && !secondNormal.epsilonEquals((Tuple3f)ZERO, 1.0E-4f)) {
                    faceCache.tiltedStrip2 = LittleTransformableBox.createStrip(second, corners);
                    if (faceCache.tiltedStrip2 != null) {
                        tiltedPlanes[i * 2 + 1] = new NormalPlane(corners[second[0].ordinal()], secondNormal);
                    }
                }
            }
            if (faceCache.tiltedStrip1 != null && tiltedPlanes[i * 2].isInvalid()) {
                faceCache.tiltedStrip1 = null;
                tiltedPlanes[i * 2] = null;
            }
            if (faceCache.tiltedStrip2 != null && tiltedPlanes[i * 2 + 1].isInvalid()) {
                faceCache.tiltedStrip2 = null;
                tiltedPlanes[i * 2 + 1] = null;
            }
            if (faceCache.tiltedStrip1 != null && faceCache.tiltedStrip2 != null) {
                for (j = 0; j < faceCache.tiltedStrip2.count(); ++j) {
                    Vector3f vec = faceCache.tiltedStrip2.get(j);
                    if (!BooleanUtils.isTrue((Boolean)tiltedPlanes[i * 2].isInFront(vec, 1.0E-4f))) continue;
                    faceCache.convex = false;
                    break;
                }
            }
            for (j = 0; j < planes.length; ++j) {
                if (faceCache.tiltedStrip1 != null) {
                    faceCache.tiltedStrip1 = faceCache.tiltedStrip1.cut(planes[j]);
                }
                if (faceCache.tiltedStrip2 == null) continue;
                faceCache.tiltedStrip2 = faceCache.tiltedStrip2.cut(planes[j]);
            }
            faceCache.sortTiltedStrips(cache, tiltedPlanes[i * 2], tiltedPlanes[i * 2 + 1]);
        }
        block4: for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            facing = EnumFacing.field_82609_l[i];
            face = BoxFace.get((EnumFacing)facing);
            inverted = this.getFlipped(facing);
            VectorFanFaceCache axisFaceCache = cache.faces[i];
            axisFaceCache.axisStrips.add(new VectorFan(this.getVecArray(face.corners)));
            NormalPlane plane = planes[i];
            for (int j = 0; j < EnumFacing.field_82609_l.length; ++j) {
                NormalPlane cutPlane2;
                NormalPlane cutPlane1;
                VectorFanFaceCache faceCache = cache.faces[j];
                if (faceCache.tiltedStrip1 == null && faceCache.tiltedStrip2 == null) {
                    cutPlane1 = tiltedPlanes[j * 2];
                    cutPlane2 = tiltedPlanes[j * 2 + 1];
                    if (faceCache.convex) {
                        if (cutPlane1 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane1);
                        }
                        if (cutPlane2 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane2);
                        }
                    } else {
                        axisFaceCache.cutAxisStrip(facing, cutPlane1, cutPlane2);
                    }
                } else {
                    cutPlane1 = null;
                    cutPlane2 = null;
                    if (!faceCache.convex || faceCache.tiltedStrip1 != null && faceCache.tiltedStrip2 != null) {
                        cutPlane1 = tiltedPlanes[j * 2];
                        cutPlane2 = tiltedPlanes[j * 2 + 1];
                    } else if (faceCache.tiltedStrip1 != null) {
                        cutPlane1 = tiltedPlanes[j * 2];
                    } else if (faceCache.tiltedStrip2 != null) {
                        cutPlane1 = tiltedPlanes[j * 2 + 1];
                    }
                    if (faceCache.convex) {
                        if (cutPlane1 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane1);
                        }
                        if (cutPlane2 != null) {
                            axisFaceCache.cutAxisStrip(cutPlane2);
                        }
                    } else {
                        axisFaceCache.cutAxisStrip(facing, cutPlane1, cutPlane2);
                    }
                }
                if (!axisFaceCache.hasAxisStrip()) continue block4;
            }
        }
        this.cache = new SoftReference<VectorFanCache>(cache);
        return cache;
    }

    @Override
    public int[] getArray() {
        int[] array = new int[6 + this.data.length];
        array[0] = this.minX;
        array[1] = this.minY;
        array[2] = this.minZ;
        array[3] = this.maxX;
        array[4] = this.maxY;
        array[5] = this.maxZ;
        for (int i = 0; i < this.data.length; ++i) {
            array[i + 6] = this.data[i];
        }
        return array;
    }

    @Override
    public int getSmallestContext(LittleGridContext context) {
        int size = super.getSmallestContext(context);
        Iterator<TransformablePoint> points = this.points();
        while (points.hasNext()) {
            size = Math.max(size, context.getMinGrid(points.next().getRelative()));
        }
        return size;
    }

    @Override
    protected void scale(int ratio) {
        VectorFanCache temp;
        super.scale(ratio);
        Iterator<TransformablePoint> points = this.points();
        while (points.hasNext()) {
            TransformablePoint point = points.next();
            point.setRelative((short)(point.getRelative() * ratio));
        }
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.scale(ratio);
        }
    }

    @Override
    protected void divide(int ratio) {
        VectorFanCache temp;
        super.divide(ratio);
        Iterator<TransformablePoint> points = this.points();
        while (points.hasNext()) {
            TransformablePoint point = points.next();
            point.setRelative((short)(point.getRelative() / ratio));
        }
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.divide(ratio);
        }
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean doesFillEntireBlock(LittleGridContext context) {
        return false;
    }

    @Override
    public LittleBox combineBoxes(LittleBox box) {
        if (box instanceof LittleTransformableBox) {
            LittleTransformableBox result;
            EnumFacing facing = box.sharedBoxFaceWithoutBounds(this);
            if (facing == null) {
                return null;
            }
            Iterator<TransformableVec> points = this.corners();
            Iterator<TransformableVec> otherPoints = ((LittleTransformableBox)box).corners();
            TransformableVec point = null;
            TransformableVec otherPoint = null;
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)facing.func_176740_k());
            while (points.hasNext() || otherPoints.hasNext()) {
                point = points.hasNext() ? points.next() : null;
                otherPoint = otherPoints.hasNext() ? otherPoints.next() : null;
                while (point != null && (otherPoint == null || point.corner.ordinal() < otherPoint.corner.ordinal())) {
                    if (box.get(point.corner, one) != point.getAbsolute(one) || box.get(point.corner, two) != point.getAbsolute(two)) {
                        return null;
                    }
                    if (points.hasNext()) {
                        point = points.next();
                        continue;
                    }
                    point = null;
                }
                while (otherPoint != null && (point == null || point.corner.ordinal() > otherPoint.corner.ordinal())) {
                    if (this.get(otherPoint.corner, one) != otherPoint.getAbsolute(one) || this.get(otherPoint.corner, two) != otherPoint.getAbsolute(two)) {
                        return null;
                    }
                    if (otherPoints.hasNext()) {
                        otherPoint = otherPoints.next();
                        continue;
                    }
                    otherPoint = null;
                }
                if (point == null || otherPoint == null || point.getAbsolute(one) == otherPoint.getAbsolute(one) && point.getAbsolute(two) == otherPoint.getAbsolute(two)) continue;
                return null;
            }
            if (!this.requestCache().get(facing).equalAxisStrip(((LittleTransformableBox)box).requestCache().get(facing.func_176734_d()), facing.func_176740_k())) {
                return null;
            }
            CornerCache cornerCache = new CornerCache(false);
            this.setAbsoluteCorners(cornerCache);
            LittleTransformableBox littleTransformableBox = (LittleTransformableBox)box;
            littleTransformableBox.getClass();
            CornerCache otherCornerCache = littleTransformableBox.new CornerCache(false);
            ((LittleTransformableBox)box).setAbsoluteCorners(otherCornerCache);
            LittleRay ray = new LittleRay(new LittleVec(0, 0, 0), new LittleVec(0, 0, 0));
            LittleRay ray2 = new LittleRay(new LittleVec(0, 0, 0), new LittleVec(0, 0, 0));
            BoxCorner[] corners = BoxCorner.faceCorners((EnumFacing)facing);
            for (int i = 0; i < corners.length; ++i) {
                BoxCorner corner = corners[i];
                BoxCorner otherCorner = corner.flip(facing.func_176740_k());
                ray.set(cornerCache.getOrCreate(corner), cornerCache.getOrCreate(otherCorner));
                ray2.set(otherCornerCache.getOrCreate(corner), otherCornerCache.getOrCreate(otherCorner));
                if (!ray.parallel(ray2)) {
                    return null;
                }
                if (ray.direction.x != 0 || ray.direction.y != 0 || ray.direction.z != 0) continue;
                BoxCorner newCorner = otherCorner.flip(one);
                ray.set(cornerCache.getOrCreate(corner), cornerCache.getOrCreate(newCorner));
                ray2.set(otherCornerCache.getOrCreate(corner), otherCornerCache.getOrCreate(newCorner));
                if (!ray.parallel(ray2)) {
                    return null;
                }
                newCorner = otherCorner.flip(two);
                ray.set(cornerCache.getOrCreate(corner), cornerCache.getOrCreate(newCorner));
                ray2.set(otherCornerCache.getOrCreate(corner), otherCornerCache.getOrCreate(newCorner));
                if (ray.parallel(ray2)) continue;
                return null;
            }
            LittleTransformableBox littleTransformableBox2 = result = new LittleTransformableBox(new LittleBox(this, box), (int[])this.data.clone());
            littleTransformableBox2.getClass();
            CornerCache cache = littleTransformableBox2.new CornerCache(false);
            ((LittleTransformableBox)box).setAbsoluteCornersTakeBounds(cache);
            this.setAbsoluteCornersTakeBounds(cache);
            result.data = cache.getData();
            return result;
        }
        LittleBox newBox = super.combine(box);
        if (newBox == null) {
            return null;
        }
        if (box.getClass() == LittleBox.class) {
            LittleTransformableBox test;
            LittleTransformableBox littleTransformableBox = test = new LittleTransformableBox(box, this.data);
            littleTransformableBox.getClass();
            CornerCache cache = littleTransformableBox.new CornerCache(false);
            this.setAbsoluteCorners(cache);
            test.data = cache.getData();
            if (test.requestCache().isCompletelyFilled()) {
                LittleTransformableBox result;
                LittleTransformableBox littleTransformableBox3 = result = new LittleTransformableBox(newBox, this.data);
                littleTransformableBox3.getClass();
                cache = littleTransformableBox3.new CornerCache(false);
                this.setAbsoluteCorners(cache);
                result.data = cache.getData();
                return result;
            }
        }
        return null;
    }

    @Override
    public boolean isFaceSolid(EnumFacing facing) {
        return this.requestCache().get(facing).isCompletelyFilled();
    }

    @Override
    public boolean isFacePartiallyFilled(EnumFacing facing) {
        return this.requestCache().get(facing).hasAxisStrip();
    }

    @Override
    protected boolean intersectsWith(LittleBox box) {
        if (super.intersectsWith(box)) {
            if (box instanceof LittleTransformableBox) {
                return this.intersectsWith(((LittleTransformableBox)box).requestCache()) || ((LittleTransformableBox)box).intersectsWith(this.requestCache());
            }
            VectorFanCache ownCache = this.requestCache();
            for (int i = 0; i < ownCache.faces.length; ++i) {
                for (VectorFan fan : ownCache.faces[i]) {
                    for (int j = 0; j < fan.count(); ++j) {
                        if (!box.isVecInside(fan.get(j))) continue;
                        return true;
                    }
                }
            }
            VectorFanCache newCache = new VectorFanCache();
            for (int i = 0; i < newCache.faces.length; ++i) {
                EnumFacing facing = EnumFacing.field_82609_l[i];
                BoxFace face = BoxFace.get((EnumFacing)facing);
                VectorFanFaceCache faceCache = new VectorFanFaceCache();
                faceCache.axisStrips.add(new VectorFan(box.getVecArray(face.corners)));
                newCache.faces[i] = faceCache;
            }
            return this.intersectsWith(newCache);
        }
        return false;
    }

    protected boolean intersectsWith(VectorFanCache cache) {
        VectorFanCache ownCache = this.requestCache();
        for (int i = 0; i < ownCache.faces.length; ++i) {
            VectorFanFaceCache face = ownCache.faces[i];
            VectorFanFaceCache otherFace = cache.faces[i];
            if (!face.hasAxisStrip() || !otherFace.hasAxisStrip()) continue;
            EnumFacing facing = EnumFacing.field_82609_l[i];
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            for (VectorFan fan : face.axisStrips) {
                for (VectorFan fan2 : otherFace.axisStrips) {
                    if (VectorUtils.get((EnumFacing.Axis)axis, (Tuple3f)fan.get(0)) != VectorUtils.get((EnumFacing.Axis)axis, (Tuple3f)fan2.get(0)) || !fan.intersect2d(fan2, one, two, facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE)) continue;
                    return true;
                }
            }
        }
        ArrayList<List<NormalPlane>> shapes = new ArrayList<List<NormalPlane>>();
        shapes.add(new ArrayList());
        for (int i = 0; i < ownCache.faces.length; ++i) {
            VectorFanFaceCache face = ownCache.faces[i];
            if (face.hasTiltedStrip()) {
                NormalPlane plane2;
                NormalPlane plane1 = face.tiltedStrip1 != null ? face.tiltedStrip1.createPlane() : null;
                NormalPlane normalPlane = plane2 = face.tiltedStrip2 != null ? face.tiltedStrip2.createPlane() : null;
                if (face.convex) {
                    for (int j = 0; j < shapes.size(); ++j) {
                        if (plane1 != null) {
                            ((List)shapes.get(j)).add(plane1);
                        }
                        if (plane2 == null) continue;
                        ((List)shapes.get(j)).add(plane2);
                    }
                } else {
                    int sizeBefore = shapes.size();
                    for (int j = 0; j < sizeBefore; ++j) {
                        if (plane1 != null && plane2 != null) {
                            ArrayList<NormalPlane> newList = new ArrayList<NormalPlane>((Collection)shapes.get(j));
                            ((List)shapes.get(j)).add(plane1);
                            newList.add(plane2);
                            shapes.add(newList);
                            continue;
                        }
                        if (plane1 != null) {
                            ((List)shapes.get(j)).add(plane1);
                            continue;
                        }
                        if (plane2 == null) continue;
                        ((List)shapes.get(j)).add(plane2);
                    }
                }
            }
            if (!face.hasAxisStrip()) continue;
            for (int j = 0; j < shapes.size(); ++j) {
                EnumFacing facing = EnumFacing.field_82609_l[i];
                EnumFacing.Axis axis = facing.func_176740_k();
                NormalPlane plane = new NormalPlane(new Vector3f(), new Vector3f());
                plane.origin.set(0.0f, 0.0f, 0.0f);
                VectorUtils.set((Tuple3f)plane.origin, (float)this.get(facing), (EnumFacing.Axis)axis);
                plane.normal.set(0.0f, 0.0f, 0.0f);
                VectorUtils.set((Tuple3f)plane.normal, (float)facing.func_176743_c().func_179524_a(), (EnumFacing.Axis)axis);
                ((List)shapes.get(j)).add(plane);
            }
        }
        return cache.isInside(shapes);
    }

    @Override
    public void rotateBox(Rotation rotation, LittleVec doubledCenter) {
        int i;
        CornerCache cache = new CornerCache(false);
        Iterator<TransformableVec> corners = this.corners();
        while (corners.hasNext()) {
            TransformableVec vec = corners.next();
            long tempX = vec.getAbsoluteX() * 2 - doubledCenter.x;
            long tempY = vec.getAbsoluteY() * 2 - doubledCenter.y;
            long tempZ = vec.getAbsoluteZ() * 2 - doubledCenter.z;
            LittleVec rotatedVec = new LittleVec(0, 0, 0);
            rotatedVec.x = (int)((rotation.getMatrix().getX(tempX, tempY, tempZ) + (long)doubledCenter.x) / 2L);
            rotatedVec.y = (int)((rotation.getMatrix().getY(tempX, tempY, tempZ) + (long)doubledCenter.y) / 2L);
            rotatedVec.z = (int)((rotation.getMatrix().getZ(tempX, tempY, tempZ) + (long)doubledCenter.z) / 2L);
            cache.setAbsolute(vec.corner.rotate(rotation), rotatedVec);
        }
        super.rotateBox(rotation, doubledCenter);
        this.data = cache.getData();
        boolean[] cachedFlipped = new boolean[6];
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            cachedFlipped[i] = this.getFlipped(i);
        }
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = RotationUtils.rotate((EnumFacing)EnumFacing.func_82600_a((int)i), (Rotation)rotation);
            if (flipRotationMatrix[rotation.ordinal()][i]) {
                this.setFlipped(facing.ordinal(), !cachedFlipped[i]);
                continue;
            }
            this.setFlipped(facing.ordinal(), cachedFlipped[i]);
        }
    }

    @Override
    public void flipBox(EnumFacing.Axis axis, LittleVec doubledCenter) {
        int i;
        CornerCache cache = new CornerCache(false);
        Iterator<TransformableVec> corners = this.corners();
        while (corners.hasNext()) {
            TransformableVec vec = corners.next();
            long tempX = vec.getAbsoluteX() * 2 - doubledCenter.x;
            long tempY = vec.getAbsoluteY() * 2 - doubledCenter.y;
            long tempZ = vec.getAbsoluteZ() * 2 - doubledCenter.z;
            LittleVec flippedVec = new LittleVec(0, 0, 0);
            switch (axis) {
                case X: {
                    tempX = -tempX;
                    break;
                }
                case Y: {
                    tempY = -tempY;
                    break;
                }
                case Z: {
                    tempZ = -tempZ;
                }
            }
            flippedVec.x = (int)((tempX + (long)doubledCenter.x) / 2L);
            flippedVec.y = (int)((tempY + (long)doubledCenter.y) / 2L);
            flippedVec.z = (int)((tempZ + (long)doubledCenter.z) / 2L);
            cache.setAbsolute(vec.corner.flip(axis), flippedVec);
        }
        super.flipBox(axis, doubledCenter);
        this.data = cache.getData();
        boolean[] cachedFlipped = new boolean[6];
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            cachedFlipped[i] = this.getFlipped(i);
        }
        for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing facing = RotationUtils.flip((EnumFacing)EnumFacing.func_82600_a((int)i), (EnumFacing.Axis)axis);
            if (flipMirrorMatrix[axis.ordinal()][i]) {
                this.setFlipped(facing.ordinal(), !cachedFlipped[i]);
                continue;
            }
            this.setFlipped(facing.ordinal(), cachedFlipped[i]);
        }
    }

    protected void setAbsoluteCorners(CornerCache cache) {
        int indicator = this.getIndicator();
        int activeBits = 0;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            short x = 0;
            short y = 0;
            short z = 0;
            int index = i * 3;
            if (IntegerUtils.bitIs((int)indicator, (int)index)) {
                x = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 1))) {
                y = this.getData(activeBits);
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 2))) {
                z = this.getData(activeBits);
                ++activeBits;
            }
            cache.setAbsolute(corner, new LittleVec(x + this.get(corner.x), y + this.get(corner.y), z + this.get(corner.z)));
        }
    }

    protected void setAbsoluteCornersTakeBounds(CornerCache cache) {
        int indicator = this.getIndicator();
        int activeBits = 0;
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            int index = i * 3;
            if (IntegerUtils.bitIs((int)indicator, (int)index)) {
                cache.setAbsolute(corner, EnumFacing.Axis.X, this.getData(activeBits) + this.get(corner.x));
                ++activeBits;
            }
            if (IntegerUtils.bitIs((int)indicator, (int)(index + 1))) {
                cache.setAbsolute(corner, EnumFacing.Axis.Y, this.getData(activeBits) + this.get(corner.y));
                ++activeBits;
            }
            if (!IntegerUtils.bitIs((int)indicator, (int)(index + 2))) continue;
            cache.setAbsolute(corner, EnumFacing.Axis.Z, this.getData(activeBits) + this.get(corner.z));
            ++activeBits;
        }
    }

    @Override
    public LittleBox extractBox(int x, int y, int z, @Nullable LittleBoxReturnedVolume volume) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = this.copy();
        littleTransformableBox.getClass();
        CornerCache cache = littleTransformableBox.new CornerCache(false);
        box.minX = x;
        box.minY = y;
        box.minZ = z;
        box.maxX = x + 1;
        box.maxY = y + 1;
        box.maxZ = z + 1;
        this.setAbsoluteCorners(cache);
        box.data = cache.getData();
        box.cache = null;
        if (!box.requestCache().isInvalid()) {
            if (box.requestCache().isCompletelyFilled()) {
                return new LittleBox(x, y, z, x + 1, y + 1, z + 1);
            }
            return box;
        }
        if (volume != null) {
            volume.addPixel();
        }
        return null;
    }

    @Override
    public LittleBox extractBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @Nullable LittleBoxReturnedVolume volume) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = this.copy();
        littleTransformableBox.getClass();
        CornerCache cache = littleTransformableBox.new CornerCache(false);
        box.minX = minX;
        box.minY = minY;
        box.minZ = minZ;
        box.maxX = maxX;
        box.maxY = maxY;
        box.maxZ = maxZ;
        this.setAbsoluteCorners(cache);
        box.data = cache.getData();
        box.cache = null;
        if (!box.requestCache().isInvalid()) {
            if (box.requestCache().isCompletelyFilled()) {
                return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
            }
            box.requestCache().setBounds(minX, minY, minZ, maxX, maxY, maxZ);
            box.data = cache.getData();
            if (volume != null) {
                volume.addDifBox(box, minX, minY, minZ, maxX, maxY, maxZ);
            }
            return box;
        }
        if (volume != null) {
            volume.addBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return null;
    }

    @Override
    public LittleTransformableBox copy() {
        return new LittleTransformableBox((LittleBox)this, (int[])this.data.clone());
    }

    @Override
    public LittleBox grow(EnumFacing facing) {
        LittleBox box = super.grow(facing);
        if (box != null) {
            return new LittleTransformableBox(box, this.data);
        }
        return null;
    }

    @Override
    public LittleBox shrink(EnumFacing facing, boolean toLimit) {
        LittleBox box = super.shrink(facing, toLimit);
        if (box != null) {
            return new LittleTransformableBox(box, this.data);
        }
        return null;
    }

    protected Iterator<TransformableVec> corners() {
        return new Iterator<TransformableVec>(){
            int indicator;
            int corner;
            int activeBits;
            LittleVec vec;
            TransformableVec holder;
            {
                this.indicator = LittleTransformableBox.this.getIndicator();
                this.corner = -1;
                this.activeBits = 0;
                this.vec = new LittleVec(0, 0, 0);
                this.holder = new TransformableVec();
                this.findNext();
            }

            void findNext() {
                ++this.corner;
                while (this.corner < BoxCorner.values().length) {
                    short x = 0;
                    short y = 0;
                    short z = 0;
                    int index = this.corner * 3;
                    if (IntegerUtils.bitIs((int)this.indicator, (int)index)) {
                        x = LittleTransformableBox.this.getData(this.activeBits);
                        ++this.activeBits;
                    }
                    if (IntegerUtils.bitIs((int)this.indicator, (int)(index + 1))) {
                        y = LittleTransformableBox.this.getData(this.activeBits);
                        ++this.activeBits;
                    }
                    if (IntegerUtils.bitIs((int)this.indicator, (int)(index + 2))) {
                        z = LittleTransformableBox.this.getData(this.activeBits);
                        ++this.activeBits;
                    }
                    if (x != 0 || y != 0 || z != 0) {
                        this.vec.set(x, y, z);
                        return;
                    }
                    ++this.corner;
                }
                this.vec = null;
            }

            @Override
            public boolean hasNext() {
                return this.vec != null;
            }

            @Override
            public TransformableVec next() {
                if (this.holder == null) {
                    throw new NoSuchElementException();
                }
                TransformableVec toReturn = this.holder.set(this.activeBits, BoxCorner.values()[this.corner], this.vec.x, this.vec.y, this.vec.z);
                this.findNext();
                if (!this.hasNext()) {
                    this.holder = null;
                }
                return toReturn;
            }
        };
    }

    protected Iterator<TransformablePoint> points() {
        return new Iterator<TransformablePoint>(){
            int indicator;
            int corner;
            int axisIndex;
            int index;
            int activeBits;
            TransformablePoint point;
            {
                this.indicator = LittleTransformableBox.this.getIndicator();
                this.corner = 0;
                this.axisIndex = -1;
                this.index = -1;
                this.activeBits = -1;
                this.point = new TransformablePoint();
                this.findNext();
            }

            void inc() {
                ++this.axisIndex;
                ++this.index;
                if (this.axisIndex == 3) {
                    ++this.corner;
                    this.axisIndex = 0;
                }
            }

            void findNext() {
                this.inc();
                while (this.index < 24 && !IntegerUtils.bitIs((int)this.indicator, (int)this.index)) {
                    this.inc();
                }
                ++this.activeBits;
            }

            @Override
            public boolean hasNext() {
                return this.index < 24;
            }

            @Override
            public TransformablePoint next() {
                if (this.point == null) {
                    throw new NoSuchElementException();
                }
                TransformablePoint toReturn = this.point.set(this.corner * 3 + this.axisIndex, this.activeBits, EnumFacing.Axis.values()[this.axisIndex], BoxCorner.values()[this.corner]);
                this.findNext();
                TransformablePoint temp = this.point;
                if (!this.hasNext()) {
                    this.point = null;
                }
                return temp;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleRenderBox getRenderingCube(LittleGridContext context, AlignedBox cube, Block block, int meta) {
        return new LittleRenderBoxTransformable(cube, context, this, block, meta);
    }

    @Override
    public RayTraceResult calculateIntercept(LittleGridContext context, BlockPos pos, Vec3d vecA, Vec3d vecB) {
        VectorFanCache cache = this.requestCache();
        Vector3f start = new Vector3f((float)(vecA.field_72450_a - (double)pos.func_177958_n()), (float)(vecA.field_72448_b - (double)pos.func_177956_o()), (float)(vecA.field_72449_c - (double)pos.func_177952_p()));
        Vector3f end = new Vector3f((float)(vecB.field_72450_a - (double)pos.func_177958_n()), (float)(vecB.field_72448_b - (double)pos.func_177956_o()), (float)(vecB.field_72449_c - (double)pos.func_177952_p()));
        start.scale((float)context.size);
        end.scale((float)context.size);
        Ray3f ray = new Ray3f(start, end);
        vecA = vecA.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d collision = null;
        EnumFacing collided = null;
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            VectorFanFaceCache face = cache.get(EnumFacing.field_82609_l[i]);
            for (VectorFan strip : face) {
                Vec3d temp = strip.calculateIntercept(ray);
                if (temp != null) {
                    temp = temp.func_186678_a(context.pixelSize);
                }
                if (temp == null || !LittleTransformableBox.isClosest(vecA, collision, temp)) continue;
                collided = EnumFacing.field_82609_l[i];
                collision = temp;
            }
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collided, pos);
    }

    @Override
    protected void fillAdvanced(LittleBoxFace face) {
        List<VectorFan> axis = this.requestCache().get((EnumFacing)face.facing.func_176734_d()).axisStrips;
        if (axis != null && !axis.isEmpty()) {
            face.cut(axis);
        }
    }

    @Override
    @Nullable
    public LittleBoxFace generateFace(LittleGridContext context, EnumFacing facing) {
        VectorFanFaceCache faceCache = this.requestCache().get(facing);
        if (faceCache.isCompletelyFilled()) {
            return super.generateFace(context, facing);
        }
        if (faceCache.axisStrips.isEmpty()) {
            return null;
        }
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)facing.func_176740_k());
        return new LittleBoxFace(this, faceCache.axisStrips, faceCache.tiltedSorted(), context, facing, this.getMin(one), this.getMin(two), this.getMax(one), this.getMax(two), facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMax(facing.func_176740_k()) : this.getMin(facing.func_176740_k()));
    }

    @Override
    public void add(int x, int y, int z) {
        VectorFanCache temp;
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.add(x, y, z);
        }
    }

    @Override
    public void sub(int x, int y, int z) {
        VectorFanCache temp;
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
        if (this.cache != null && (temp = this.cache.get()) != null) {
            temp.sub(x, y, z);
        }
    }

    public static class CenterPoint {
        Vector3f vec = new Vector3f();
        int count = 0;

        public void add(Vector3f vec) {
            this.vec.add((Tuple3f)vec);
            ++this.count;
        }

        public void add(VectorFan fan) {
            for (int i = 0; i < fan.count(); ++i) {
                this.add(fan.get(i));
            }
        }

        public Vector3f getCenter() {
            float multiplier = 1.0f / (float)this.count;
            Vector3f result = new Vector3f();
            result.scale(multiplier, (Tuple3f)this.vec);
            return result;
        }

        public CenterPoint copy() {
            CenterPoint point = new CenterPoint();
            point.vec = new Vector3f(this.vec);
            point.count = this.count;
            return point;
        }
    }

    public static class VectorFanFaceCache
    implements Iterable<VectorFan> {
        public boolean convex = true;
        public VectorFan tiltedStrip1;
        public VectorFan tiltedStrip2;
        public boolean completedFilled = true;
        protected Object stripsSorted;
        public List<VectorFan> axisStrips = new ArrayList<VectorFan>();

        public boolean isInvalid() {
            return this.tiltedStrip1 == null && this.tiltedStrip2 == null && this.axisStrips.isEmpty();
        }

        public boolean hasTiltedStripsRendering() {
            return this.stripsSorted != null;
        }

        public boolean hasSingleTiltedStripRendering() {
            return this.stripsSorted instanceof VectorFan;
        }

        public VectorFan getSingleTiltedStripRendering() {
            return (VectorFan)this.stripsSorted;
        }

        public void addTiltedStripRendering(VectorFan fan) {
            if (this.stripsSorted == null) {
                this.stripsSorted = fan;
                return;
            }
            if (this.stripsSorted instanceof VectorFan) {
                VectorFan other = (VectorFan)this.stripsSorted;
                this.stripsSorted = new ArrayList();
                ((ArrayList)this.stripsSorted).add(other);
            }
            ((ArrayList)this.stripsSorted).add(fan);
        }

        public void collectAllTiltedStripsRendering(List<VectorFan> fans) {
            if (this.hasSingleTiltedStripRendering()) {
                fans.add((VectorFan)this.stripsSorted);
            } else {
                fans.addAll((Collection)this.stripsSorted);
            }
        }

        public void sortTiltedStrips(VectorFanCache cache, NormalPlane plane1, NormalPlane plane2) {
            if (this.tiltedStrip1 != null) {
                this.sortTiltedStrip(this.tiltedStrip1, cache, plane1);
            }
            if (this.tiltedStrip2 != null) {
                this.sortTiltedStrip(this.tiltedStrip2, cache, plane2);
            }
        }

        private void sortTiltedStrip(VectorFan fan, VectorFanCache cache, NormalPlane plane) {
            cache.faces[VectorFanFaceCache.nearest(plane.normal).ordinal()].addTiltedStripRendering(fan);
        }

        public static Vector3f createNormal(VectorFan fan) {
            Vector3f a = new Vector3f(fan.get(1));
            a.sub((Tuple3f)fan.get(0));
            Vector3f b = new Vector3f(fan.get(2));
            b.sub((Tuple3f)fan.get(0));
            Vector3f normal = new Vector3f();
            normal.cross(a, b);
            return normal;
        }

        public static EnumFacing nearest(Vector3f vec) {
            return VectorFanFaceCache.nearest(vec.x, vec.y, vec.z);
        }

        public static EnumFacing nearest(float x, float y, float z) {
            if (x == 0.0f && y == 0.0f && z == 0.0f) {
                return null;
            }
            EnumFacing facing = null;
            float distance = Float.MIN_VALUE;
            for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                EnumFacing f = EnumFacing.field_82609_l[i];
                float newDistance = x * (float)f.func_176730_m().func_177958_n() + y * (float)f.func_176730_m().func_177956_o() + z * (float)f.func_176730_m().func_177952_p();
                if (!(newDistance > distance)) continue;
                distance = newDistance;
                facing = f;
            }
            return facing;
        }

        public boolean isCompletelyFilled() {
            return this.completedFilled && !this.hasTiltedStrip();
        }

        public boolean hasTiltedStrip() {
            return this.tiltedStrip1 != null || this.tiltedStrip2 != null;
        }

        public boolean hasAxisStrip() {
            return !this.axisStrips.isEmpty();
        }

        public void cutAxisStrip(EnumFacing facing, NormalPlane plane, NormalPlane plane2) {
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            boolean inverse = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            ArrayList<VectorFan> newAxisStrips = new ArrayList<VectorFan>();
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                VectorFan strip = this.axisStrips.get(i).cut(plane);
                VectorFan strip2 = this.axisStrips.get(i).cut(plane2);
                if (strip != null && strip2 != null && strip.intersect2d(strip2, one, two, inverse)) {
                    List fans = strip.cut2d(strip2, one, two, inverse, false);
                    newAxisStrips.add(strip2);
                    newAxisStrips.addAll(fans);
                    continue;
                }
                if (strip != null) {
                    newAxisStrips.add(strip);
                }
                if (strip2 == null) continue;
                newAxisStrips.add(strip2);
            }
            if (this.completedFilled) {
                this.completedFilled = newAxisStrips.size() == 1 && this.axisStrips.size() == 1 ? ((VectorFan)newAxisStrips.get(0)).equals((Object)this.axisStrips.get(0)) : false;
            }
            this.axisStrips = newAxisStrips;
        }

        public void cutAxisStrip(NormalPlane plane) {
            int i = 0;
            VectorFan before = null;
            if (this.completedFilled && this.axisStrips.size() == 1) {
                before = this.axisStrips.get(0).copy();
            }
            while (i < this.axisStrips.size()) {
                VectorFan strip = this.axisStrips.get(i).cut(plane);
                if (strip == null) {
                    this.axisStrips.remove(i);
                    continue;
                }
                this.axisStrips.set(i, strip);
                ++i;
            }
            if (this.completedFilled) {
                this.completedFilled = this.axisStrips.size() == 1 ? before.equals((Object)this.axisStrips.get(0)) : false;
            }
        }

        public boolean equalAxisStrip(VectorFanFaceCache cache, EnumFacing.Axis toIgnore) {
            if (this.axisStrips.size() != cache.axisStrips.size() || this.axisStrips.size() != 1) {
                return false;
            }
            return this.axisStrips.get(0).equalsIgnoreOrder(cache.axisStrips.get(0), toIgnore);
        }

        public void add(float x, float y, float z) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.move(x, y, z);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.move(x, y, z);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).move(x, y, z);
            }
        }

        public void sub(float x, float y, float z) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.move(-x, -y, -z);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.move(-x, -y, -z);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).move(-x, -y, -z);
            }
        }

        public void scale(float ratio) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.scale(ratio);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.scale(ratio);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).scale(ratio);
            }
        }

        public void divide(float ratio) {
            if (this.tiltedStrip1 != null) {
                this.tiltedStrip1.divide(ratio);
            }
            if (this.tiltedStrip2 != null) {
                this.tiltedStrip2.divide(ratio);
            }
            for (int i = 0; i < this.axisStrips.size(); ++i) {
                this.axisStrips.get(i).divide(ratio);
            }
        }

        public boolean intersects(NormalPlane plane1, NormalPlane plane2) {
            for (VectorFan fan : this) {
                if (!fan.intersects(plane1, plane2)) continue;
                return true;
            }
            return false;
        }

        public boolean isInside(List<List<NormalPlane>> shapes, List<CenterPoint> centers) {
            if (!this.convex) {
                int sizeBefore = centers.size();
                for (int i = 0; i < sizeBefore; ++i) {
                    CenterPoint first = centers.get(i);
                    CenterPoint second = first.copy();
                    if (this.tiltedStrip1 != null) {
                        first.add(this.tiltedStrip1);
                    }
                    if (this.tiltedStrip2 != null) {
                        second.add(this.tiltedStrip2);
                    }
                    centers.add(second);
                }
            }
            if (this.hasAxisStrip()) {
                for (int i = 0; i < centers.size(); ++i) {
                    for (int j = 0; j < this.axisStrips.size(); ++j) {
                        centers.get(i).add(this.axisStrips.get(j));
                    }
                }
            }
            for (VectorFan fan : this) {
                if (!fan.isInside(shapes)) continue;
                return true;
            }
            return false;
        }

        public Iterable<VectorFan> tiltedSorted() {
            if (this.stripsSorted == null) {
                return null;
            }
            if (this.hasSingleTiltedStripRendering()) {
                return new SingletonList((Object)((VectorFan)this.stripsSorted));
            }
            return (Iterable)this.stripsSorted;
        }

        public Iterable<VectorFan> tilted() {
            if (this.tiltedStrip1 == null && this.tiltedStrip2 == null) {
                return Collections.EMPTY_LIST;
            }
            return new Iterable<VectorFan>(){

                @Override
                public Iterator<VectorFan> iterator() {
                    return new Iterator<VectorFan>(){
                        int additionalCount;
                        int index;
                        {
                            this.additionalCount = (tiltedStrip1 != null ? 1 : 0) + (tiltedStrip2 != null ? 1 : 0);
                            this.index = 0;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < this.additionalCount;
                        }

                        @Override
                        public VectorFan next() {
                            VectorFan result;
                            int secondIndex = this.index;
                            if (secondIndex < this.additionalCount) {
                                result = secondIndex == 0 ? (tiltedStrip1 != null ? tiltedStrip1 : tiltedStrip2) : tiltedStrip2;
                            } else {
                                throw new RuntimeException("Missing next element in iterator");
                            }
                            ++this.index;
                            return result;
                        }
                    };
                }
            };
        }

        @Override
        public Iterator<VectorFan> iterator() {
            return new Iterator<VectorFan>(){
                int additionalCount;
                int index;
                {
                    this.additionalCount = (tiltedStrip1 != null ? 1 : 0) + (tiltedStrip2 != null ? 1 : 0);
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < axisStrips.size() + this.additionalCount;
                }

                @Override
                public VectorFan next() {
                    VectorFan result;
                    if (this.index < axisStrips.size()) {
                        result = axisStrips.get(this.index);
                    } else {
                        int secondIndex = this.index - axisStrips.size();
                        if (secondIndex < this.additionalCount) {
                            result = secondIndex == 0 ? (tiltedStrip1 != null ? tiltedStrip1 : tiltedStrip2) : tiltedStrip2;
                        } else {
                            throw new RuntimeException("Missing next element in iterator");
                        }
                    }
                    ++this.index;
                    return result;
                }
            };
        }
    }

    public class VectorFanCache {
        VectorFanFaceCache[] faces = new VectorFanFaceCache[6];

        public VectorFanFaceCache get(EnumFacing facing) {
            return this.faces[facing.ordinal()];
        }

        public void add(float x, float y, float z) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].add(x, y, z);
            }
        }

        public void sub(float x, float y, float z) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].sub(x, y, z);
            }
        }

        public void scale(float ratio) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].scale(ratio);
            }
        }

        public boolean isCompletelyFilled() {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i].isCompletelyFilled()) continue;
                return false;
            }
            return true;
        }

        public boolean isInvalid() {
            int count = 0;
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i].isInvalid()) continue;
                ++count;
            }
            return count < 3;
        }

        protected void divide(int ratio) {
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i].divide(ratio);
            }
        }

        protected boolean intersects(NormalPlane plane1, NormalPlane plane2) {
            for (int i = 0; i < this.faces.length; ++i) {
                if (!this.faces[i].intersects(plane1, plane2)) continue;
                return true;
            }
            return false;
        }

        public boolean isInside(List<List<NormalPlane>> shapes) {
            int i;
            ArrayList<CenterPoint> centers = new ArrayList<CenterPoint>();
            centers.add(new CenterPoint());
            for (i = 0; i < this.faces.length; ++i) {
                if (!this.faces[i].isInside(shapes, centers)) continue;
                return true;
            }
            for (i = 0; i < centers.size(); ++i) {
                Vector3f center = ((CenterPoint)centers.get(i)).getCenter();
                for (int j = 0; j < shapes.size(); ++j) {
                    if (!this.isInside(shapes.get(j), center)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isInside(List<NormalPlane> shape, Vector3f vec) {
            for (int i = 0; i < shape.size(); ++i) {
                if (BooleanUtils.isFalse((Boolean)shape.get(i).isInFront(vec, 1.0E-4f))) continue;
                return false;
            }
            return true;
        }

        protected void setBounds(int oldMinX, int oldMinY, int oldMinZ, int oldMaxX, int oldMaxY, int oldMaxZ) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (int i = 0; i < this.faces.length; ++i) {
                for (VectorFan fan : this.faces[i]) {
                    for (int j = 0; j < fan.count(); ++j) {
                        Vector3f vec = fan.get(j);
                        minX = Math.min(minX, (int)Math.floor(vec.x));
                        minY = Math.min(minY, (int)Math.floor(vec.y));
                        minZ = Math.min(minZ, (int)Math.floor(vec.z));
                        maxX = Math.max(maxX, (int)Math.ceil(vec.x));
                        maxY = Math.max(maxY, (int)Math.ceil(vec.y));
                        maxZ = Math.max(maxZ, (int)Math.ceil(vec.z));
                    }
                }
            }
            minX = Math.max(minX, oldMinX);
            minY = Math.max(minY, oldMinY);
            minZ = Math.max(minZ, oldMinZ);
            maxX = Math.min(maxX, oldMaxX);
            maxY = Math.min(maxY, oldMaxY);
            maxZ = Math.min(maxZ, oldMaxZ);
            LittleTransformableBox.this.set(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public class CornerCache {
        public final boolean relative;
        public LittleVec[] corners = new LittleVec[BoxCorner.values().length];

        public CornerCache(boolean relative) {
            this.relative = relative;
        }

        public LittleTransformableBox getBox() {
            return LittleTransformableBox.this;
        }

        public LittleVec getOrCreate(BoxCorner corner) {
            LittleVec vec = this.corners[corner.ordinal()];
            if (vec == null) {
                vec = this.relative ? new LittleVec(0, 0, 0) : LittleTransformableBox.this.get(corner);
                this.corners[corner.ordinal()] = vec;
            }
            return vec;
        }

        public void setAbsolute(BoxCorner corner, LittleVec vec) {
            this.corners[corner.ordinal()] = vec;
            if (this.relative) {
                vec.x -= LittleTransformableBox.this.get(corner, EnumFacing.Axis.X);
                vec.y -= LittleTransformableBox.this.get(corner, EnumFacing.Axis.Y);
                vec.z -= LittleTransformableBox.this.get(corner, EnumFacing.Axis.Z);
            }
        }

        public void setAbsolute(BoxCorner corner, EnumFacing.Axis axis, int value) {
            if (this.relative) {
                this.getOrCreate(corner).set(axis, value - LittleTransformableBox.this.get(corner, axis));
            } else {
                this.getOrCreate(corner).set(axis, value);
            }
        }

        public void setRelative(BoxCorner corner, LittleVec vec) {
            this.corners[corner.ordinal()] = vec;
            if (!this.relative) {
                vec.x += LittleTransformableBox.this.get(corner, EnumFacing.Axis.X);
                vec.y += LittleTransformableBox.this.get(corner, EnumFacing.Axis.Y);
                vec.z += LittleTransformableBox.this.get(corner, EnumFacing.Axis.Z);
            }
        }

        public void setRelative(BoxCorner corner, EnumFacing.Axis axis, int value) {
            if (this.relative) {
                this.getOrCreate(corner).set(axis, value);
            } else {
                this.getOrCreate(corner).set(axis, value + LittleTransformableBox.this.get(corner, axis));
            }
        }

        public int[] getData() {
            int indicator = Integer.MIN_VALUE | 0xBF000000 & this.getBox().getIndicator();
            ArrayList<Integer> data = new ArrayList<Integer>();
            for (int i = 0; i < this.corners.length; ++i) {
                LittleVec vec = this.corners[i];
                if (vec == null) continue;
                int index = i * 3;
                if (this.relative) {
                    if (vec.x != 0) {
                        indicator = IntegerUtils.set((int)indicator, (int)index);
                        data.add(vec.x);
                    }
                    if (vec.y != 0) {
                        indicator = IntegerUtils.set((int)indicator, (int)(index + 1));
                        data.add(vec.y);
                    }
                    if (vec.z == 0) continue;
                    indicator = IntegerUtils.set((int)indicator, (int)(index + 2));
                    data.add(vec.z);
                    continue;
                }
                BoxCorner corner = BoxCorner.values()[i];
                if (vec.x != LittleTransformableBox.this.get(corner, EnumFacing.Axis.X)) {
                    indicator = IntegerUtils.set((int)indicator, (int)index);
                    data.add(vec.x - LittleTransformableBox.this.get(corner, EnumFacing.Axis.X));
                }
                if (vec.y != LittleTransformableBox.this.get(corner, EnumFacing.Axis.Y)) {
                    indicator = IntegerUtils.set((int)indicator, (int)(index + 1));
                    data.add(vec.y - LittleTransformableBox.this.get(corner, EnumFacing.Axis.Y));
                }
                if (vec.z == LittleTransformableBox.this.get(corner, EnumFacing.Axis.Z)) continue;
                indicator = IntegerUtils.set((int)indicator, (int)(index + 2));
                data.add(vec.z - LittleTransformableBox.this.get(corner, EnumFacing.Axis.Z));
            }
            int[] array = new int[1 + (int)Math.ceil((double)data.size() / 2.0)];
            array[0] = indicator;
            for (int i = 0; i < array.length - 1; ++i) {
                int second = i * 2 + 1 < data.size() ? (Integer)data.get(i * 2 + 1) : 0;
                array[i + 1] = (short)((Integer)data.get(i * 2)).intValue() << 16 | (short)second & 0xFFFF;
            }
            return array;
        }
    }

    class TransformablePoint {
        int progressIndex;
        int index;
        EnumFacing.Axis axis;
        BoxCorner corner;

        TransformablePoint() {
        }

        public TransformablePoint set(int progressIndex, int index, EnumFacing.Axis axis, BoxCorner corner) {
            this.progressIndex = progressIndex;
            this.index = index;
            this.axis = axis;
            this.corner = corner;
            return this;
        }

        public int getProgressIndex() {
            return this.progressIndex;
        }

        public int getAbsolute() {
            return this.getRelative() + LittleTransformableBox.this.get(this.corner, this.axis);
        }

        public void setAbsolute(int value) {
            this.setRelative((short)(value - LittleTransformableBox.this.get(this.corner, this.axis)));
        }

        public short getRelative() {
            return LittleTransformableBox.this.getData(this.index);
        }

        public void setRelative(short value) {
            LittleTransformableBox.this.setData(this.index, value);
        }

        public String toString() {
            return this.corner + "," + this.axis + "," + this.getRelative();
        }
    }

    class TransformableVec {
        int index;
        BoxCorner corner;
        int x = 0;
        int y = 0;
        int z = 0;

        public int getAbsolute(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return this.getAbsoluteX();
                }
                case Y: {
                    return this.getAbsoluteY();
                }
                case Z: {
                    return this.getAbsoluteZ();
                }
            }
            return 0;
        }

        public int getAbsoluteX() {
            return LittleTransformableBox.this.get(this.corner, EnumFacing.Axis.X) + this.x;
        }

        public int getAbsoluteY() {
            return LittleTransformableBox.this.get(this.corner, EnumFacing.Axis.Y) + this.y;
        }

        public int getAbsoluteZ() {
            return LittleTransformableBox.this.get(this.corner, EnumFacing.Axis.Z) + this.z;
        }

        public int getRelative(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return this.getRelativeX();
                }
                case Y: {
                    return this.getRelativeY();
                }
                case Z: {
                    return this.getRelativeZ();
                }
            }
            return 0;
        }

        public BoxCorner getCorner() {
            return this.corner;
        }

        public int getRelativeX() {
            return this.x;
        }

        public int getRelativeY() {
            return this.y;
        }

        public int getRelativeZ() {
            return this.z;
        }

        public TransformableVec set(int index, BoxCorner corner, int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.index = index;
            this.corner = corner;
            return this;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "," + this.z + "]";
        }
    }
}

