/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.parent;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.compression.LittleNBTCompressionTools;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ParentTileList
extends CopyOnWriteArrayList<LittleTile>
implements IParentTileList {
    private int collisionChecks = 0;

    protected boolean checkCollision() {
        return this.collisionChecks > 0;
    }

    @Override
    public boolean add(LittleTile e) {
        super.add(e);
        this.added(e);
        return true;
    }

    @Override
    public void add(int index, LittleTile element) {
        super.add(index, element);
        this.added(element);
    }

    @Override
    public boolean addAll(Collection<? extends LittleTile> c) {
        if (super.addAll(c)) {
            for (LittleTile littleTile : c) {
                this.added(littleTile);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends LittleTile> c) {
        if (super.addAll(index, c)) {
            for (LittleTile littleTile : c) {
                this.added(littleTile);
            }
            return true;
        }
        return false;
    }

    private void added(LittleTile tile) {
        if (tile.shouldCheckForCollision()) {
            ++this.collisionChecks;
        }
    }

    @Override
    public LittleTile remove(int index) {
        LittleTile tile = (LittleTile)super.remove(index);
        if (tile != null) {
            this.removed(tile);
        }
        return tile;
    }

    private void removed(LittleTile tile) {
        if (tile.shouldCheckForCollision()) {
            --this.collisionChecks;
        }
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.removed((LittleTile)o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super LittleTile> filter) {
        if (super.removeIf(filter)) {
            this.collisionChecks = 0;
            for (LittleTile tile : this) {
                this.added(tile);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        super.clear();
        this.collisionChecks = 0;
    }

    @Override
    public LittleTile set(int index, LittleTile element) {
        throw new UnsupportedOperationException();
    }

    public void read(NBTTagCompound nbt) {
        this.clear();
        this.addAll((Collection<? extends LittleTile>)LittleNBTCompressionTools.readTiles(nbt.func_150295_c("tiles", 10)));
        this.readExtra(nbt);
    }

    protected abstract void readExtra(NBTTagCompound var1);

    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("tiles", (NBTBase)LittleNBTCompressionTools.writeTiles(this));
        this.writeExtra(nbt);
        return nbt;
    }

    protected abstract void writeExtra(NBTTagCompound var1);

    @Override
    public LittleTile first() {
        return this.isEmpty() ? null : (LittleTile)super.get(0);
    }

    @Override
    public LittleTile last() {
        return this.isEmpty() ? null : (LittleTile)super.get(this.size() - 1);
    }

    @Override
    public abstract TileEntityLittleTiles getTe();

    @Override
    public abstract boolean isStructure();

    @Override
    public boolean isStructureChildSafe(LittleStructure structure) {
        try {
            return this.isStructureChild(structure);
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return false;
        }
    }

    @Override
    public abstract boolean isStructureChild(LittleStructure var1) throws CorruptedConnectionException, NotYetConnectedException;

    @Override
    public abstract boolean isMain();

    @Override
    public abstract LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException;

    @Override
    public abstract int getAttribute();

    @Override
    public abstract boolean isClient();

    public void unload() {
    }
}

