/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.world;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.client.event.HoldLeftClick;
import com.creativemd.littletiles.client.event.LeftClick;
import com.creativemd.littletiles.client.event.WheelClick;
import com.creativemd.littletiles.client.world.LittleAnimationHandlerClient;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.packet.LittleAnimationDataPacket;
import com.creativemd.littletiles.common.world.LittleAnimationHandler;
import com.creativemd.littletiles.server.world.LittleAnimationHandlerServer;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldAnimationHandler {
    @SideOnly(value=Side.CLIENT)
    public static LittleAnimationHandler client;
    public static LinkedHashMap<World, LittleAnimationHandler> worlds;
    private static Field wasPushedByDoor;

    @SideOnly(value=Side.CLIENT)
    private static void createClientHandler() {
        client = new LittleAnimationHandlerClient((World)Minecraft.func_71410_x().field_71441_e);
    }

    @SideOnly(value=Side.CLIENT)
    public static LittleAnimationHandler getHandlerClient() {
        if (client == null) {
            WorldAnimationHandler.createClientHandler();
        }
        return client;
    }

    public static LittleAnimationHandler getHandler(World world) {
        LittleAnimationHandler handler;
        if (world.field_72995_K) {
            return WorldAnimationHandler.getHandlerClient();
        }
        if (world instanceof IOrientatedWorld) {
            world = ((IOrientatedWorld)world).getRealWorld();
        }
        if ((handler = worlds.get(world)) == null) {
            handler = new LittleAnimationHandlerServer(world);
            worlds.put(world, handler);
        }
        return handler;
    }

    public static EntityAnimation findAnimation(boolean client, UUID uuid) {
        if (client) {
            return WorldAnimationHandler.findAnimationClient(uuid);
        }
        return WorldAnimationHandler.findAnimationServer(uuid);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityAnimation findAnimationClient(UUID uuid) {
        return WorldAnimationHandler.getHandlerClient().findAnimation(uuid);
    }

    public static EntityAnimation findAnimationServer(UUID uuid) {
        for (LittleAnimationHandler handler : worlds.values()) {
            EntityAnimation animation = handler.findAnimation(uuid);
            if (animation == null) continue;
            return animation;
        }
        return null;
    }

    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            if (client != null) {
                client.chunkUnload(event);
            }
        } else {
            LittleAnimationHandler handler = worlds.get(event.getWorld());
            if (handler != null) {
                handler.chunkUnload(event);
            }
        }
    }

    @SubscribeEvent
    public static void worldCollision(GetCollisionBoxesEvent event) {
        if (event.getWorld().field_72995_K) {
            if (client != null) {
                client.worldCollision(event);
            }
        } else {
            LittleAnimationHandler handler = worlds.get(event.getWorld());
            if (handler != null) {
                handler.worldCollision(event);
            }
        }
    }

    @SubscribeEvent
    public static void unloadWorld(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            if (client != null) {
                client.worldUnload(event);
            }
            client = null;
        } else {
            LittleAnimationHandler handler = worlds.get(event.getWorld());
            if (handler != null) {
                handler.worldUnload(event);
            }
            worlds.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void trackEntity(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityAnimation) {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleAnimationDataPacket((EntityAnimation)event.getTarget()), (EntityPlayerMP)((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        LittleAnimationHandler handler;
        if (!event.world.field_72995_K && (handler = worlds.get(event.world)) != null) {
            ((LittleAnimationHandlerServer)handler).tick(event);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void rightClick(PlayerInteractEvent event) {
        LittleAnimationHandler handler;
        if (event.getWorld().field_72995_K && client != null && event.getHand() == EnumHand.MAIN_HAND) {
            ((LittleAnimationHandlerClient)client).rightClick(event);
        } else if (event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().field_72995_K && (handler = worlds.get(event.getWorld())) != null) {
            ((LittleAnimationHandlerServer)handler).rightClick(event);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void mouseWheel(WheelClick event) {
        if (client != null) {
            ((LittleAnimationHandlerClient)client).mouseWheel(event);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void holdClick(HoldLeftClick event) {
        if (client != null) {
            ((LittleAnimationHandlerClient)client).holdClick(event);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void leftClick(LeftClick event) {
        if (client != null) {
            ((LittleAnimationHandlerClient)client).leftClick(event);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void tickClient(TickEvent.ClientTickEvent event) {
        if (client != null) {
            ((LittleAnimationHandlerClient)client).tickClient(event);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderLast(RenderWorldLastEvent event) {
        if (client != null) {
            ((LittleAnimationHandlerClient)client).renderLast(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public static void drawHighlight(DrawBlockHighlightEvent event) {
        if (client != null) {
            ((LittleAnimationHandlerClient)client).drawHighlight(event);
        }
    }

    public static void setPushedByDoor(EntityPlayerMP player) {
        try {
            wasPushedByDoor.setInt(player, 10);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkIfEmpty(List<AxisAlignedBB> boxes, EntityPlayerMP player) {
        try {
            if (wasPushedByDoor.getInt(player) > 0) {
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (boxes.isEmpty()) {
            return true;
        }
        for (int i = 0; i < boxes.size(); ++i) {
            if (boxes.get(i) instanceof CreativeAxisAlignedBB) continue;
            return false;
        }
        return true;
    }

    static {
        worlds = new LinkedHashMap();
        wasPushedByDoor = ReflectionHelper.findField(EntityPlayerMP.class, (String[])new String[]{"wasPushedByDoor"});
    }
}

