/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.server.world;

import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.LittleAnimationHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LittleAnimationHandlerServer
extends LittleAnimationHandler {
    private Set<EntityPlayer> queued = new HashSet<EntityPlayer>();

    public LittleAnimationHandlerServer(World world) {
        super(world);
    }

    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.world == event.world) {
            for (EntityAnimation door : this.openDoors) {
                if (door.field_70170_p != this.world || door.field_70170_p instanceof CreativeWorld) continue;
                door.onUpdateForReal();
            }
            this.openDoors.removeIf(x -> {
                if (x.field_70128_L) {
                    x.markRemoved();
                    return true;
                }
                return false;
            });
        }
    }

    public void queueClickThrough(EntityPlayer player) {
        this.queued.add(player);
    }

    public void rightClick(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickBlock && this.queued.contains(event.getEntityPlayer())) {
            event.setCanceled(true);
            this.queued.remove(event.getEntityPlayer());
        }
    }
}

