/*
 * Decompiled with CFR 0.152.
 */
package dan.morefurnaces;

import com.google.common.collect.Maps;
import dan.morefurnaces.FurnaceType;
import java.io.File;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final Map<FurnaceType, Integer> furanceSpeeds = Maps.newHashMap();
    private static final Map<FurnaceType, Float> consumptionRates = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        Configuration config = new Configuration(configFile);
        try {
            config.load();
            for (FurnaceType type : FurnaceType.values()) {
                int speed = config.get("General", type.name().toLowerCase() + "FurnaceSpeed", type.speed).getInt(type.speed);
                float consumptionRate = (float)config.get("General", type.name().toLowerCase() + "FurnaceConsumptionRate", (double)type.consumptionRate).getDouble((double)type.consumptionRate);
                furanceSpeeds.put(type, speed);
                consumptionRates.put(type, Float.valueOf(consumptionRate));
            }
        }
        finally {
            config.save();
        }
    }

    public static int getFurnaceSpeed(FurnaceType type) {
        return furanceSpeeds.getOrDefault((Object)type, type.speed);
    }

    public static float getConsumptionRate(FurnaceType type) {
        return consumptionRates.getOrDefault((Object)type, Float.valueOf(type.consumptionRate)).floatValue();
    }
}

