/*
 * Decompiled with CFR 0.152.
 */
package dan.morefurnaces.inventory;

import dan.morefurnaces.inventory.ItemHandlerFurnace;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.ArrayUtils;

public class ItemHandlerMoveStacks
extends RangedWrapper {
    private final int[] destSlots;
    private final ItemHandlerFurnace furnace;

    public ItemHandlerMoveStacks(ItemHandlerFurnace furnace, int minSlot, int maxSlotInclusive, int ... destSlots) {
        super((IItemHandlerModifiable)furnace, minSlot, maxSlotInclusive + 1);
        this.furnace = furnace;
        this.destSlots = destSlots;
    }

    public void moveStacks() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack src;
            if (ArrayUtils.contains((int[])this.destSlots, (int)i) || (src = this.getStackInSlot(i)).func_190926_b()) continue;
            ItemStack remainder = this.moveStackToFirstDest(src);
            this.setStackInSlot(i, remainder);
        }
    }

    private ItemStack moveStackToFirstDest(ItemStack stack) {
        this.furnace.slotChecksEnabled = false;
        ItemStack remainder = stack;
        for (int destSlot : this.destSlots) {
            remainder = this.insertItem(destSlot, remainder, false);
        }
        this.furnace.slotChecksEnabled = true;
        return remainder;
    }
}

