/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs;

import com.nomiceu.nomilabs.util.LabsNames;
import gregtech.api.gui.resources.TextureArea;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;

public class LabsTextures {
    public static int P2P_SIZE = 32;
    public static String P2P_SORTING_LOC = "textures/gui/advanced_memory_card/sorting.png";
    public static int P2P_SORTING_AMT = 5;
    public static String P2P_CUSTOM_LOC = "textures/gui/advanced_memory_card/custom_modes.png";
    public static int P2P_CUSTOM_AMT = 2;
    public static OrientedOverlayRenderer GROWTH_CHAMBER_OVERLAY;
    public static SimpleOverlayRenderer MICROVERSE_CASING;
    public static TextureArea PROGRESS_BAR_ROCKET;
    public static TextureArea[] P2P_SORTING_ICONS;
    public static TextureArea[] P2P_CUSTOM_MODES;
    public static TextureArea P2P_INPUT_ICON;
    public static TextureArea P2P_OUTPUT_ICON;

    public static void preInit() {
        GROWTH_CHAMBER_OVERLAY = new OrientedOverlayRenderer("nomilabs:multiblock/growth_chamber");
        MICROVERSE_CASING = new SimpleOverlayRenderer("nomilabs:microverse_casing");
        PROGRESS_BAR_ROCKET = LabsTextures.labsFullImage("textures/gui/progress_bar/progress_bar_rocket.png");
        P2P_SORTING_ICONS = LabsTextures.labsAreasImageHorizontal(P2P_SORTING_LOC, P2P_SIZE, P2P_SIZE, P2P_SORTING_AMT);
        P2P_CUSTOM_MODES = LabsTextures.labsAreasImageHorizontal(P2P_CUSTOM_LOC, P2P_SIZE, P2P_SIZE, P2P_CUSTOM_AMT);
        P2P_INPUT_ICON = LabsTextures.labsFullImage("textures/gui/advanced_memory_card/input.png");
        P2P_OUTPUT_ICON = LabsTextures.labsFullImage("textures/gui/advanced_memory_card/output.png");
    }

    public static TextureArea[] labsAreasImageHorizontal(String imageLoc, int iconSizeX, int iconSizeY, int amt) {
        TextureArea[] areas = new TextureArea[amt];
        for (int i = 0; i < amt; ++i) {
            areas[i] = LabsTextures.labsAreaImage(imageLoc, iconSizeX * amt, iconSizeY, i * iconSizeX, 0, iconSizeX, iconSizeY);
        }
        return areas;
    }

    public static TextureArea labsFullImage(String imageLocation) {
        return new TextureArea(LabsNames.makeLabsName(imageLocation), 0.0, 0.0, 1.0, 1.0);
    }

    public static TextureArea labsAreaImage(String imageLocation, int imageSizeX, int imageSizeY, int u, int v, int width, int height) {
        return new TextureArea(LabsNames.makeLabsName(imageLocation), (double)u / ((double)imageSizeX * 1.0), (double)v / ((double)imageSizeY * 1.0), (double)width / ((double)imageSizeX * 1.0), (double)height / ((double)imageSizeY * 1.0));
    }
}

