/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.block;

import com.nomiceu.nomilabs.integration.top.TOPInfoProvider;
import com.nomiceu.nomilabs.util.LabsTranslate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBase
extends Block
implements TOPInfoProvider {
    @Nullable
    private final LabsTranslate.Translatable[] description;

    public BlockBase(ResourceLocation rl, CreativeTabs tab, Material material, SoundType sound) {
        this(rl, tab, material, sound, new LabsTranslate.Translatable[]{null});
    }

    public BlockBase(ResourceLocation rl, CreativeTabs tab, Material material, SoundType sound, LabsTranslate.Translatable ... description) {
        this(rl, tab, material, sound, "pickaxe", 1, description);
    }

    public BlockBase(ResourceLocation rl, CreativeTabs tab, Material material, SoundType sound, String tool, int harvestLevel, LabsTranslate.Translatable ... description) {
        super(material);
        this.setRegistryName(rl);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(sound);
        this.func_149647_a(tab);
        this.setHarvestLevel(tool, harvestLevel);
        this.description = description;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        if (this.description == null) {
            return;
        }
        Arrays.stream(this.description).filter(Objects::nonNull).map(LabsTranslate.Translatable::translate).forEach(tooltip::add);
    }

    @Override
    @Nullable
    public List<String> getTOPMessage(IBlockState state) {
        if (this.description == null) {
            return null;
        }
        return Arrays.stream(this.description).filter(Objects::nonNull).map(LabsTranslate.Translatable::topVersion).collect(Collectors.toList());
    }
}

