/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.block.registry;

import com.nomiceu.nomilabs.block.BlockBase;
import com.nomiceu.nomilabs.block.BlockDust;
import com.nomiceu.nomilabs.block.BlockExcitationCoil;
import com.nomiceu.nomilabs.creativetab.registry.LabsCreativeTabs;
import com.nomiceu.nomilabs.item.ItemBlockBase;
import com.nomiceu.nomilabs.item.ItemExcitationCoil;
import com.nomiceu.nomilabs.item.registry.LabsItems;
import com.nomiceu.nomilabs.util.LabsNames;
import com.nomiceu.nomilabs.util.LabsTranslate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class LabsBlocks {
    private static final String nullTranslationKey = "tile.null";
    private static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final Map<Block, Item> ITEMS = new HashMap<Block, Item>();
    public static BlockBase DENSE_MAGMA;
    public static BlockBase DENSE_OIL_SHALE;
    public static BlockBase ULTIMATE_POWER_STORAGE;
    public static BlockBase ULTIMATE_GENERATOR;
    public static BlockBase MICROVERSE_CASING;
    public static BlockExcitationCoil EXCITATION_COIL;
    public static BlockDust DUST;

    public static void preInit() {
        DENSE_MAGMA = LabsBlocks.createBlock(new BlockBase(LabsNames.makeLabsName("densemagma"), LabsCreativeTabs.TAB_NOMI_LABS, Material.field_151576_e, SoundType.field_185851_d), (IRarity)EnumRarity.COMMON, 64);
        DENSE_OIL_SHALE = LabsBlocks.createBlock(new BlockBase(LabsNames.makeLabsName("denseoilshale"), LabsCreativeTabs.TAB_NOMI_LABS, Material.field_151576_e, SoundType.field_185851_d), (IRarity)EnumRarity.COMMON, 64);
        ULTIMATE_POWER_STORAGE = LabsBlocks.createBlock(new BlockBase(LabsNames.makeLabsName("ultimate_power_storage"), LabsCreativeTabs.TAB_NOMI_LABS, Material.field_151573_f, SoundType.field_185852_e, "pickaxe", 2, LabsTranslate.translatable("tooltip.nomilabs.general.crafting_component", new Object[0])), (IRarity)EnumRarity.EPIC, 1);
        ULTIMATE_GENERATOR = LabsBlocks.createBlock(new BlockBase(LabsNames.makeLabsName("ultimate_generator"), LabsCreativeTabs.TAB_NOMI_LABS, Material.field_151573_f, SoundType.field_185852_e, "pickaxe", 2, LabsTranslate.translatable("tooltip.nomilabs.general.crafting_component", new Object[0])), (IRarity)EnumRarity.EPIC, 1);
        MICROVERSE_CASING = LabsBlocks.createBlock(new BlockBase(LabsNames.makeLabsName("microverse_casing"), LabsCreativeTabs.TAB_NOMI_LABS, Material.field_151576_e, SoundType.field_185851_d, "wrench", 2, new LabsTranslate.Translatable[0]), (IRarity)EnumRarity.COMMON, 64);
        EXCITATION_COIL = LabsBlocks.createBlockWithItem(new BlockExcitationCoil(LabsNames.makeLabsName("excitationcoil"), LabsCreativeTabs.TAB_NOMI_LABS), ItemExcitationCoil::new);
        DUST = LabsBlocks.createBlock(new BlockDust(LabsNames.makeLabsName("block_dust"), LabsCreativeTabs.TAB_NOMI_LABS), (IRarity)EnumRarity.COMMON, 64);
    }

    public static void register(IForgeRegistry<Block> registry) {
        for (Block block : BLOCKS) {
            LabsBlocks.registerBlock(block, registry);
        }
    }

    public static <T extends Block> T createBlock(T block, @NotNull IRarity rarity, int stackSize) {
        return (T)LabsBlocks.createBlockWithItem(block, registeredBlock -> new ItemBlockBase((Block)registeredBlock, rarity, stackSize));
    }

    public static <T extends Block> T createBlockWithItem(T block, Function<T, ItemBlock> itemBlockSupplier) {
        return (T)LabsBlocks.createBlockWithRegisteredItem(block, registeredBlock -> LabsItems.createItem((ItemBlock)itemBlockSupplier.apply(block)));
    }

    public static <T extends Block> T createBlockWithRegisteredItem(T block, Function<T, ItemBlock> itemBlockSupplier) {
        BLOCKS.add(block);
        ITEMS.put(block, (Item)itemBlockSupplier.apply(block));
        return block;
    }

    public static <T extends Block> T createBlockWithoutItem(T block) {
        BLOCKS.add(block);
        return block;
    }

    private static void registerBlock(Block block, IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)block);
        if (block.func_149739_a().equals(nullTranslationKey)) {
            ResourceLocation rl = block.getRegistryName();
            assert (rl != null);
            block.func_149663_c(rl.func_110624_b() + "." + rl.func_110623_a());
        }
    }
}

