/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.command;

import com.cleanroommc.groovyscript.GroovyScript;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.sandbox.LoadStage;
import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.command.SimpleCommand;
import com.nomiceu.nomilabs.network.LabsFastReloadMessage;
import com.nomiceu.nomilabs.network.LabsLangReloadMessage;
import com.nomiceu.nomilabs.network.LabsNetworkHandler;
import com.nomiceu.nomilabs.network.LabsNoJeiReloadMessage;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.server.command.CommandTreeBase;
import org.jetbrains.annotations.NotNull;

public class LabsReloadCommand
extends CommandTreeBase {
    public LabsReloadCommand() {
        this.addSubcommand((ICommand)new SimpleCommand("lang", (server, sender, args) -> LabsReloadCommand.runReload(sender, server, new LabsLangReloadMessage()), new String[0]));
        this.addSubcommand((ICommand)new SimpleCommand("fast", (server, sender, args) -> LabsReloadCommand.runReload(sender, server, new LabsFastReloadMessage()), new String[0]));
        this.addSubcommand((ICommand)new SimpleCommand("noJei", (server, sender, args) -> LabsReloadCommand.runReload(sender, server, new LabsNoJeiReloadMessage()), new String[0]));
    }

    public static void runReload(ICommandSender sender, MinecraftServer server, IMessage reloadMsg) {
        if (!(sender instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (server.func_71262_S()) {
            player.func_145747_a((ITextComponent)new TextComponentString("Reloading in multiplayer is currently not allowed to avoid desync."));
            return;
        }
        GroovyLog.get().info((Object)"========== Reloading Groovy scripts ==========");
        long time = GroovyScript.runGroovyScriptsInLoader((LoadStage)LoadStage.POST_INIT);
        GroovyScript.postScriptRunResult((ICommandSender)player, (boolean)false, (boolean)true, (boolean)false, (long)time);
        LabsNetworkHandler.NETWORK_HANDLER.sendTo(reloadMsg, player);
    }

    @NotNull
    public String func_71517_b() {
        return "labsGsReload";
    }

    @NotNull
    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"lr", (Object)"labsReload");
    }

    @NotNull
    public String func_71518_a(@NotNull ICommandSender sender) {
        return "/lr <lang/fast/noJei>";
    }
}

