/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.core;

import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.core.SideSpecificRemover;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Opcodes;

public class LabsTransformer
implements IClassTransformer,
Opcodes {
    private static final Set<String> excludedTwoLongPackages;
    private static final Set<String> transformableClasses;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String internalName = transformedName.replace('.', '/');
        String[] parts = internalName.split("/");
        if (parts.length >= 2 && excludedTwoLongPackages.add(parts[0] + "/" + parts[1])) {
            return basicClass;
        }
        if (!transformableClasses.contains(internalName)) {
            return basicClass;
        }
        return SideSpecificRemover.handleTransform(internalName, basicClass);
    }

    static {
        String[] parts;
        String[] methodsRemove;
        String[] fieldsRemove;
        excludedTwoLongPackages = new HashSet<String>();
        excludedTwoLongPackages.add("net/minecraft");
        excludedTwoLongPackages.add("net/minecraftforge");
        transformableClasses = new HashSet<String>();
        if (FMLLaunchHandler.side() == Side.SERVER) {
            fieldsRemove = LabsConfig.advanced.clientSideFields;
            methodsRemove = LabsConfig.advanced.clientSideMethods;
        } else {
            fieldsRemove = LabsConfig.advanced.serverSideFields;
            methodsRemove = LabsConfig.advanced.serverSideMethods;
        }
        for (String field : fieldsRemove) {
            parts = field.split("@");
            if (parts.length != 2) {
                throw new IllegalStateException("Invalid Field Remove: " + field + "! Must have Two Parts, Seperated by '@', Got " + parts.length + "!");
            }
            transformableClasses.add(parts[0]);
        }
        for (String method : methodsRemove) {
            parts = method.split("@");
            if (parts.length != 3) {
                throw new IllegalStateException("Invalid Method Remove: " + method + "! Must have Three Parts, Seperated by '@', Got " + parts.length + "!");
            }
            transformableClasses.add(parts[0]);
        }
        LogManager.getLogger((String)"LabsASM").debug("Computed Transformable Classes: {}", transformableClasses);
    }
}

