/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class LambdaGatherer
extends MethodVisitor {
    private static final Handle META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
    private final List<Handle> dynamicLambdaHandles = new ArrayList<Handle>();

    public LambdaGatherer() {
        super(327680);
    }

    public void accept(MethodNode method) {
        for (AbstractInsnNode insnNode : method.instructions) {
            if (insnNode.getType() != 6) continue;
            insnNode.accept((MethodVisitor)this);
        }
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (META_FACTORY.equals((Object)bsm)) {
            Handle dynamicLambdaHandle = (Handle)bsmArgs[1];
            this.dynamicLambdaHandles.add(dynamicLambdaHandle);
        }
    }

    public List<Handle> getDynamicLambdaHandles() {
        return this.dynamicLambdaHandles;
    }

    public static void removeDynamicLambdaMethods(LambdaGatherer gatherer, ClassNode classNode) {
        List<Handle> dynamicLambdaHandles = gatherer.getDynamicLambdaHandles();
        while (!dynamicLambdaHandles.isEmpty()) {
            gatherer = new LambdaGatherer();
            Iterator methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                if ((method.access & 0x1000) == 0) continue;
                for (Handle dynamicLambdaHandle : dynamicLambdaHandles) {
                    if (!method.name.equals(dynamicLambdaHandle.getName()) || !method.desc.equals(dynamicLambdaHandle.getDesc())) continue;
                    LogManager.getLogger((String)"LabsASM").warn("Removing Method: {}.{}{}", (Object)classNode.name, (Object)method.name, (Object)method.desc);
                    methods.remove();
                    gatherer.accept(method);
                }
            }
            dynamicLambdaHandles = gatherer.getDynamicLambdaHandles();
        }
    }
}

