/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.core;

import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.core.LambdaGatherer;
import com.nomiceu.nomilabs.core.ObfMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class SideSpecificRemover {
    private static Map<String, Pair<List<ObfMapping>, List<ObfMapping>>> toRemove;

    private static void setupToRemove() {
        String[] parts;
        String[] methodsRemove;
        String[] fieldsRemove;
        if (toRemove != null) {
            return;
        }
        toRemove = new HashMap<String, Pair<List<ObfMapping>, List<ObfMapping>>>();
        if (FMLLaunchHandler.side() == Side.SERVER) {
            fieldsRemove = LabsConfig.advanced.clientSideFields;
            methodsRemove = LabsConfig.advanced.clientSideMethods;
        } else {
            fieldsRemove = LabsConfig.advanced.serverSideFields;
            methodsRemove = LabsConfig.advanced.serverSideMethods;
        }
        for (String field : fieldsRemove) {
            parts = field.split("@");
            if (parts.length != 2) {
                throw new IllegalStateException("Invalid Field Remove: " + field + "! Must have Two Parts, Seperated by '@', Got " + parts.length + "!");
            }
            ((List)toRemove.computeIfAbsent(parts[0], k -> Pair.of(new ArrayList(), new ArrayList())).getLeft()).add(new ObfMapping(parts[0], parts[1]));
        }
        for (String method : methodsRemove) {
            parts = method.split("@");
            if (parts.length != 3) {
                throw new IllegalStateException("Invalid Method Remove: " + method + "! Must have Three Parts, Seperated by '@', Got " + parts.length + "!");
            }
            ((List)toRemove.computeIfAbsent(parts[0], k -> Pair.of(new ArrayList(), new ArrayList())).getRight()).add(new ObfMapping(parts[0], parts[1], parts[2]));
        }
        LogManager.getLogger((String)"LabsASM").debug("Computed To Remove: {}", toRemove);
    }

    public static byte[] handleTransform(String internalName, byte[] basicClass) {
        SideSpecificRemover.setupToRemove();
        if (!toRemove.containsKey(internalName)) {
            return basicClass;
        }
        Pair<List<ObfMapping>, List<ObfMapping>> pair = toRemove.get(internalName);
        List fieldsRemove = (List)pair.getLeft();
        List methodsRemove = (List)pair.getRight();
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        for (Object toRemove : fieldsRemove) {
            Iterator fields = classNode.fields.iterator();
            boolean found = false;
            while (fields.hasNext()) {
                FieldNode field = (FieldNode)fields.next();
                if (!((ObfMapping)((Object)toRemove)).s_name.equals(field.name)) continue;
                LogManager.getLogger((String)"LabsASM").warn("Removing Field: {}.{}", (Object)classNode.name, (Object)field.name);
                fields.remove();
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalStateException("Could not find Field " + classNode.name + "." + ((ObfMapping)((Object)toRemove)).s_name + "!");
        }
        LambdaGatherer gatherer = new LambdaGatherer();
        for (ObfMapping toRemove : methodsRemove) {
            Iterator methods = classNode.methods.iterator();
            boolean found = false;
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                if (!toRemove.matches(method)) continue;
                LogManager.getLogger((String)"LabsASM").warn("Removing Method: {}.{}{}", (Object)classNode.name, (Object)method.name, (Object)method.desc);
                methods.remove();
                gatherer.accept(method);
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalStateException("Could not find Method " + classNode.name + "." + toRemove.s_name + toRemove.s_desc + "!");
        }
        LambdaGatherer.removeDynamicLambdaMethods(gatherer, classNode);
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

