/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.event;

import com.cleanroommc.groovyscript.event.GsHandEvent;
import com.cleanroommc.groovyscript.event.ScriptRunEvent;
import com.nomiceu.nomilabs.LabsSounds;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.block.registry.LabsBlocks;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.config.LabsVersionConfig;
import com.nomiceu.nomilabs.creativetab.registry.LabsCreativeTabs;
import com.nomiceu.nomilabs.dimension.LabsDimensions;
import com.nomiceu.nomilabs.fluid.FluidRegistryMixinHelper;
import com.nomiceu.nomilabs.fluid.registry.LabsFluids;
import com.nomiceu.nomilabs.gregtech.block.registry.LabsMetaBlocks;
import com.nomiceu.nomilabs.gregtech.item.LabsMetaItems;
import com.nomiceu.nomilabs.gregtech.material.registry.LabsMaterials;
import com.nomiceu.nomilabs.gregtech.metatileentity.registry.LabsMetaTileEntities;
import com.nomiceu.nomilabs.gregtech.mixinhelper.RecipeMapLogic;
import com.nomiceu.nomilabs.gregtech.prefix.LabsMaterialFlags;
import com.nomiceu.nomilabs.gregtech.prefix.LabsOrePrefix;
import com.nomiceu.nomilabs.gregtech.recipe.LabsRecipeMaps;
import com.nomiceu.nomilabs.gregtech.recipe.PerfectGemsCutterRecipes;
import com.nomiceu.nomilabs.groovy.GroovyScriptHandManager;
import com.nomiceu.nomilabs.groovy.NBTClearingRecipe;
import com.nomiceu.nomilabs.groovy.NCActiveCoolerHelper;
import com.nomiceu.nomilabs.groovy.mixinhelper.CraftingOutputCache;
import com.nomiceu.nomilabs.integration.architecturecraft.LabsShapes;
import com.nomiceu.nomilabs.integration.betterp2p.LabsBetterMemoryCardModes;
import com.nomiceu.nomilabs.integration.jei.LabsJEIPlugin;
import com.nomiceu.nomilabs.integration.nae2.AE2FCIntegration;
import com.nomiceu.nomilabs.integration.top.LabsTOPManager;
import com.nomiceu.nomilabs.item.ItemExcitationCoil;
import com.nomiceu.nomilabs.item.registry.LabsItems;
import com.nomiceu.nomilabs.mixinhelper.ResourcesObserver;
import com.nomiceu.nomilabs.network.LabsNetworkHandler;
import com.nomiceu.nomilabs.recipe.HandFramingRecipe;
import com.nomiceu.nomilabs.remap.LabsRemappers;
import com.nomiceu.nomilabs.remap.Remapper;
import com.nomiceu.nomilabs.remap.datafixer.DataFixerHandler;
import com.nomiceu.nomilabs.tooltip.LabsTooltipHelper;
import com.nomiceu.nomilabs.util.LabsDifficultyHelper;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import com.nomiceu.nomilabs.util.LabsNames;
import com.nomiceu.nomilabs.util.LabsSide;
import gregtech.api.GregTechAPI;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.unification.material.event.MaterialEvent;
import gregtech.api.unification.material.event.MaterialRegistryEvent;
import gregtech.api.unification.material.event.PostMaterialEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonProxy {
    public static boolean serverStartedMsg = false;

    public static void onConstruction() {
        LabsNetworkHandler.onConstruction();
    }

    public static void preInit() {
        LabsModeHelper.check();
        if (Loader.isModLoaded((String)"architecturecraft") && LabsConfig.modIntegration.enableArchitectureCraftIntegration) {
            LabsShapes.preInit();
        }
        if (Loader.isModLoaded((String)"betterp2p")) {
            LabsBetterMemoryCardModes.preInit();
        }
        LabsCreativeTabs.preInit();
        if (LabsConfig.content.customContent.enableItems) {
            LabsItems.preInit();
        }
        if (LabsConfig.content.customContent.enableBlocks) {
            LabsBlocks.preInit();
        }
        if (LabsConfig.content.customContent.enableFluids) {
            LabsFluids.preInit();
        }
        if (LabsConfig.content.gtCustomContent.enableItems) {
            LabsMetaItems.preInit();
        }
        if (LabsConfig.content.gtCustomContent.enableBlocks) {
            LabsMetaBlocks.preInit();
        }
        LabsSounds.register();
        LabsRemappers.preInit();
        LabsRecipeMaps.preInit();
        LabsMetaTileEntities.preInit();
        if (LabsConfig.modIntegration.enableTOPIntegration && Loader.isModLoaded((String)"theoneprobe")) {
            LabsTOPManager.register();
        }
        DataFixerHandler.preInit();
        FluidRegistryMixinHelper.preInit();
        LabsNetworkHandler.preInit();
        if (LabsConfig.content.customContent.enableVoidDimension) {
            LabsDimensions.register();
        }
    }

    public static void postInit() {
        LabsModeHelper.onPostInit();
        if (Loader.isModLoaded((String)"nae2") && Loader.isModLoaded((String)"ae2fc")) {
            AE2FCIntegration.postInit();
        }
    }

    public static void loadComplete() {
        FluidRegistryMixinHelper.loadComplete();
        RecipeMapLogic.clearAll();
        ResourcesObserver.onLoadComplete();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        LabsItems.register((IForgeRegistry<Item>)registry);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        LabsBlocks.register((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerMaterials(MaterialEvent event) {
        if (LabsConfig.content.gtCustomContent.enablePerfectGems) {
            LabsOrePrefix.init();
            LabsMaterialFlags.init();
        }
        if (LabsConfig.content.gtCustomContent.enableMaterials) {
            LabsMaterials.init();
        }
    }

    @SubscribeEvent
    public static void materialChanges(PostMaterialEvent event) {
        if (LabsConfig.content.gtCustomContent.enableMaterials) {
            LabsMaterials.materialChanges();
        }
    }

    @SubscribeEvent
    public static void createMaterialRegistry(MaterialRegistryEvent event) {
        GregTechAPI.materialManager.createRegistry("nomilabs");
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (LabsConfig.content.gtCustomContent.enablePerfectGems && LabsOrePrefix.GEM_PERFECT != null) {
            PerfectGemsCutterRecipes.initRecipes();
        }
        if (LabsConfig.content.customContent.enableComplexRecipes && LabsItems.HAND_FRAMING_TOOL != null) {
            event.getRegistry().register((IForgeRegistryEntry)new HandFramingRecipe(LabsNames.makeLabsName("hand_framing_recipe")));
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        EnumDifficulty toLock = LabsDifficultyHelper.getLockedDifficulty();
        if (toLock == null) {
            return;
        }
        event.getWorld().func_72912_H().func_176144_a(toLock);
        event.getWorld().func_72912_H().func_180783_e(true);
    }

    @SubscribeEvent
    public static void onTickEnd(TickEvent.ServerTickEvent event) {
        if (serverStartedMsg || !LabsSide.isDedicatedServer() || event.phase != TickEvent.Phase.END) {
            return;
        }
        serverStartedMsg = true;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        NomiLabs.LOGGER.info("=========================================================");
        NomiLabs.LOGGER.info("{} Server Successfully Started!", (Object)LabsConfig.advanced.serverWelcomeName);
        NomiLabs.LOGGER.info(" - Pack Version: {}", (Object)LabsVersionConfig.formattedVersion);
        NomiLabs.LOGGER.info(" - Mode: {}", (Object)LabsModeHelper.getFormattedMode());
        NomiLabs.LOGGER.info(" - Port: {}", (Object)server.func_71215_F());
        NomiLabs.LOGGER.info("Players Can Now Join!");
        NomiLabs.LOGGER.info("=========================================================");
    }

    @SubscribeEvent
    public static void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        ItemExcitationCoil.onEquipmentChange(event);
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("nomilabs")) {
            ConfigManager.sync((String)"nomilabs", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        LabsRemappers.remapAndIgnoreEntries(event, Remapper.RemapTypes.ITEM);
    }

    @SubscribeEvent
    public static void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        LabsRemappers.remapAndIgnoreEntries(event, Remapper.RemapTypes.BLOCK);
    }

    @SubscribeEvent
    public static void missingEntityMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        LabsRemappers.remapAndIgnoreEntries(event, Remapper.RemapTypes.ENTITY);
    }

    @SubscribeEvent
    public static void missingBiomeMappings(RegistryEvent.MissingMappings<Biome> event) {
        LabsRemappers.remapAndIgnoreEntries(event, Remapper.RemapTypes.BIOME);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void gsHandAdditions(GsHandEvent event) {
        if (LabsConfig.groovyScriptSettings.enableGroovyHandAdditions) {
            GroovyScriptHandManager.addToHand(event);
        }
    }

    @SubscribeEvent
    public static void onScriptReload(ScriptRunEvent.Pre event) {
        LabsJEIPlugin.onReload();
        LabsTooltipHelper.clearAll();
        NBTClearingRecipe.NBT_CLEARERS.clear();
        if (Loader.isModLoaded((String)"nuclearcraft")) {
            NCActiveCoolerHelper.onReload();
        }
    }

    @SubscribeEvent
    public static void afterScriptLoad(ScriptRunEvent.Post event) {
        if (Loader.isModLoaded((String)"nuclearcraft")) {
            NCActiveCoolerHelper.afterScriptLoad();
        }
        if (LabsConfig.groovyScriptSettings.craftingOutputCacheMode == LabsConfig.GroovyScriptSettings.CraftingOutputCacheMode.DISCARDED) {
            CraftingOutputCache.cache = null;
        }
        if (LabsSide.isDedicatedServer()) {
            NomiLabs.LOGGER.info("Fixing GT Ore Dict Caches... (DEDICATED SERVER ONLY)");
            GTRecipeOreInput.refreshStackCache();
        }
    }
}

