/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.fluid.registry;

import com.nomiceu.nomilabs.block.registry.LabsBlocks;
import com.nomiceu.nomilabs.fluid.FluidBase;
import com.nomiceu.nomilabs.util.LabsNames;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class LabsFluids {
    private static final List<Fluid> FLUIDS = new ArrayList<Fluid>();
    public static final Map<Fluid, Block> BLOCKS = new HashMap<Fluid, Block>();
    public static Fluid URANIUM_233;
    public static Fluid PLUTONIUM_2;
    public static Fluid MOLTEN_EMPOWERED_RESTONIA;
    public static Fluid MOLTEN_EMPOWERED_PALIS;
    public static Fluid MOLTEN_EMPOWERED_ENORI;
    public static Fluid MOLTEN_EMPOWERED_DIAMATINE;
    public static Fluid MOLTEN_EMPOWERED_EMERADIC;
    public static Fluid MOLTEN_EMPOWERED_VOID;
    public static Fluid ELEMENTAL_REDUCTION;
    public static Fluid TOUGH_ALLOY;
    public static Fluid MOLTEN_DARK_SOULARIUM;

    public static void preInit() {
        URANIUM_233 = LabsFluids.createFluid(new FluidBase("uranium233", -15173072, 1024, 0, 1405));
        PLUTONIUM_2 = LabsFluids.createFluid(new FluidBase("plutonium2", -575901, 1024, 0, 913));
        MOLTEN_EMPOWERED_RESTONIA = LabsFluids.createFluid(new FluidBase("moltenempoweredrestonia", -65536, 10000, 15, 1200));
        MOLTEN_EMPOWERED_PALIS = LabsFluids.createFluid(new FluidBase("moltenempoweredpalis", -16767233, 10000, 15, 1200));
        MOLTEN_EMPOWERED_ENORI = LabsFluids.createFluid(new FluidBase("moltenempoweredenori", -1644826, 10000, 15, 1200));
        MOLTEN_EMPOWERED_DIAMATINE = LabsFluids.createFluid(new FluidBase("moltenempowereddiamatine", -16712705, 10000, 15, 1200));
        MOLTEN_EMPOWERED_EMERADIC = LabsFluids.createFluid(new FluidBase("moltenempoweredemeradic", -16711936, 10000, 15, 1200));
        MOLTEN_EMPOWERED_VOID = LabsFluids.createFluid(new FluidBase("moltenempoweredvoid", -15856114, 10000, 15, 1200));
        ELEMENTAL_REDUCTION = LabsFluids.createFluid(new FluidBase("elementalreduction", -10974118, 2000, 7, 293));
        TOUGH_ALLOY = LabsFluids.createFluid(new FluidBase("tough_alloy", -15727588, 1024, 0, 1250));
        MOLTEN_DARK_SOULARIUM = LabsFluids.createFluid(new FluidBase("moltendarksoularium", -12441595, 1000, 0, 8600));
        LabsFluids.register();
    }

    public static <T extends Fluid> T createFluid(T fluid) {
        FLUIDS.add(fluid);
        return fluid;
    }

    public static void register() {
        for (Fluid fluid : FLUIDS) {
            LabsFluids.registerFluid(fluid);
        }
    }

    private static void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        BLOCKS.put(fluid, LabsBlocks.createBlockWithoutItem((Block)new BlockFluidClassic(fluid, Material.field_151586_h).setRegistryName(LabsNames.makeLabsName(fluid.getName()))));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidBlockModels() {
        FLUIDS.forEach(LabsFluids::registerCustomFluidBlockRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidModels(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        for (Fluid fluid : FLUIDS) {
            map.func_174942_a(fluid.getStill());
            map.func_174942_a(fluid.getFlowing());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerCustomFluidBlockRenderer(Fluid fluid) {
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @SideOnly(value=Side.CLIENT)
    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.location = new ModelResourceLocation(LabsNames.makeLabsName("fluids"), fluid.getName());
        }

        @NotNull
        protected ModelResourceLocation func_178132_a(@NotNull IBlockState state) {
            return this.location;
        }

        @NotNull
        public ModelResourceLocation func_178113_a(@NotNull ItemStack stack) {
            return this.location;
        }
    }
}

