/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.metatileentity.multiblock;

import com.nomiceu.nomilabs.gregtech.mixinhelper.ConditionalJEIMultiblock;
import com.nomiceu.nomilabs.gregtech.recipe.LabsRecipeMaps;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityActualizationChamber
extends RecipeMapMultiblockController
implements ConditionalJEIMultiblock {
    public MetaTileEntityActualizationChamber(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, LabsRecipeMaps.ACTUALIZATION_CHAMBER_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityActualizationChamber(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "GGG", "XXX"}).aisle(new String[]{"XXX", "GOG", "XXX"}).aisle(new String[]{"XSX", "GGG", "XXX"}).where('S', this.selfPredicate()).where('X', this.getCasingPredicateMain().setMinGlobalLimited(9).or(this.autoAbilities())).where('G', this.getCasingPredicateGlass()).where('O', this.getCasingPredicateCoil()).build();
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return this.recipeMapWorkable.isActive() ? Textures.ACTIVE_FUSION_TEXTURE : Textures.FUSION_TEXTURE;
    }

    protected TraceabilityPredicate getCasingPredicateMain() {
        return MetaTileEntityActualizationChamber.states((IBlockState[])new IBlockState[]{MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_CASING_MK3)});
    }

    protected TraceabilityPredicate getCasingPredicateGlass() {
        return MetaTileEntityActualizationChamber.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS)});
    }

    protected TraceabilityPredicate getCasingPredicateCoil() {
        return MetaTileEntityActualizationChamber.states((IBlockState[])new IBlockState[]{MetaBlocks.FUSION_CASING.getState((Enum)BlockFusionCasing.CasingType.FUSION_COIL)});
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.ENDER_FLUID_LINK;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public boolean canBeDistinct() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.actualization_chamber.description", new Object[0]));
        super.addInformation(stack, world, tooltip, advanced);
    }

    @Override
    public boolean shouldShowInJEI() {
        return LabsModeHelper.isExpert();
    }
}

