/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.metatileentity.multiblock;

import com.nomiceu.nomilabs.LabsTextures;
import com.nomiceu.nomilabs.gregtech.block.BlockUniqueCasing;
import com.nomiceu.nomilabs.gregtech.block.registry.LabsMetaBlocks;
import com.nomiceu.nomilabs.gregtech.recipe.LabsRecipeMaps;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityGrowthChamber
extends GCYMRecipeMapMultiblockController {
    public MetaTileEntityGrowthChamber(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, LabsRecipeMaps.GROWTH_CHAMBER_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityGrowthChamber(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"CCCCCCC", "BGGGGGB", "BGGGGGB", "#BGGGB#", "##VLV##"}).aisle(new String[]{"CDDPDDC", "G-----G", "G-----G", "#G---G#", "##GGG##"}).setRepeatable(3).aisle(new String[]{"CDDPDDC", "B-----B", "B-----B", "#B---B#", "##VLV##"}).aisle(new String[]{"CDDPDDC", "G-----G", "G-----G", "#G---G#", "##GGG##"}).setRepeatable(3).aisle(new String[]{"CCCSCCC", "BGGGGGB", "BGGGGGB", "#BGGGB#", "##VLV##"}).where('S', this.selfPredicate()).where('C', this.getCasingPredicateMain().setMinGlobalLimited(20).or(this.autoAbilities())).where('B', this.getCasingPredicateMain()).where('G', this.getCasingPredicateGlass()).where('D', this.getCasingPredicateDirt()).where('L', this.getCasingPredicateLamp()).where('V', this.getCasingPredicateVent()).where('P', this.getCasingPredicatePipe()).where('-', MetaTileEntityGrowthChamber.air()).where('#', MetaTileEntityGrowthChamber.any()).build();
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    protected TraceabilityPredicate getCasingPredicateMain() {
        return MetaTileEntityGrowthChamber.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID)});
    }

    protected TraceabilityPredicate getCasingPredicateGlass() {
        return MetaTileEntityGrowthChamber.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.TEMPERED_GLASS)});
    }

    protected TraceabilityPredicate getCasingPredicateDirt() {
        return MetaTileEntityGrowthChamber.states((IBlockState[])new IBlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_150349_c.func_176223_P(), Blocks.field_150458_ak.func_176223_P()});
    }

    protected TraceabilityPredicate getCasingPredicateLamp() {
        return LabsMetaBlocks.UNIQUE_CASING == null ? MetaTileEntityGrowthChamber.air() : MetaTileEntityGrowthChamber.states((IBlockState[])new IBlockState[]{LabsMetaBlocks.UNIQUE_CASING.getState(BlockUniqueCasing.UniqueCasingType.GROWTH_LIGHT)});
    }

    protected TraceabilityPredicate getCasingPredicateVent() {
        return LabsMetaBlocks.UNIQUE_CASING == null ? MetaTileEntityGrowthChamber.air() : MetaTileEntityGrowthChamber.states((IBlockState[])new IBlockState[]{LabsMetaBlocks.UNIQUE_CASING.getState(BlockUniqueCasing.UniqueCasingType.AIR_VENT)});
    }

    protected TraceabilityPredicate getCasingPredicatePipe() {
        return MetaTileEntityGrowthChamber.states((IBlockState[])new IBlockState[]{MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE)});
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return LabsTextures.GROWTH_CHAMBER_OVERLAY;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public boolean canBeDistinct() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.growth_chamber.description", new Object[0]));
        super.addInformation(stack, world, tooltip, advanced);
    }
}

