/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.metatileentity.multiblock;

import com.nomiceu.nomilabs.LabsTextures;
import com.nomiceu.nomilabs.block.registry.LabsBlocks;
import com.nomiceu.nomilabs.gregtech.metatileentity.registry.LabsMetaTileEntities;
import com.nomiceu.nomilabs.gregtech.recipe.LabsRecipeMaps;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.carving.Carving;

public abstract class MetaTileEntityMicroverseProjector
extends RecipeMapMultiblockController {
    public MetaTileEntityMicroverseProjector(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, LabsRecipeMaps.MICROVERSE_RECIPES.get(tier - 1));
    }

    protected TraceabilityPredicate getCasingPredicateMain() {
        return MetaTileEntityMicroverseProjector.states((IBlockState[])new IBlockState[]{LabsBlocks.MICROVERSE_CASING.func_176223_P()});
    }

    protected TraceabilityPredicate getCasingPredicateGlass() {
        return MetaTileEntityMicroverseProjector.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.TEMPERED_GLASS)});
    }

    protected TraceabilityPredicate getCasingPredicateDiamond() {
        ICarvingGroup group;
        if (Loader.isModLoaded((String)"chisel") && (group = Carving.chisel.getGroup(Blocks.field_150484_ah.func_176223_P())) != null) {
            return MetaTileEntityMicroverseProjector.states((IBlockState[])new IBlockState[]{((ICarvingVariation)group.getVariations().get(4)).getBlockState()});
        }
        return MetaTileEntityMicroverseProjector.air();
    }

    protected TraceabilityPredicate getCasingPredicateGrate() {
        return MetaTileEntityMicroverseProjector.states((IBlockState[])new IBlockState[]{MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING)});
    }

    protected TraceabilityPredicate getCasingPredicateEngine() {
        return MetaTileEntityMicroverseProjector.states((IBlockState[])new IBlockState[]{MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.ENGINE_INTAKE_CASING)});
    }

    protected IBlockState getCasingStateMain() {
        return LabsBlocks.MICROVERSE_CASING.func_176223_P();
    }

    protected IBlockState getCasingStateGlass() {
        return MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.TEMPERED_GLASS);
    }

    protected IBlockState getCasingStateDiamond() {
        return Loader.isModLoaded((String)"chisel") ? ((ICarvingVariation)Objects.requireNonNull(Carving.chisel.getGroup(Blocks.field_150484_ah.func_176223_P())).getVariations().get(4)).getBlockState() : Blocks.field_150350_a.func_176223_P();
    }

    protected IBlockState getCasingStateGrate() {
        return MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING);
    }

    protected IBlockState getCasingStateEngine() {
        return MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.ENGINE_INTAKE_CASING);
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return LabsTextures.MICROVERSE_CASING;
    }

    public boolean hasMufflerMechanics() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.COMPRESSOR_OVERLAY;
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public static class Microverse3
    extends MetaTileEntityMicroverseProjector {
        public Microverse3(ResourceLocation metaTileEntityId) {
            super(metaTileEntityId, 3);
        }

        @NotNull
        protected BlockPattern createStructurePattern() {
            return FactoryBlockPattern.start().aisle(new String[]{"#########", "#########", "##XXXXX##", "##XVXVX##", "##XXXXX##", "##XVXVX##", "##XXXXX##", "#########", "#########"}).aisle(new String[]{"#########", "##XGGGX##", "#XDDDDDX#", "#GDDDDDG#", "#GDDDDDG#", "#GDDDDDG#", "#XDDDDDX#", "##XGGGX##", "#########"}).aisle(new String[]{"##XXXXX##", "#XDDDDDX#", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "#XDDDDDX#", "##XXXXX##"}).aisle(new String[]{"##XGGGX##", "#GDDDDDG#", "XDDDDDDDX", "GDD---DDG", "GDD---DDG", "GDD---DDG", "XDDDDDDDX", "#GDDDDDG#", "##XGGGX##"}).setRepeatable(3).aisle(new String[]{"##XXXXX##", "#XDDDDDX#", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "#XDDDDDX#", "##XXXXX##"}).aisle(new String[]{"#########", "##XGGGX##", "#XDDDDDX#", "#GDDDDDG#", "#GDDDDDG#", "#GDDDDDG#", "#XDDDDDX#", "##XGGGX##", "#########"}).aisle(new String[]{"#########", "#########", "##XXSXX##", "##XGGGX##", "##XGGGX##", "##XGGGX##", "##XXXXX##", "#########", "#########"}).where('S', this.selfPredicate()).where('G', this.getCasingPredicateGlass()).where('V', this.getCasingPredicateEngine()).where('D', this.getCasingPredicateDiamond()).where('X', this.getCasingPredicateMain().setMinGlobalLimited(115).or(this.autoAbilities())).where('-', Microverse3.air()).where('#', Microverse3.any()).build();
        }

        public List<MultiblockShapeInfo> getMatchingShapes() {
            ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
            shapeInfo.add(MultiblockShapeInfo.builder().aisle(new String[]{"#########", "#########", "##XEEMX##", "##XVXVX##", "##XXHXX##", "##XVXVX##", "##XXXXX##", "#########", "#########"}).aisle(new String[]{"#########", "##XGGGX##", "#XDDDDDX#", "#GDDDDDG#", "#GDDDDDG#", "#GDDDDDG#", "#XDDDDDX#", "##XGGGX##", "#########"}).aisle(new String[]{"##XXXXX##", "#XDDDDDX#", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "#XDDDDDX#", "##XXXXX##"}).aisle(new String[]{"##XGGGX##", "#GDDDDDG#", "XDDDDDDDX", "GDD###DDG", "GDD###DDG", "GDD###DDG", "XDDDDDDDX", "#GDDDDDG#", "##XGGGX##"}).aisle(new String[]{"##XGGGX##", "#GDDDDDG#", "XDDDDDDDX", "GDD###DDG", "GDD###DDG", "GDD###DDG", "XDDDDDDDX", "#GDDDDDG#", "##XGGGX##"}).aisle(new String[]{"##XGGGX##", "#GDDDDDG#", "XDDDDDDDX", "GDD###DDG", "GDD###DDG", "GDD###DDG", "XDDDDDDDX", "#GDDDDDG#", "##XGGGX##"}).aisle(new String[]{"##XXXXX##", "#XDDDDDX#", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "XDDDDDDDX", "#XDDDDDX#", "##XXXXX##"}).aisle(new String[]{"#########", "##XGGGX##", "#XDDDDDX#", "#GDDDDDG#", "#GDDDDDG#", "#GDDDDDG#", "#XDDDDDX#", "##XGGGX##", "#########"}).aisle(new String[]{"#########", "#########", "##XISOX##", "##XGGGX##", "##XGGGX##", "##XGGGX##", "##XXXXX##", "#########", "#########"}).where('X', this.getCasingStateMain()).where('S', (MetaTileEntity)LabsMetaTileEntities.MICROVERSE_3, EnumFacing.SOUTH).where('G', this.getCasingStateGlass()).where('V', this.getCasingStateEngine()).where('D', this.getCasingStateDiamond()).where('H', (MetaTileEntity)MetaTileEntities.MUFFLER_HATCH[1], EnumFacing.NORTH).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.SOUTH).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[5], EnumFacing.NORTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : this.getCasingStateMain(), EnumFacing.NORTH).where('#', Blocks.field_150350_a.func_176223_P()).build());
            return shapeInfo;
        }

        public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new Microverse3(this.metaTileEntityId);
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
            super.addInformation(stack, world, tooltip, advanced);
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.microverse_projector_3.description", new Object[0]));
        }
    }

    public static class Microverse2
    extends MetaTileEntityMicroverseProjector {
        public Microverse2(ResourceLocation metaTileEntityId) {
            super(metaTileEntityId, 2);
        }

        @NotNull
        protected BlockPattern createStructurePattern() {
            return FactoryBlockPattern.start().aisle(new String[]{"XXXXX", "XGGGX", "XGGGX", "XGGGX", "XXXXX"}).aisle(new String[]{"XVXVX", "GDDDG", "GDDDG", "GDDDG", "XVXVX"}).aisle(new String[]{"XXXXX", "GDDDG", "GD#DG", "GDDDG", "XXXXX"}).aisle(new String[]{"XVXVX", "GDDDG", "GDDDG", "GDDDG", "XVXVX"}).aisle(new String[]{"XXSXX", "XGGGX", "XGGGX", "XGGGX", "XXXXX"}).where('S', this.selfPredicate()).where('G', this.getCasingPredicateGlass()).where('V', this.getCasingPredicateGrate()).where('D', this.getCasingPredicateDiamond()).where('X', this.getCasingPredicateMain().setMinGlobalLimited(45).or(this.autoAbilities())).where('#', Microverse2.air()).build();
        }

        public List<MultiblockShapeInfo> getMatchingShapes() {
            ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
            shapeInfo.add(MultiblockShapeInfo.builder().aisle(new String[]{"XEEMX", "XGGGX", "XGGGX", "XGGGX", "XXXXX"}).aisle(new String[]{"XVXVX", "GDDDG", "GDDDG", "GDDDG", "XVXVX"}).aisle(new String[]{"XXXXX", "GDDDG", "GD#DG", "GDDDG", "XXHXX"}).aisle(new String[]{"XVXVX", "GDDDG", "GDDDG", "GDDDG", "XVXVX"}).aisle(new String[]{"XISOX", "XGGGX", "XGGGX", "XGGGX", "XXXXX"}).where('X', this.getCasingStateMain()).where('S', (MetaTileEntity)LabsMetaTileEntities.MICROVERSE_2, EnumFacing.SOUTH).where('G', this.getCasingStateGlass()).where('V', this.getCasingStateGrate()).where('D', this.getCasingStateDiamond()).where('H', (MetaTileEntity)MetaTileEntities.MUFFLER_HATCH[1], EnumFacing.UP).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.SOUTH).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[4], EnumFacing.NORTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : this.getCasingStateMain(), EnumFacing.NORTH).where('#', Blocks.field_150350_a.func_176223_P()).build());
            return shapeInfo;
        }

        public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new Microverse2(this.metaTileEntityId);
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.microverse_projector_2.description", new Object[0]));
            super.addInformation(stack, world, tooltip, advanced);
        }
    }

    public static class Microverse1
    extends MetaTileEntityMicroverseProjector {
        public Microverse1(ResourceLocation metaTileEntityId) {
            super(metaTileEntityId, 1);
        }

        @NotNull
        protected BlockPattern createStructurePattern() {
            return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XVX", "XXX"}).aisle(new String[]{"XXX", "GDG", "XXX"}).aisle(new String[]{"XSX", "XGX", "XXX"}).where('S', this.selfPredicate()).where('G', this.getCasingPredicateGlass()).where('V', this.getCasingPredicateGrate()).where('D', this.getCasingPredicateDiamond()).where('X', this.getCasingPredicateMain().setMinGlobalLimited(12).or(this.autoAbilities())).build();
        }

        public List<MultiblockShapeInfo> getMatchingShapes() {
            ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
            shapeInfo.add(MultiblockShapeInfo.builder().aisle(new String[]{"EEM", "XVX", "XXX"}).aisle(new String[]{"FXX", "GDG", "XHX"}).aisle(new String[]{"ISO", "XGX", "XXX"}).where('X', this.getCasingStateMain()).where('S', (MetaTileEntity)LabsMetaTileEntities.MICROVERSE_1, EnumFacing.SOUTH).where('G', this.getCasingStateGlass()).where('V', this.getCasingStateGrate()).where('D', this.getCasingStateDiamond()).where('H', (MetaTileEntity)MetaTileEntities.MUFFLER_HATCH[1], EnumFacing.UP).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.SOUTH).where('F', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.WEST).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[2], EnumFacing.NORTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : this.getCasingStateMain(), EnumFacing.NORTH).build());
            return shapeInfo;
        }

        public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new Microverse1(this.metaTileEntityId);
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
            super.addInformation(stack, world, tooltip, advanced);
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.microverse_projector_1.description", new Object[0]));
        }
    }
}

