/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.metatileentity.multiblock;

import appeng.core.Api;
import com.blakebr0.extendedcrafting.block.BlockStorage;
import com.blakebr0.extendedcrafting.block.BlockTrimmed;
import com.blakebr0.extendedcrafting.block.ModBlocks;
import com.nomiceu.nomilabs.gregtech.material.registry.LabsMaterials;
import com.nomiceu.nomilabs.gregtech.recipe.LabsRecipeMaps;
import com.nomiceu.nomilabs.gregtech.recipe.recipelogic.NaqRecipeLogic;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregicality.multiblocks.api.render.GCYMTextures;
import gregicality.multiblocks.common.block.GCYMMetaBlocks;
import gregicality.multiblocks.common.block.blocks.BlockLargeMultiblockCasing;
import gregtech.api.GTValues;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class MetaTileEntityNaquadahReactor
extends FuelMultiblockController {
    public final int numSpatial;
    public final int voltageTier;
    public static final int AMP = 3;

    public MetaTileEntityNaquadahReactor(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int voltageTier, int numSpatial) {
        super(metaTileEntityId, recipeMap, voltageTier);
        this.voltageTier = voltageTier;
        this.numSpatial = numSpatial;
        this.recipeMapWorkable = new NaqRecipeLogic(this);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        int i;
        String[] aisle1 = new String[this.numSpatial + 2];
        String[] aisle2 = new String[this.numSpatial + 2];
        String[] aisle3 = new String[this.numSpatial + 2];
        aisle1[0] = "CCC";
        aisle2[0] = "CCC";
        aisle3[0] = "CSC";
        for (i = 1; i <= this.numSpatial; ++i) {
            aisle1[i] = "PGP";
            aisle3[i] = "PGP";
        }
        for (i = 1; i < this.numSpatial; ++i) {
            aisle2[i] = "GBG";
        }
        aisle2[this.numSpatial] = "GTG";
        aisle1[this.numSpatial + 1] = "CCC";
        aisle2[this.numSpatial + 1] = "CCC";
        aisle3[this.numSpatial + 1] = "CCC";
        return FactoryBlockPattern.start().aisle(aisle1).aisle(aisle2).aisle(aisle3).where('S', this.selfPredicate()).where('G', this.getCasingPredicateGlass()).where('P', this.getCasingPredicateSpatial()).where('T', this.getCasingPredicateTop()).where('B', this.getCasingPredicateBottom()).where('C', this.getCasingPredicateMain().setMinGlobalLimited(10).or(MetaTileEntityNaquadahReactor.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.OUTPUT_ENERGY}).setExactLimit(1)).or(this.autoAbilities(false, true, true, true, false, false, false))).build();
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return GCYMTextures.MIXER_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FUSION_REACTOR_OVERLAY;
    }

    protected TraceabilityPredicate getCasingPredicateMain() {
        return MetaTileEntityNaquadahReactor.states((IBlockState[])new IBlockState[]{GCYMMetaBlocks.LARGE_MULTIBLOCK_CASING.getState((Enum)BlockLargeMultiblockCasing.CasingType.MIXER_CASING)});
    }

    protected TraceabilityPredicate getCasingPredicateGlass() {
        return MetaTileEntityNaquadahReactor.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.FUSION_GLASS)});
    }

    protected abstract TraceabilityPredicate getCasingPredicateBottom();

    protected abstract TraceabilityPredicate getCasingPredicateTop();

    protected TraceabilityPredicate getCasingPredicateSpatial() {
        return Loader.isModLoaded((String)"appliedenergistics2") && Api.INSTANCE.definitions().blocks().spatialPylon().maybeBlock().isPresent() ? MetaTileEntityNaquadahReactor.states((IBlockState[])new IBlockState[]{((Block)Api.INSTANCE.definitions().blocks().spatialPylon().maybeBlock().get()).func_176223_P()}) : MetaTileEntityNaquadahReactor.air();
    }

    public void addSharedInfo(@NotNull List<String> tooltip) {
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.naquadah_reactor.produces", 3, GTValues.VNF[this.voltageTier] + TextFormatting.RESET));
        tooltip.add(LabsTranslate.translateFormat("tooltip.nomilabs.naquadah_reactor.overclock", TooltipHelper.RAINBOW_SLOW, new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    protected void addDisplayText(List<ITextComponent> textList) {
        if (!this.isStructureFormed()) {
            TextComponentTranslation tooltip = new TextComponentTranslation("gregtech.multiblock.invalid_structure.tooltip", new Object[0]);
            tooltip.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            textList.add(new TextComponentTranslation("gregtech.multiblock.invalid_structure", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)tooltip))));
        } else {
            long produces = GTValues.V[this.voltageTier] * 3L;
            String voltageName = GTValues.VNF[GTUtility.getFloorTierByVoltage((long)produces)] + TextFormatting.RESET;
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.max_energy_per_tick", new Object[]{TextFormattingUtil.formatNumbers((long)produces), voltageName}));
            if (!this.recipeMapWorkable.isWorkingEnabled()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.work_paused", new Object[0]));
            } else if (this.recipeMapWorkable.isActive()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.running", new Object[0]));
                int currentProgress = (int)(this.recipeMapWorkable.getProgressPercent() * 100.0);
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.progress", new Object[]{currentProgress}));
            } else {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.idling", new Object[0]));
            }
        }
    }

    public static class NaquadahReactor2
    extends MetaTileEntityNaquadahReactor {
        public NaquadahReactor2(ResourceLocation metaTileEntityId) {
            super(metaTileEntityId, LabsRecipeMaps.NAQUADAH_REACTOR_RECIPES.get(1), 8, 4);
        }

        public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new NaquadahReactor2(this.metaTileEntityId);
        }

        @Override
        protected TraceabilityPredicate getCasingPredicateBottom() {
            Material material = LabsModeHelper.isNormal() ? Materials.RutheniumTriniumAmericiumNeutronate : LabsMaterials.Taranium;
            return NaquadahReactor2.states((IBlockState[])new IBlockState[]{((BlockCompressed)MetaBlocks.COMPRESSED.get(material)).getBlock(material)});
        }

        @Override
        protected TraceabilityPredicate getCasingPredicateTop() {
            return Loader.isModLoaded((String)"extendedcrafting") ? NaquadahReactor2.states((IBlockState[])new IBlockState[]{ModBlocks.blockStorage.func_176203_a(BlockStorage.Type.ULTIMATE.getMetadata())}) : NaquadahReactor2.air();
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World player, @NotNull List<String> tooltip, boolean advanced) {
            super.addInformation(stack, player, tooltip, advanced);
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.naquadah_reactor_2.description", new Object[0]));
            this.addSharedInfo(tooltip);
        }
    }

    public static class NaquadahReactor1
    extends MetaTileEntityNaquadahReactor {
        public NaquadahReactor1(ResourceLocation metaTileEntityId) {
            super(metaTileEntityId, LabsRecipeMaps.NAQUADAH_REACTOR_RECIPES.get(0), 7, 3);
        }

        public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new NaquadahReactor1(this.metaTileEntityId);
        }

        @Override
        protected TraceabilityPredicate getCasingPredicateBottom() {
            return NaquadahReactor1.states((IBlockState[])new IBlockState[]{((BlockCompressed)MetaBlocks.COMPRESSED.get(Materials.Duranium)).getBlock(Materials.Duranium)});
        }

        @Override
        protected TraceabilityPredicate getCasingPredicateTop() {
            return Loader.isModLoaded((String)"extendedcrafting") ? NaquadahReactor1.states((IBlockState[])new IBlockState[]{ModBlocks.blockTrimmed.func_176203_a(BlockTrimmed.Type.ULTIMATE_TRIMMED.getMetadata())}) : NaquadahReactor1.air();
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, World player, @NotNull List<String> tooltip, boolean advanced) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.naquadah_reactor_1.description", new Object[0]));
            this.addSharedInfo(tooltip);
            super.addInformation(stack, player, tooltip, advanced);
        }
    }
}

