/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.mixinhelper;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.ItemFluidContainer;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class BucketItemFluidContainer
extends ItemFluidContainer
implements IItemBehaviour {
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        BlockPos tracedPos;
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult result = BucketItemFluidContainer.rayTrace(world, player, true);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return this.pass(stack);
        }
        ItemStack cellStack = GTUtility.copy((int)1, (ItemStack)stack);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)cellStack, (EntityPlayer)player, (World)world, (BlockPos)(tracedPos = result.func_178782_a()), (EnumFacing)result.field_178784_b);
        if (filledResult.isSuccess()) {
            this.addToPlayerInventory(stack, filledResult.getResult(), player, hand);
            return this.success(stack);
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)cellStack);
        if (fluid == null) {
            return this.pass(stack);
        }
        result = BucketItemFluidContainer.rayTrace(world, player, false);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return this.pass(stack);
        }
        tracedPos = result.func_178782_a();
        BlockPos placePos = tracedPos.func_177972_a(result.field_178784_b);
        if (!world.func_175660_a(player, tracedPos) || !player.func_175151_a(placePos, result.field_178784_b, cellStack)) {
            return this.pass(stack);
        }
        FluidActionResult emptiedResult = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)placePos, (ItemStack)cellStack, (FluidStack)fluid);
        if (emptiedResult.isSuccess()) {
            this.addToPlayerInventory(stack, emptiedResult.getResult(), player, hand);
            return this.success(stack);
        }
        return this.pass(stack);
    }

    @Nullable
    private static RayTraceResult rayTrace(World worldIn, EntityPlayer player, boolean useFluids) {
        Vec3d lookPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d lookOffset = player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
        return worldIn.func_147447_a(lookPos, lookPos.func_178787_e(lookOffset), useFluids, !useFluids, false);
    }

    private void addToPlayerInventory(ItemStack playerStack, ItemStack resultStack, EntityPlayer player, EnumHand hand) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (playerStack.func_190916_E() > resultStack.func_190916_E()) {
            EntityItem dropItem;
            playerStack.func_190918_g(resultStack.func_190916_E());
            if (!player.field_71071_by.func_70441_a(resultStack) && !player.field_70170_p.field_72995_K && (dropItem = player.func_70099_a(resultStack, 0.0f)) != null) {
                dropItem.func_174867_a(0);
            }
        } else {
            player.func_184611_a(hand, resultStack);
        }
    }

    private ActionResult<ItemStack> pass(ItemStack stack) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    private ActionResult<ItemStack> success(ItemStack stack) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

