/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.mixinhelper;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public class EitherOrBoth<L, R> {
    @Nullable
    private L valueL;
    @Nullable
    private R valueR;

    public Optional<L> getLeft() {
        return Optional.ofNullable(this.valueL);
    }

    public Optional<R> getRight() {
        return Optional.ofNullable(this.valueR);
    }

    public EitherOrBoth<L, R> setLeft(L value) {
        if (this.hasLeft()) {
            throw new IllegalArgumentException("Cannot set Either Or Both when value of that side already exists!");
        }
        this.valueL = value;
        return this;
    }

    public EitherOrBoth<L, R> setRight(R value) {
        if (this.hasRight()) {
            throw new IllegalArgumentException("Cannot set Either Or Both when value of that side already exists!");
        }
        this.valueR = value;
        return this;
    }

    public EitherOrBoth<L, R> setLeftIfNoValue(L value) {
        if (this.hasLeft()) {
            return this;
        }
        this.valueL = value;
        return this;
    }

    public EitherOrBoth<L, R> setRightIfNoValue(R value) {
        if (this.hasRight()) {
            return this;
        }
        this.valueR = value;
        return this;
    }

    public EitherOrBoth<L, R> removeLeft() {
        if (!this.hasLeft()) {
            return this;
        }
        this.valueL = null;
        return this;
    }

    public EitherOrBoth<L, R> removeRight() {
        if (!this.hasRight()) {
            return this;
        }
        this.valueR = null;
        return this;
    }

    public boolean hasLeft() {
        return this.valueL != null;
    }

    public boolean hasRight() {
        return this.valueR != null;
    }

    public static <L, R> EitherOrBoth<L, R> left(L value) {
        return new EitherOrBoth<L, R>().setLeft(value);
    }

    public static <L, R> EitherOrBoth<L, R> right(R value) {
        return new EitherOrBoth<L, R>().setRight(value);
    }

    public static <L, R> EitherOrBoth<L, R> both(L valueL, R valueR) {
        return new EitherOrBoth<L, R>().setLeft(valueL).setRight(valueR);
    }

    public <C, D> EitherOrBoth<C, D> map(Function<? super L, ? extends C> var1, Function<? super R, ? extends D> var2) {
        return EitherOrBoth.both(this.hasLeft() ? (L)var1.apply((L)this.valueL) : null, this.hasRight() ? (R)var2.apply((R)this.valueR) : null);
    }

    public <T> EitherOrBoth<T, R> mapLeft(Function<? super L, ? extends T> l) {
        return this.map(l, r -> this.valueR);
    }

    public <T> EitherOrBoth<L, T> mapRight(Function<? super R, ? extends T> r) {
        return this.map(l -> this.valueL, r);
    }
}

