/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.mixinhelper;

import com.nomiceu.nomilabs.gregtech.mixinhelper.EitherOrBoth;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.map.AbstractMapIngredient;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputBranch {
    private static final List<OutputBranch> REGISTERED_OUTPUT_BRANCHES = new ObjectArrayList();
    private Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> nodes;
    private Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> specialNodes;

    public OutputBranch() {
        REGISTERED_OUTPUT_BRANCHES.add(this);
    }

    public boolean isEmpty() {
        return !(this.nodes != null && !this.nodes.isEmpty() || this.specialNodes != null && !this.specialNodes.isEmpty());
    }

    @NotNull
    public Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> getNodes(AbstractMapIngredient ingredient) {
        if (ingredient.isSpecialIngredient()) {
            if (this.specialNodes == null) {
                this.specialNodes = new Object2ObjectOpenHashMap(1);
            }
            return this.specialNodes;
        }
        if (this.nodes == null) {
            this.nodes = new Object2ObjectOpenHashMap(1);
        }
        return this.nodes;
    }

    public void clear() {
        this.nodes = null;
        this.specialNodes = null;
    }

    @Nullable
    public Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> getNodesIfExists(AbstractMapIngredient ingredient) {
        if (ingredient.isSpecialIngredient()) {
            return this.specialNodes;
        }
        return this.nodes;
    }

    public static void clearAll() {
        for (OutputBranch branch : REGISTERED_OUTPUT_BRANCHES) {
            branch.clear();
        }
    }
}

