/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.mixinhelper;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.gregtech.mixinhelper.EitherOrBoth;
import com.nomiceu.nomilabs.gregtech.mixinhelper.MapChancedFluidIngredient;
import com.nomiceu.nomilabs.gregtech.mixinhelper.MapChancedItemStackIngredient;
import com.nomiceu.nomilabs.gregtech.mixinhelper.MapOutputItemStackIngredient;
import com.nomiceu.nomilabs.gregtech.mixinhelper.OutputBranch;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.map.AbstractMapIngredient;
import gregtech.api.recipes.map.MapFluidIngredient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeMapLogic {
    private static boolean outputBranchesCleared = false;
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> outputRoot = new WeakHashMap();
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> fluidOutputRoot = new WeakHashMap();
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> chancedOutputRoot = new WeakHashMap();
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> chancedFluidOutputRoot = new WeakHashMap();

    public static void clearAll() {
        if (LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.FAST_DISCARDED_TREE || LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.DISCARDED_TREE || LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.LINEAR_SEARCH) {
            NomiLabs.LOGGER.info("Clearing Output Branches and Output Maps...");
            outputBranchesCleared = true;
            OutputBranch.clearAll();
            outputRoot.clear();
            fluidOutputRoot.clear();
            chancedOutputRoot.clear();
            chancedFluidOutputRoot.clear();
        }
    }

    public static void add(@NotNull Recipe recipe, @NotNull OutputBranch branch) {
        if (LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.LINEAR_SEARCH || outputBranchesCleared) {
            return;
        }
        List<AbstractMapIngredient> list = RecipeMapLogic.getOutputFromRecipe(recipe);
        RecipeMapLogic.recurseOutputTreeAdd(recipe, list, branch, 0, 0);
    }

    private static void recurseOutputTreeAdd(@NotNull Recipe recipe, @NotNull List<AbstractMapIngredient> outputs, @NotNull OutputBranch branchMap, int index, int count) {
        if (count >= outputs.size()) {
            return;
        }
        if (index >= outputs.size()) {
            throw new RuntimeException("Index out of bounds for recurseOutputTreeAdd, should not happen");
        }
        AbstractMapIngredient current = outputs.get(index);
        Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> targetMap = branchMap.getNodes(current);
        EitherOrBoth r = targetMap.compute(current, (k, v) -> {
            if (count == outputs.size() - 1) {
                if (v == null) {
                    v = new EitherOrBoth<ObjectOpenHashSet, OutputBranch>();
                }
                v.setLeftIfNoValue(new ObjectOpenHashSet(1));
                ((Set)v.getLeft().get()).add(recipe);
                return v;
            }
            return v == null ? EitherOrBoth.right(new OutputBranch()) : v.setRightIfNoValue(new OutputBranch());
        });
        if (r.getLeft().isPresent() && ((Set)r.getLeft().get()).contains(recipe)) {
            return;
        }
        RecipeMapLogic.recurseOutputTreeAdd(recipe, outputs, (OutputBranch)r.getRight().get(), (index + 1) % outputs.size(), count + 1);
    }

    public static void remove(@NotNull Recipe recipe, @NotNull OutputBranch branch) {
        if (LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.LINEAR_SEARCH || outputBranchesCleared) {
            return;
        }
        List<AbstractMapIngredient> list = RecipeMapLogic.getOutputFromRecipe(recipe);
        RecipeMapLogic.recurseOutputTreeRemove(recipe, list, branch);
    }

    private static boolean recurseOutputTreeRemove(@NotNull Recipe recipe, @NotNull List<AbstractMapIngredient> outputs, @NotNull OutputBranch branchMap) {
        for (AbstractMapIngredient output : outputs) {
            OutputBranch branch;
            Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> targetMap = branchMap.getNodesIfExists(output);
            if (targetMap == null) continue;
            EitherOrBoth<Set<Recipe>, OutputBranch> result = targetMap.get(output);
            FoundType found = FoundType.NONE;
            if (result == null) continue;
            if (result.getLeft().isPresent() && result.getLeft().get().contains(recipe)) {
                found = FoundType.RECIPE;
            }
            if (result.getRight().isPresent() && RecipeMapLogic.recurseOutputTreeRemove(recipe, outputs.subList(1, outputs.size()), result.getRight().get())) {
                found = FoundType.BRANCH;
            }
            if (found == FoundType.NONE) continue;
            if (outputs.size() == 1 && found == FoundType.RECIPE) {
                if (result.getLeft().isPresent() && result.getLeft().get().size() <= 1) {
                    result.removeLeft();
                } else {
                    result.getLeft().get().remove(recipe);
                }
            }
            if (result.getRight().isPresent() && found == FoundType.BRANCH && (branch = result.getRight().get()).isEmpty()) {
                result.removeRight();
            }
            if (!result.getLeft().isPresent() && !result.getRight().isPresent()) {
                targetMap.remove(output);
            }
            return true;
        }
        return false;
    }

    private static List<AbstractMapIngredient> getOutputFromRecipe(Recipe r) {
        ObjectArrayList list = new ObjectArrayList(r.getOutputs().size() + r.getChancedOutputs().getChancedEntries().size() + r.getFluidOutputs().size() + r.getChancedFluidOutputs().getChancedEntries().size());
        for (ItemStack output : r.getOutputs()) {
            list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapOutputItemStackIngredient(output, output.func_77960_j(), output.func_77978_p()), outputRoot));
        }
        for (ItemStack output : r.getChancedOutputs().getChancedEntries()) {
            list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapChancedItemStackIngredient((ChancedItemOutput)output), chancedOutputRoot));
        }
        for (ItemStack output : r.getFluidOutputs()) {
            list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapFluidIngredient((FluidStack)output), fluidOutputRoot));
        }
        for (ItemStack output : r.getChancedFluidOutputs().getChancedEntries()) {
            list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapChancedFluidIngredient((ChancedFluidOutput)output), chancedFluidOutputRoot));
        }
        list.sort(Comparator.comparingInt(AbstractMapIngredient::hashCode));
        return list;
    }

    private static AbstractMapIngredient getCachedIngredient(AbstractMapIngredient ingredient, WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> cache) {
        WeakReference<AbstractMapIngredient> cached = cache.get(ingredient);
        if (cached != null && cached.get() != null) {
            return (AbstractMapIngredient)cached.get();
        }
        cache.put(ingredient, new WeakReference<AbstractMapIngredient>(ingredient));
        return ingredient;
    }

    @Nullable
    public static List<Recipe> find(@NotNull OutputBranch branch, @NotNull RecipeMap<?> map, @NotNull Collection<ItemStack> items, @NotNull Collection<FluidStack> fluids, @NotNull Collection<ChancedItemOutput> chancedItems, @NotNull Collection<ChancedFluidOutput> chancedFluids, @NotNull Predicate<Recipe> predicate) {
        List<AbstractMapIngredient> list = RecipeMapLogic.prepareOutputFind(items, fluids, chancedItems, chancedFluids);
        if (list == null) {
            return null;
        }
        if (LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.LINEAR_SEARCH || outputBranchesCleared) {
            return RecipeMapLogic.linearFind(map, list, predicate);
        }
        return RecipeMapLogic.recurseOutputTreeFindRecipe(list, branch, predicate);
    }

    @Nullable
    private static List<Recipe> recurseOutputTreeFindRecipe(@NotNull List<AbstractMapIngredient> outputs, @NotNull OutputBranch branchRoot, @NotNull Predicate<Recipe> canHandle) {
        ObjectArrayList result = new ObjectArrayList();
        for (int i = 0; i < outputs.size(); ++i) {
            RecipeMapLogic.recurseOutputTreeFindRecipe(outputs, branchRoot, canHandle, i, 0, 1L << i, (List<Recipe>)result);
        }
        return result.isEmpty() ? null : result;
    }

    private static boolean recurseOutputTreeFindRecipe(@NotNull List<AbstractMapIngredient> outputs, @NotNull OutputBranch branchRoot, @NotNull Predicate<Recipe> canHandle, int index, int count, long skip, List<Recipe> foundRecipes) {
        if (count == outputs.size()) {
            return false;
        }
        AbstractMapIngredient current = outputs.get(index);
        Map<AbstractMapIngredient, EitherOrBoth<Set<Recipe>, OutputBranch>> targetMap = branchRoot.getNodesIfExists(current);
        if (targetMap == null) {
            return false;
        }
        EitherOrBoth<Set<Recipe>, OutputBranch> result = targetMap.get(current);
        if (result != null) {
            List found;
            if (result.getLeft().isPresent() && count == outputs.size() - 1 && !(found = result.getLeft().get().stream().filter(canHandle).collect(Collectors.toList())).isEmpty()) {
                foundRecipes.addAll(found);
                if (LabsConfig.groovyScriptSettings.gtRecipeSearchMode == LabsConfig.GroovyScriptSettings.GTRecipeSearchMode.FAST_TREE) {
                    return true;
                }
            }
            if (result.getRight().isPresent()) {
                return RecipeMapLogic.diveIngredientTreeFindRecipe(outputs, result.getRight().get(), canHandle, index, count, skip, foundRecipes);
            }
        }
        return false;
    }

    private static boolean diveIngredientTreeFindRecipe(@NotNull List<AbstractMapIngredient> outputs, @NotNull OutputBranch map, @NotNull Predicate<Recipe> canHandle, int currentIndex, int count, long skip, List<Recipe> foundRecipes) {
        int i = (currentIndex + 1) % outputs.size();
        while (i != currentIndex) {
            boolean found;
            if ((skip & 1L << i) == 0L && (found = RecipeMapLogic.recurseOutputTreeFindRecipe(outputs, map, canHandle, i, count + 1, skip | 1L << i, foundRecipes))) {
                return true;
            }
            i = (i + 1) % outputs.size();
        }
        return false;
    }

    @Nullable
    private static List<AbstractMapIngredient> prepareOutputFind(@NotNull Collection<ItemStack> items, @NotNull Collection<FluidStack> fluids, @NotNull Collection<ChancedItemOutput> chancedItems, @NotNull Collection<ChancedFluidOutput> chancedFluids) {
        if (items.size() != Integer.MAX_VALUE && fluids.size() != Integer.MAX_VALUE) {
            if (items.isEmpty() && fluids.isEmpty() && chancedItems.isEmpty() && chancedFluids.isEmpty()) {
                return null;
            }
            ObjectArrayList list = new ObjectArrayList(items.size() + fluids.size());
            for (ItemStack itemStack : items) {
                list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapOutputItemStackIngredient(itemStack, itemStack.func_77960_j(), itemStack.func_77978_p()), outputRoot));
            }
            for (ChancedItemOutput chancedItemOutput : chancedItems) {
                list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapChancedItemStackIngredient(chancedItemOutput), chancedOutputRoot));
            }
            for (FluidStack fluidStack : fluids) {
                list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapFluidIngredient(fluidStack), fluidOutputRoot));
            }
            for (ChancedFluidOutput chancedFluidOutput : chancedFluids) {
                list.add(RecipeMapLogic.getCachedIngredient((AbstractMapIngredient)new MapChancedFluidIngredient(chancedFluidOutput), chancedFluidOutputRoot));
            }
            list.sort(Comparator.comparingInt(AbstractMapIngredient::hashCode));
            return list.isEmpty() ? null : list;
        }
        return null;
    }

    @Nullable
    private static List<Recipe> linearFind(@NotNull RecipeMap<?> map, @NotNull List<AbstractMapIngredient> list, @NotNull Predicate<Recipe> predicate) {
        ArrayList<Recipe> result = new ArrayList<Recipe>();
        for (Recipe recipe : map.getRecipeList()) {
            List<AbstractMapIngredient> recipeOutputs = RecipeMapLogic.getOutputFromRecipe(recipe);
            if (!recipeOutputs.equals(list) || !predicate.test(recipe)) continue;
            result.add(recipe);
        }
        return result.isEmpty() ? null : result;
    }

    private static enum FoundType {
        NONE,
        RECIPE,
        BRANCH;

    }
}

