/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.gregtech.recipe;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.gregtech.recipe.DMEDataProperty;
import com.nomiceu.nomilabs.gregtech.recipe.DMEDataPropertyData;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class DMESimChamberRecipeMapBuilder
extends RecipeBuilder<DMESimChamberRecipeMapBuilder> {
    private boolean setDataItem;
    private static final NBTMatcher EQUAL_TO_OR_NO_KEY = (tag, condition) -> {
        if (condition == null || condition.tagType == null) {
            return false;
        }
        if (!NBTMatcher.hasKey((NBTTagCompound)tag, (String)condition.nbtKey, (int)condition.tagType.typeId)) {
            return true;
        }
        return NBTMatcher.EQUAL_TO.evaluate(tag, condition);
    };

    public DMESimChamberRecipeMapBuilder() {
    }

    public DMESimChamberRecipeMapBuilder(Recipe recipe, RecipeMap<DMESimChamberRecipeMapBuilder> recipeMap) {
        super(recipe, recipeMap);
        this.setDataItem = false;
    }

    public DMESimChamberRecipeMapBuilder(@NotNull DMESimChamberRecipeMapBuilder builder) {
        super((RecipeBuilder)builder);
        this.setDataItem = builder.setDataItem;
    }

    public DMESimChamberRecipeMapBuilder copy() {
        return new DMESimChamberRecipeMapBuilder(this);
    }

    public DMESimChamberRecipeMapBuilder dataItem(@NotNull ItemStack dataItem, int tier) {
        return this.dataItem(dataItem.func_77973_b(), tier);
    }

    public DMESimChamberRecipeMapBuilder dataItem(@NotNull Item dataItem, int tier) {
        this.setDataItem = true;
        DMEDataPropertyData data = new DMEDataPropertyData(dataItem, tier);
        this.applyProperty(DMEDataProperty.getInstance(), data);
        ItemStack stack = new ItemStack(dataItem);
        DataModelHelper.setTierLevel((ItemStack)stack, (int)tier);
        GTRecipeItemInput input = new GTRecipeItemInput(stack);
        if (MetadataManager.isMinDataModelTier((int)tier)) {
            input.setNBTMatchingCondition(EQUAL_TO_OR_NO_KEY, NBTCondition.create((NBTTagType)NBTTagType.INT, (String)"tier", (Object)tier));
        } else {
            input.setNBTMatchingCondition(NBTMatcher.EQUAL_TO, NBTCondition.create((NBTTagType)NBTTagType.INT, (String)"tier", (Object)tier));
        }
        this.notConsumable((GTRecipeInput)input);
        return this;
    }

    protected EnumValidationResult validate() {
        if (!this.setDataItem) {
            if (LabsGroovyHelper.isRunningGroovyScripts()) {
                GroovyLog.get().error((Object)"Error adding DME Sim Chamber Recipe: Data Item must not be null.");
            } else {
                NomiLabs.LOGGER.error("Error adding DME Sim Chamber Recipe: Data Item must not be null.");
            }
            return EnumValidationResult.INVALID;
        }
        return super.validate();
    }

    public DMESimChamberRecipeMapBuilder append(Recipe recipe, int multiplier, boolean multiplyDuration) {
        super.append(recipe, multiplier, multiplyDuration);
        DMEDataPropertyData property = (DMEDataPropertyData)recipe.getProperty((RecipeProperty)DMEDataProperty.getInstance(), null);
        if (property != null) {
            this.setDataItem = true;
            property.setAddition(multiplier);
            this.applyProperty(DMEDataProperty.getInstance(), property);
        }
        return this;
    }
}

