/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleMaterial;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleRecipeMap;
import com.nomiceu.nomilabs.gregtech.mixinhelper.CompositionRecipeType;
import com.nomiceu.nomilabs.groovy.ABSRecipeReplacer;
import com.nomiceu.nomilabs.groovy.CompositionBuilder;
import com.nomiceu.nomilabs.groovy.LabsVirtualizedRegistries;
import com.nomiceu.nomilabs.mixin.gregtech.AccessibleDecompositionRecipeHandler;
import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeFluidInput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GroovyBlacklist
public class ChangeComposition {
    public static void reloadCompositionRecipes() {
        Deque<CompositionBuilder.CompositionSpecification> specs = LabsVirtualizedRegistries.REPLACE_DECOMP_MANAGER.needReloading;
        if (specs.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        ChangeComposition.changeDecomp(specs);
        ChangeComposition.changeABS(specs);
        ChangeComposition.changeMixer(specs);
        ChangeComposition.finalize(specs);
        NomiLabs.LOGGER.info("Reloading Composition Recipes took {}ms", (Object)(System.currentTimeMillis() - time));
    }

    public static void restore(CompositionBuilder.CompositionSpecification spec) {
        AccessibleMaterial mat = (AccessibleMaterial)spec.material;
        mat.setComponents(mat.getOriginalComponents(), true);
        for (Map.Entry<CompositionRecipeType, List<Recipe>> entry : mat.getOriginalRecipes().entrySet()) {
            entry.getKey().remove(spec.material);
            if (entry.getValue() == null) continue;
            for (Recipe recipe : entry.getValue()) {
                entry.getKey().map.compileRecipe(recipe);
            }
        }
    }

    private static void changeDecomp(Deque<CompositionBuilder.CompositionSpecification> specs) {
        NomiLabs.LOGGER.debug("Replacing Decomp Recipes...");
        specs.stream().filter(spec -> spec.changeDecomposition).distinct().forEach(spec -> {
            NomiLabs.LOGGER.debug("---------------------------");
            NomiLabs.LOGGER.debug("Processing Spec For Decomp:");
            NomiLabs.LOGGER.debug(spec);
            NomiLabs.LOGGER.debug("---------------------------");
            Material material = spec.material;
            NomiLabs.LOGGER.debug("Removing Decomp Recipes for {}...", (Object)material.getRegistryName());
            ChangeComposition.removeDecompRecipe(CompositionRecipeType.ELECTROLYZER, material);
            ChangeComposition.removeDecompRecipe(CompositionRecipeType.CENTRIFUGE, material);
            if (spec.components.isEmpty()) {
                return;
            }
            AccessibleMaterial mat = (AccessibleMaterial)material;
            mat.setComponents(spec.components);
            mat.recalculateDecompositionType();
            NomiLabs.LOGGER.debug("Adding Decomp Recipes for {}...", (Object)material.getRegistryName());
            OrePrefix prefix = material.hasProperty(PropertyKey.DUST) ? OrePrefix.dust : null;
            AccessibleDecompositionRecipeHandler.processDecomposition(prefix, material);
        });
        NomiLabs.LOGGER.debug("");
    }

    private static void changeABS(Deque<CompositionBuilder.CompositionSpecification> specs) {
        NomiLabs.LOGGER.debug("Replacing ABS Recipes...");
        specs.stream().filter(spec -> spec.changeABS).distinct().forEach(spec -> {
            NomiLabs.LOGGER.debug("------------------------");
            NomiLabs.LOGGER.debug("Processing Spec For ABS:");
            NomiLabs.LOGGER.debug(spec);
            NomiLabs.LOGGER.debug("------------------------");
            Material material = spec.material;
            NomiLabs.LOGGER.debug("Removing ABS Recipes for {}...", (Object)material.getRegistryName());
            ChangeComposition.removeABSRecipe(material);
            if (spec.components.isEmpty()) {
                return;
            }
            AccessibleMaterial mat = (AccessibleMaterial)material;
            mat.setComponents(spec.components);
            NomiLabs.LOGGER.debug("Adding ABS Recipes for {}...", (Object)material.getRegistryName());
            ABSRecipeReplacer.REPLACE_PRODUCER.produce(material, (BlastProperty)material.getProperty(PropertyKey.BLAST));
        });
        NomiLabs.LOGGER.debug("");
    }

    private static void changeMixer(Deque<CompositionBuilder.CompositionSpecification> specs) {
        NomiLabs.LOGGER.debug("Replacing Mixer Recipes...");
        specs.stream().filter(spec -> spec.changeMixer).distinct().forEach(spec -> {
            int outputAmount;
            NomiLabs.LOGGER.debug("--------------------------");
            NomiLabs.LOGGER.debug("Processing Spec For Mixer:");
            NomiLabs.LOGGER.debug(spec);
            NomiLabs.LOGGER.debug("--------------------------");
            Material material = spec.material;
            NomiLabs.LOGGER.debug("Removing Mixer Recipes for {}...", (Object)material.getRegistryName());
            Recipe originalRecipe = ChangeComposition.removeMixerRecipe(material);
            if (originalRecipe == null) {
                return;
            }
            int EUt = spec.mixerEUt == -1 ? originalRecipe.getEUt() : spec.mixerEUt;
            int duration = spec.mixerDuration == -1 ? originalRecipe.getDuration() : spec.mixerDuration;
            int circuit = spec.mixerCircuit == -1 ? ChangeComposition.getCircuit(originalRecipe.getInputs()) : spec.mixerCircuit;
            int n = outputAmount = spec.mixerOutputAmount == -1 ? spec.components.stream().mapToInt(mat -> (int)mat.amount).sum() : spec.mixerOutputAmount;
            if (spec.components.isEmpty()) {
                return;
            }
            NomiLabs.LOGGER.debug("Adding Mixer Recipes for {}...", (Object)material.getRegistryName());
            SimpleRecipeBuilder builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder()).inputs(ChangeComposition.getItemInputsFromComponents(spec.components).toArray(new GTRecipeInput[0]))).fluidInputs(ChangeComposition.getFluidInputsFromComponents(spec.components))).outputs(new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)material, (int)outputAmount)})).EUt(EUt)).duration(duration);
            if (circuit != 0) {
                builder.circuitMeta(circuit);
            }
            builder.buildAndRegister();
        });
        NomiLabs.LOGGER.debug("");
    }

    private static void finalize(Deque<CompositionBuilder.CompositionSpecification> specs) {
        Iterator<CompositionBuilder.CompositionSpecification> iter = specs.descendingIterator();
        while (iter.hasNext()) {
            CompositionBuilder.CompositionSpecification spec = iter.next();
            AccessibleMaterial mat = (AccessibleMaterial)spec.material;
            if (spec.changeChemicalFormula) {
                mat.setComponents(spec.components, true);
                continue;
            }
            mat.setComponents(mat.getOriginalComponents());
        }
    }

    public static void removeDecompRecipe(CompositionRecipeType type, Material input) {
        ItemStack itemInput = ItemStack.field_190927_a;
        FluidStack fluidInput = null;
        if (input.hasProperty(PropertyKey.DUST)) {
            itemInput = OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)input);
        } else {
            fluidInput = input.getFluid(1);
        }
        RecipeMap<?> map = type.map;
        Recipe recipe = map.find(itemInput.func_190926_b() ? Collections.emptyList() : Collections.singletonList(itemInput), fluidInput == null ? Collections.emptyList() : Collections.singletonList(fluidInput), recipe1 -> true);
        ((AccessibleMaterial)input).setOriginalRecipes(type, recipe == null ? Collections.emptyList() : Collections.singletonList(recipe));
        if (recipe == null) {
            return;
        }
        NomiLabs.LOGGER.debug("Removing Decomp Recipe for {} @ {} in recipe map {}.", (Object)itemInput.func_77973_b().getRegistryName(), (Object)itemInput.func_77960_j(), (Object)map.getUnlocalizedName());
        map.removeRecipe(recipe);
    }

    public static void removeABSRecipe(Material input) {
        Fluid fluid = input.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (fluid == null) {
            fluid = input.getFluid(FluidStorageKeys.LIQUID);
        }
        List<Recipe> recipes = ((AccessibleRecipeMap)GCYMRecipeMaps.ALLOY_BLAST_RECIPES).findByOutput(Collections.emptyList(), Collections.singletonList(new FluidStack(fluid, 1)), Collections.emptyList(), Collections.emptyList(), r -> true);
        ((AccessibleMaterial)input).setOriginalRecipes(CompositionRecipeType.ALLOY_BLAST, recipes == null ? Collections.emptyList() : recipes);
        if (recipes == null) {
            return;
        }
        for (Recipe recipe : recipes) {
            NomiLabs.LOGGER.debug("Removing ABS Recipe with inputs {} and fluid inputs {}.", (Object)recipe.getInputs(), (Object)recipe.getFluidInputs());
            GCYMRecipeMaps.ALLOY_BLAST_RECIPES.removeRecipe(recipe);
        }
    }

    @Nullable
    public static Recipe removeMixerRecipe(Material input) {
        List<Recipe> recipes = ((AccessibleRecipeMap)RecipeMaps.MIXER_RECIPES).findByOutput(Collections.singletonList(OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)input)), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), r -> true);
        ((AccessibleMaterial)input).setOriginalRecipes(CompositionRecipeType.MIXER, recipes == null ? Collections.emptyList() : recipes);
        if (recipes == null) {
            return null;
        }
        for (Recipe recipe : recipes) {
            NomiLabs.LOGGER.debug("Removing Mixer Recipe with inputs {} and fluid inputs {}.", (Object)recipe.getInputs(), (Object)recipe.getFluidInputs());
            RecipeMaps.MIXER_RECIPES.removeRecipe(recipe);
        }
        return recipes.get(0);
    }

    private static int getCircuit(List<GTRecipeInput> inputs) {
        for (GTRecipeInput input : inputs) {
            if (!input.isNonConsumable()) continue;
            for (ItemStack stack : input.getInputStacks()) {
                int circuit = IntCircuitIngredient.getCircuitConfiguration((ItemStack)stack);
                if (circuit == 0) continue;
                return circuit;
            }
        }
        return 0;
    }

    @NotNull
    private static List<GTRecipeInput> getItemInputsFromComponents(List<MaterialStack> components) {
        ObjectArrayList result = new ObjectArrayList();
        for (MaterialStack mat : components) {
            if (!mat.material.hasProperty(PropertyKey.DUST)) continue;
            result.add(new GTRecipeItemInput(OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)mat.material, (int)((int)mat.amount))));
        }
        return result;
    }

    @NotNull
    private static List<GTRecipeInput> getFluidInputsFromComponents(List<MaterialStack> components) {
        ObjectArrayList result = new ObjectArrayList();
        for (MaterialStack mat : components) {
            if (mat.material.hasProperty(PropertyKey.DUST) || !mat.material.hasFluid()) continue;
            result.add(new GTRecipeFluidInput(mat.material.getFluid((int)(mat.amount * 1000L))));
        }
        return result;
    }
}

