/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleIntCircuitIngredient;
import com.nomiceu.nomilabs.groovy.AccessibleGTRecipeInput;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ChangeRecipeBuilder<R extends RecipeBuilder<R>> {
    private final Recipe originalRecipe;
    private final RecipeMap<R> originalRecipeMap;
    private final R builder;

    public ChangeRecipeBuilder(Recipe originalRecipe, RecipeMap<R> map) {
        this.originalRecipe = originalRecipe;
        this.originalRecipeMap = map;
        this.builder = map.recipeBuilder();
        for (GTRecipeInput input : originalRecipe.getInputs()) {
            this.builder.input(ChangeRecipeBuilder.copy(input));
        }
        for (GTRecipeInput input : originalRecipe.getFluidInputs()) {
            this.builder.fluidInputs(ChangeRecipeBuilder.copy(input));
        }
        for (ItemStack output : originalRecipe.getOutputs()) {
            this.builder.outputs(new ItemStack[]{output.func_77946_l()});
        }
        for (ItemStack output : originalRecipe.getFluidOutputs()) {
            this.builder.fluidOutputs(new FluidStack[]{output.copy()});
        }
        for (ItemStack output : originalRecipe.getChancedOutputs().getChancedEntries()) {
            this.builder.chancedOutput(((ItemStack)output.getIngredient()).func_77946_l(), output.getChance(), output.getChanceBoost());
        }
        for (ItemStack output : originalRecipe.getChancedFluidOutputs().getChancedEntries()) {
            this.builder.chancedFluidOutput(((FluidStack)output.getIngredient()).copy(), output.getChance(), output.getChanceBoost());
        }
        if (originalRecipe.isHidden()) {
            this.builder.hidden();
        }
        this.builder.chancedOutputLogic(originalRecipe.getChancedOutputs().getChancedOutputLogic());
        this.builder.chancedFluidOutputLogic(originalRecipe.getChancedFluidOutputs().getChancedOutputLogic());
        this.builder.duration(originalRecipe.getDuration());
        this.builder.EUt(originalRecipe.getEUt());
    }

    public ChangeRecipeBuilder<R> copyOriginal() {
        return new ChangeRecipeBuilder<R>(this.originalRecipe, this.originalRecipeMap);
    }

    public ChangeRecipeBuilder<R> builder(Consumer<R> builderChanger) {
        builderChanger.accept(this.builder);
        return this;
    }

    private int getCircuitMeta(List<GTRecipeInput> inputs, boolean remove) {
        for (GTRecipeInput input : inputs) {
            if (!(input instanceof IntCircuitIngredient)) continue;
            IntCircuitIngredient circuit = (IntCircuitIngredient)input;
            if (remove) {
                inputs.remove(input);
            }
            return ((AccessibleIntCircuitIngredient)circuit).getMeta();
        }
        return -1;
    }

    public ChangeRecipeBuilder<R> clearCircuitMeta() {
        this.getCircuitMeta(this.builder.getInputs(), true);
        return this;
    }

    public ChangeRecipeBuilder<R> changeCircuitMeta(Function<Integer, Integer> circuitMeta) {
        this.clearCircuitMeta();
        this.builder.circuitMeta(circuitMeta.apply(this.getCircuitMeta(this.originalRecipe.getInputs(), false)).intValue());
        return this;
    }

    public ChangeRecipeBuilder<R> changeEUt(Function<Integer, Integer> eut) {
        this.builder.EUt(eut.apply(this.originalRecipe.getEUt()).intValue());
        return this;
    }

    public ChangeRecipeBuilder<R> changeDuration(Function<Integer, Integer> duration) {
        this.builder.duration(duration.apply(this.originalRecipe.getDuration()).intValue());
        return this;
    }

    public ChangeRecipeBuilder<R> changeInputs(Consumer<List<GTRecipeInput>> itemChanger) {
        this.builder.clearInputs();
        List newInputs = this.originalRecipe.getInputs().stream().map(ChangeRecipeBuilder::copy).collect(Collectors.toList());
        itemChanger.accept(newInputs);
        this.builder.inputIngredients(newInputs);
        return this;
    }

    public ChangeRecipeBuilder<R> changeEachInput(Function<GTRecipeInput, GTRecipeInput> itemChanger) {
        this.builder.clearInputs();
        for (GTRecipeInput origInput : this.originalRecipe.getInputs()) {
            GTRecipeInput newInput = itemChanger.apply(ChangeRecipeBuilder.copy(origInput));
            if (newInput == null) continue;
            this.builder.input(newInput);
        }
        return this;
    }

    public ChangeRecipeBuilder<R> changeFluidInputs(Consumer<List<GTRecipeInput>> fluidChanger) {
        this.builder.clearFluidInputs();
        List newInputs = this.originalRecipe.getFluidInputs().stream().map(ChangeRecipeBuilder::copy).collect(Collectors.toList());
        fluidChanger.accept(newInputs);
        this.builder.fluidInputs(newInputs);
        return this;
    }

    public ChangeRecipeBuilder<R> changeEachFluidInput(Function<GTRecipeInput, GTRecipeInput> fluidChanger) {
        this.builder.clearFluidInputs();
        for (GTRecipeInput origInput : this.originalRecipe.getFluidInputs()) {
            GTRecipeInput newInput = fluidChanger.apply(ChangeRecipeBuilder.copy(origInput));
            if (newInput == null) continue;
            this.builder.fluidInputs(newInput);
        }
        return this;
    }

    public ChangeRecipeBuilder<R> changeOutputs(Consumer<List<ItemStack>> itemChanger) {
        this.builder.clearOutputs();
        List newOutputs = this.originalRecipe.getOutputs().stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        itemChanger.accept(newOutputs);
        this.builder.outputs(newOutputs);
        return this;
    }

    public ChangeRecipeBuilder<R> changeEachOutput(Function<ItemStack, ItemStack> itemChanger) {
        this.builder.clearOutputs();
        for (ItemStack origOutput : this.originalRecipe.getOutputs()) {
            ItemStack newOutput = itemChanger.apply(origOutput.func_77946_l());
            if (newOutput == null) continue;
            this.builder.outputs(new ItemStack[]{newOutput});
        }
        return this;
    }

    public ChangeRecipeBuilder<R> changeFluidOutputs(Consumer<List<FluidStack>> fluidChanger) {
        this.builder.clearFluidOutputs();
        List newOutputs = this.originalRecipe.getFluidOutputs().stream().map(FluidStack::copy).collect(Collectors.toList());
        fluidChanger.accept(newOutputs);
        this.builder.fluidOutputs(newOutputs);
        return this;
    }

    public ChangeRecipeBuilder<R> changeEachFluidOutput(Function<FluidStack, FluidStack> fluidChanger) {
        this.builder.clearFluidOutputs();
        for (FluidStack origOutput : this.originalRecipe.getFluidOutputs()) {
            FluidStack newOutput = fluidChanger.apply(origOutput.copy());
            if (newOutput == null) continue;
            this.builder.fluidOutputs(new FluidStack[]{newOutput});
        }
        return this;
    }

    public ChangeRecipeBuilder<R> changeChancedOutputs(Consumer<List<ChancedItemOutput>> itemChanger) {
        this.builder.clearChancedOutput();
        List newOutputs = this.originalRecipe.getChancedOutputs().getChancedEntries().stream().map(ChancedItemOutput::copy).collect(Collectors.toList());
        itemChanger.accept(newOutputs);
        this.builder.chancedOutputs(newOutputs);
        return this;
    }

    public ChangeRecipeBuilder<R> changeEachChancedOutput(Function<ChancedItemOutput, ChancedItemOutput> itemChanger) {
        this.builder.clearChancedOutput();
        for (ChancedItemOutput origOutput : this.originalRecipe.getChancedOutputs().getChancedEntries()) {
            ChancedItemOutput newOutput = itemChanger.apply(origOutput);
            if (newOutput == null) continue;
            this.builder.chancedOutput(((ItemStack)newOutput.getIngredient()).func_77946_l(), newOutput.getChance(), newOutput.getChanceBoost());
        }
        return this;
    }

    public ChangeRecipeBuilder<R> changeChancedFluidOutputs(Consumer<List<ChancedFluidOutput>> fluidChanger) {
        this.builder.clearChancedFluidOutputs();
        List newOutputs = this.originalRecipe.getChancedFluidOutputs().getChancedEntries().stream().map(ChancedFluidOutput::copy).collect(Collectors.toList());
        fluidChanger.accept(newOutputs);
        this.builder.chancedFluidOutputs(newOutputs);
        return this;
    }

    public ChangeRecipeBuilder<R> changeEachChancedFluidOutput(Function<ChancedFluidOutput, ChancedFluidOutput> fluidChanger) {
        this.builder.clearChancedFluidOutputs();
        for (ChancedFluidOutput origOutput : this.originalRecipe.getChancedFluidOutputs().getChancedEntries()) {
            ChancedFluidOutput newOutput = fluidChanger.apply(origOutput);
            if (newOutput == null) continue;
            this.builder.chancedFluidOutput(((FluidStack)newOutput.getIngredient()).copy(), newOutput.getChance(), newOutput.getChanceBoost());
        }
        return this;
    }

    public ChangeRecipeBuilder<R> changeChancedOutputLogic(Function<ChancedOutputLogic, ChancedOutputLogic> logicChanger) {
        this.builder.chancedOutputLogic(logicChanger.apply(this.originalRecipe.getChancedOutputs().getChancedOutputLogic()));
        return this;
    }

    public ChangeRecipeBuilder<R> changeChancedFluidOutputLogic(Function<ChancedOutputLogic, ChancedOutputLogic> logicChanger) {
        this.builder.chancedFluidOutputLogic(logicChanger.apply(this.originalRecipe.getChancedFluidOutputs().getChancedOutputLogic()));
        return this;
    }

    public ChangeRecipeBuilder<R> copyProperties(RecipeProperty<?> ... properties) {
        for (RecipeProperty<?> property : properties) {
            Object prop = this.originalRecipe.getProperty(property, null);
            if (prop == null) {
                GroovyLog.get().error("Could not find property {} in recipe {}!", new Object[]{property.getKey(), this.originalRecipe});
                continue;
            }
            this.builder.applyProperty(property, prop);
        }
        return this;
    }

    public <T> ChangeRecipeBuilder<R> changeProperty(RecipeProperty<T> property, Function<T, T> changer) {
        Object prop = this.originalRecipe.getProperty(property, null);
        if (prop == null) {
            GroovyLog.get().error("Could not find property {} in recipe {}!", new Object[]{property.getKey(), this.originalRecipe});
            return this;
        }
        this.builder.applyProperty(property, changer.apply(prop));
        return this;
    }

    public void buildAndRegister() {
        this.builder.buildAndRegister();
    }

    public void replaceAndRegister() {
        this.originalRecipeMap.removeRecipe(this.originalRecipe);
        this.buildAndRegister();
    }

    private static GTRecipeInput copy(GTRecipeInput in) {
        return ((AccessibleGTRecipeInput)in).accessibleCopy();
    }
}

