/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleMaterial;
import com.nomiceu.nomilabs.groovy.LabsVirtualizedRegistries;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.unification.GCYMMaterialFlags;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CompositionBuilder {
    private final Material material;
    private List<MaterialStack> components = null;
    private boolean changeChemicalFormula = false;
    private boolean changeDecomposition = false;
    private boolean changeABS = false;
    private MixerSpecification changeMixer = null;

    public CompositionBuilder(@NotNull Material material) {
        this.material = material;
    }

    public CompositionBuilder setComponents(List<IIngredient> components) {
        this.components = CompositionBuilder.getMatFromIIngredient(components);
        return this;
    }

    public CompositionBuilder removeComponents() {
        this.components = Collections.emptyList();
        return this;
    }

    public CompositionBuilder reloadComponents() {
        this.components = ((AccessibleMaterial)this.material).getOriginalComponents();
        return this;
    }

    public CompositionBuilder changeChemicalFormula() {
        this.changeChemicalFormula = true;
        return this;
    }

    public CompositionBuilder changeDecompositionRecipes() {
        this.changeDecomposition = true;
        return this;
    }

    public CompositionBuilder changeABS() {
        this.changeABS = true;
        return this;
    }

    public CompositionBuilder changeMixer() {
        this.changeMixer = new MixerSpecification();
        return this;
    }

    public CompositionBuilder changeMixer(MixerSpecification builder) {
        this.changeMixer = builder;
        return this;
    }

    public void change() {
        if (this.components == null) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Cannot change when components, or removal, has not been specified!"));
            return;
        }
        if (!(this.changeChemicalFormula || this.changeDecomposition || this.changeABS || this.changeMixer != null)) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Cannot change when change method(s) have not been specified!"));
            return;
        }
        if (this.changeDecomposition && this.material.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION)) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Cannot change when decomposition changing is specified, but the material has DISABLE_DECOMPOSITION flag!"));
            return;
        }
        if (this.changeMixer != null && !this.material.hasProperty(PropertyKey.DUST)) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Cannot change when mixer changing is specified, but the material does not have a Dust Property!"));
            return;
        }
        if (this.changeABS && (!this.material.hasProperty(GCYMPropertyKey.ALLOY_BLAST) || !this.material.hasProperty(PropertyKey.BLAST) || !this.material.hasFluid() || this.material.getFluid(GCYMFluidStorageKeys.MOLTEN) == null && this.material.getFluid(FluidStorageKeys.LIQUID) == null || this.material.hasFlag(GCYMMaterialFlags.NO_ALLOY_BLAST_RECIPES))) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Cannot change when ABS changing is specified, but the material cannot generate ABS recipes to a Fluid!"));
            return;
        }
        LabsVirtualizedRegistries.REPLACE_DECOMP_MANAGER.changeMaterialDecomp(new CompositionSpecification(this));
    }

    public static List<MaterialStack> getMatFromIIngredient(List<IIngredient> ingredients) {
        ArrayList<MaterialStack> result = new ArrayList<MaterialStack>();
        for (IIngredient ingredient : ingredients) {
            ItemStack stack;
            IIngredient iIngredient = ingredient;
            if (iIngredient instanceof ItemStack) {
                stack = (ItemStack)iIngredient;
                MaterialStack mat = CompositionBuilder.getMatFromStack(stack);
                result.add(mat);
                continue;
            }
            iIngredient = ingredient;
            if (iIngredient instanceof MaterialStack) {
                stack = (MaterialStack)iIngredient;
                result.add((MaterialStack)stack);
                continue;
            }
            iIngredient = ingredient;
            if (iIngredient instanceof FluidStack) {
                stack = (FluidStack)iIngredient;
                result.add(CompositionBuilder.getMatFromFluid((FluidStack)stack));
                continue;
            }
            IllegalArgumentException e = new IllegalArgumentException("Component Specification must be an Item Stack, a Material Stack, or a Fluid Stack!");
            if (!LabsGroovyHelper.isRunningGroovyScripts()) {
                throw e;
            }
            GroovyLog.get().exception((Throwable)e);
            result.add(null);
        }
        if (result.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        return result;
    }

    @Nullable
    public static MaterialStack getMatFromStack(ItemStack stack) {
        MaterialStack material = OreDictUnifier.getMaterial((ItemStack)stack);
        if (material == null) {
            IllegalArgumentException e = new IllegalArgumentException(String.format("Could not find Material for Stack %s @ %s, with %s.", stack.func_77973_b().getRegistryName(), stack.func_77960_j(), stack.func_77942_o() ? "Tag " + stack.func_77978_p() : "No Tag"));
            if (!LabsGroovyHelper.isRunningGroovyScripts()) {
                throw e;
            }
            GroovyLog.get().exception((Throwable)e);
            return null;
        }
        return material.copy((long)stack.func_190916_E());
    }

    @Nullable
    public static MaterialStack getMatFromFluid(FluidStack fluid) {
        Material mat = CompositionBuilder.getMaterialFromFluid(fluid);
        if (mat == null) {
            return null;
        }
        if (fluid.amount % 1000 != 0 || fluid.amount < 1000) {
            IllegalArgumentException e = new IllegalArgumentException("Fluid Amount must be divisible by 1000, and be at least 1000!");
            if (!LabsGroovyHelper.isRunningGroovyScripts()) {
                throw e;
            }
            GroovyLog.get().exception((Throwable)e);
            return null;
        }
        return new MaterialStack(mat, (long)(fluid.amount / 1000));
    }

    @Nullable
    public static Material getMaterialFromFluid(FluidStack fluid) {
        String name = fluid.getFluid().getName();
        Material mat = null;
        for (MaterialRegistry registry : GregTechAPI.materialManager.getRegistries()) {
            Material foundMat;
            if (!registry.func_148741_d((Object)name) || (foundMat = (Material)registry.func_82594_a((Object)name)) == null || !foundMat.hasProperty(PropertyKey.FLUID)) continue;
            mat = foundMat;
            break;
        }
        if (mat == null) {
            IllegalArgumentException e = new IllegalArgumentException(String.format("Could not find Material for Fluid %s!", fluid.getFluid().getName()));
            if (!LabsGroovyHelper.isRunningGroovyScripts()) {
                throw e;
            }
            GroovyLog.get().exception((Throwable)e);
            return null;
        }
        return mat;
    }

    public static class MixerSpecification {
        private int EUt = -1;
        private int duration = -1;
        private int circuit = -1;
        private int outputAmount = -1;

        public MixerSpecification overrideEUt(int EUt) {
            if (EUt <= 0) {
                LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("EUt override must be larger than 0!"));
                return this;
            }
            this.EUt = EUt;
            return this;
        }

        public MixerSpecification overrideDuration(int duration) {
            if (duration <= 0) {
                LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Duration override must be larger than 0!"));
                return this;
            }
            this.duration = duration;
            return this;
        }

        public MixerSpecification overrideCircuit(int circuit) {
            if (circuit < 0) {
                LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Circuit override must be larger or equal to 0!"));
                return this;
            }
            this.circuit = circuit;
            return this;
        }

        public MixerSpecification overrideOutputAmount(int outputAmount) {
            if (outputAmount <= 0) {
                LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Output amount override must be larger or equal to 0!"));
                return this;
            }
            this.outputAmount = outputAmount;
            return this;
        }
    }

    public static class CompositionSpecification {
        public final Material material;
        public final ImmutableList<MaterialStack> components;
        public final boolean changeChemicalFormula;
        public final boolean changeDecomposition;
        public final boolean changeABS;
        public final boolean changeMixer;
        public final int mixerEUt;
        public final int mixerDuration;
        public final int mixerCircuit;
        public final int mixerOutputAmount;

        private CompositionSpecification(CompositionBuilder builder) {
            this.material = builder.material;
            this.components = ImmutableList.copyOf((Collection)builder.components);
            this.changeChemicalFormula = builder.changeChemicalFormula;
            this.changeDecomposition = builder.changeDecomposition;
            this.changeABS = builder.changeABS;
            boolean bl = this.changeMixer = builder.changeMixer != null;
            if (this.changeMixer) {
                this.mixerEUt = builder.changeMixer.EUt;
                this.mixerDuration = builder.changeMixer.duration;
                this.mixerCircuit = builder.changeMixer.circuit;
                this.mixerOutputAmount = builder.changeMixer.outputAmount;
            } else {
                this.mixerEUt = -1;
                this.mixerDuration = -1;
                this.mixerCircuit = -1;
                this.mixerOutputAmount = -1;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositionSpecification that = (CompositionSpecification)o;
            return Objects.equals(this.material, that.material);
        }

        public int hashCode() {
            return Objects.hash(this.material);
        }

        public String toString() {
            return "DecompositionSpecification{material=" + this.material + ", components=" + this.components + ", changeChemicalFormula=" + this.changeChemicalFormula + ", changeDecomposition=" + this.changeDecomposition + ", changeABS=" + this.changeABS + ", changeMixer=" + this.changeMixer + ", mixerEUt=" + this.mixerEUt + ", mixerDuration=" + this.mixerDuration + ", mixerCircuit=" + this.mixerCircuit + ", mixerOutputAmount=" + this.mixerOutputAmount + '}';
        }
    }
}

