/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.mods.ModSupport;
import com.cleanroommc.groovyscript.compat.mods.draconicevolution.DraconicEvolution;
import com.cleanroommc.groovyscript.compat.mods.jei.JustEnoughItems;
import com.cleanroommc.groovyscript.helper.GroovyHelper;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.helper.recipe.RecipeName;
import com.cleanroommc.groovyscript.registry.ReloadableRegistryManager;
import com.cleanroommc.groovyscript.sandbox.ClosureHelper;
import com.nomiceu.nomilabs.groovy.CompositionBuilder;
import com.nomiceu.nomilabs.groovy.LabsVirtualizedRegistries;
import com.nomiceu.nomilabs.groovy.MaterialHelper;
import com.nomiceu.nomilabs.groovy.NBTClearingRecipe;
import com.nomiceu.nomilabs.groovy.RecyclingHelper;
import com.nomiceu.nomilabs.integration.jei.LabsJEIPlugin;
import com.nomiceu.nomilabs.mixin.gregtech.RecipeBuilderAccessor;
import com.nomiceu.nomilabs.tooltip.LabsTooltipHelper;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregtech.api.GregTechAPI;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.TooltipHelper;
import gregtech.integration.groovy.VirtualizedRecipeMap;
import groovy.lang.Closure;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroovyHelpers {

    public static class NBTClearingRecipeHelpers {
        public static NBTClearingRecipe nbtClearingRecipe(ItemStack item) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(item, item, null);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack item, @Nullable Consumer<ItemStack> clearer) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(item, item, clearer);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack input, ItemStack output) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(input, output, null);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack input, ItemStack exampleOutput, @Nullable Consumer<ItemStack> clearer) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(input, exampleOutput, clearer, NBTClearingRecipe.CAN_CLEAR_TOOLTIP, NBTClearingRecipe.WARNING_TOOLTIP);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack item, LabsTranslate.Translatable tooltip) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(item, item, null, tooltip);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack item, @Nullable Consumer<ItemStack> clearer, LabsTranslate.Translatable canClearTooltip, LabsTranslate.Translatable warningTooltip) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(item, item, clearer, canClearTooltip, warningTooltip);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack input, ItemStack output, LabsTranslate.Translatable canClearTooltip, LabsTranslate.Translatable warningTooltip) {
            return NBTClearingRecipeHelpers.nbtClearingRecipe(input, output, null, canClearTooltip, warningTooltip);
        }

        public static NBTClearingRecipe nbtClearingRecipe(ItemStack input, ItemStack exampleOutput, @Nullable Consumer<ItemStack> clearer, LabsTranslate.Translatable canClearTooltip, LabsTranslate.Translatable warningTooltip) {
            ResourceLocation name = RecipeName.generateRl((String)"nomilabs_nbt_clearing");
            GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Minecraft Shaped Crafting recipe '{}'", (Object[])new Object[]{name}).error().add(IngredientHelper.isEmpty((ItemStack)input), () -> "Input must not be empty").add(IngredientHelper.isEmpty((ItemStack)exampleOutput), () -> "Output must not be empty").add(ReloadableRegistryManager.hasNonDummyRecipe((ResourceLocation)name), () -> "a recipe with that name already exists! Remove the recipe first");
            if (msg.postIfNotEmpty()) {
                return null;
            }
            input = input.func_77946_l();
            input.func_190920_e(1);
            input.func_77982_d(null);
            exampleOutput = exampleOutput.func_77946_l();
            exampleOutput.func_190920_e(1);
            exampleOutput.func_77982_d(null);
            NBTClearingRecipe recipe = new NBTClearingRecipe(input, exampleOutput, clearer);
            NBTClearingRecipe.NBT_CLEARERS.computeIfAbsent(new ItemMeta(exampleOutput), key -> new Object2ObjectOpenHashMap()).put(new ItemMeta(input), warningTooltip);
            ReloadableRegistryManager.addRegistryEntry((IForgeRegistry)ForgeRegistries.RECIPES, (ResourceLocation)name, (IForgeRegistryEntry)recipe);
            TooltipHelpers.addTooltip(input, canClearTooltip);
            return recipe;
        }

        public static NBTTagCompound transferSubTags(ItemStack orig, String ... keys) {
            return NBTClearingRecipeHelpers.transferSubTags(orig, null, keys);
        }

        public static NBTTagCompound transferSubTags(ItemStack orig, @Nullable NBTTagCompound existing, String ... keys) {
            NBTTagCompound origCompound = orig.func_77978_p();
            if (origCompound == null) {
                return existing;
            }
            NBTTagCompound tagCompound = existing == null ? new NBTTagCompound() : existing;
            for (String key : keys) {
                if (!origCompound.func_74764_b(key) || origCompound.func_74781_a(key).func_82582_d()) continue;
                tagCompound.func_74782_a(key, origCompound.func_74781_a(key));
            }
            return tagCompound;
        }

        public static NBTTagCompound transferTagAtPath(ItemStack orig, String ... path) {
            return NBTClearingRecipeHelpers.transferTagAtPath(orig, null, path);
        }

        public static NBTTagCompound transferTagAtPath(ItemStack orig, @Nullable NBTTagCompound existing, String ... path) {
            NBTTagCompound origCompound = orig.func_77978_p();
            if (origCompound == null) {
                return existing;
            }
            LinkedList<String> linkedPath = new LinkedList<String>(Arrays.asList(path));
            NBTBase tag = NBTClearingRecipeHelpers.findTagAtPath(origCompound, new LinkedList<String>(linkedPath));
            if (tag == null || tag.func_82582_d()) {
                return existing;
            }
            NBTTagCompound compound = existing == null ? new NBTTagCompound() : existing;
            NBTClearingRecipeHelpers.addTagAtPath(compound, tag, linkedPath);
            return compound;
        }

        public static NBTTagCompound transferDrawerUpgradeData(ItemStack orig, @Nullable NBTTagCompound existing) {
            NBTTagCompound origCompound = orig.func_77978_p();
            if (origCompound == null) {
                return existing;
            }
            LinkedList<String> linkedPath = new LinkedList<String>(Arrays.asList("tile", "Upgrades"));
            NBTBase tag = NBTClearingRecipeHelpers.findTagAtPath(origCompound, linkedPath);
            if (!(tag instanceof NBTTagList) || tag.func_82582_d()) {
                return existing;
            }
            NBTTagCompound compound = existing == null ? new NBTTagCompound() : existing;
            NBTTagCompound storage = new NBTTagCompound();
            storage.func_74782_a("Upgrades", tag);
            compound.func_74782_a("labs_saved_upgrades", (NBTBase)storage);
            return compound;
        }

        private static void addTagAtPath(@NotNull NBTTagCompound compound, @NotNull NBTBase add, LinkedList<String> path) {
            if (path.isEmpty()) {
                return;
            }
            String key = path.pollFirst();
            if (path.isEmpty()) {
                compound.func_74782_a(key, add);
                return;
            }
            NBTTagCompound next = compound.func_74775_l(key);
            NBTClearingRecipeHelpers.addTagAtPath(next, add, path);
            compound.func_74782_a(key, (NBTBase)next);
        }

        @Nullable
        private static NBTBase findTagAtPath(@NotNull NBTTagCompound search, LinkedList<String> path) {
            if (search.func_82582_d() || path.isEmpty()) {
                return null;
            }
            String key = path.pollFirst();
            if (!search.func_74764_b(key)) {
                return null;
            }
            if (path.isEmpty()) {
                return search.func_74781_a(key);
            }
            if (!search.func_150297_b(key, 10)) {
                return null;
            }
            return NBTClearingRecipeHelpers.findTagAtPath(search.func_74775_l(key), path);
        }
    }

    public static class MiscHelpers {
        public static void removeDraconicFusionRecipe(ItemStack catalyst, ItemStack result) {
            if (!Loader.isModLoaded((String)"draconicevolution")) {
                return;
            }
            for (IFusionRecipe recipe : RecipeManager.FUSION_REGISTRY.getRecipes().stream().filter(x -> x.getRecipeCatalyst().func_77969_a(catalyst) && x.getRecipeOutput(catalyst).func_77969_a(result)).collect(Collectors.toList())) {
                ((DraconicEvolution)ModSupport.DRACONIC_EVOLUTION.get()).fusion.remove(recipe);
            }
        }
    }

    public static class KeyBindingHelpers {
        public static void addOverride(String id, int keyCode) {
            KeyBindingHelpers.addOverride(id, KeyModifier.NONE, keyCode);
        }

        public static void addOverride(String id, KeyModifier modifier, int keyCode) {
            LabsVirtualizedRegistries.KEYBIND_OVERRIDES_MANAGER.addOverride(id, modifier, keyCode);
        }
    }

    public static class GTRecipeHelpers {
        public static ChancedItemOutput chanced(ItemStack stack, int chance, int chanceBoost) {
            return new ChancedItemOutput(stack, chance, chanceBoost);
        }

        public static ChancedFluidOutput chanced(FluidStack fluid, int chance, int chanceBoost) {
            return new ChancedFluidOutput(fluid, chance, chanceBoost);
        }

        @Contract(value="_ -> new")
        public static GTRecipeInput toGtInput(IIngredient ingredient) {
            return RecipeBuilderAccessor.ofGroovyIngredient(ingredient);
        }
    }

    public static class ChangeCompositionHelpers {
        public static CompositionBuilder changeComposition(Material material) {
            return new CompositionBuilder(material);
        }

        public static CompositionBuilder replaceComposition(MaterialStack material) {
            return new CompositionBuilder(material.material);
        }

        public static CompositionBuilder changeComposition(ItemStack stack) {
            MaterialStack mat = CompositionBuilder.getMatFromStack(stack);
            if (mat == null) {
                return new CompositionBuilder(GregTechAPI.materialManager.getRegistry("gregtech").getFallbackMaterial());
            }
            return new CompositionBuilder(mat.material);
        }

        public static CompositionBuilder changeComposition(FluidStack fluid) {
            MaterialStack mat = CompositionBuilder.getMatFromFluid(fluid);
            if (mat == null) {
                return new CompositionBuilder(GregTechAPI.materialManager.getRegistry("gregtech").getFallbackMaterial());
            }
            return new CompositionBuilder(mat.material);
        }
    }

    public static class RecyclingHelpers {
        public static void replaceRecipeShaped(String name, ItemStack output, List<List<IIngredient>> inputs) {
            if (name.contains(":")) {
                RecyclingHelpers.replaceRecipeShaped(new ResourceLocation(name), output, inputs);
            } else {
                RecyclingHelpers.replaceRecipeShaped(GTUtility.gregtechId((String)name), output, inputs);
            }
        }

        public static void replaceRecipeShaped(ResourceLocation name, ItemStack output, List<List<IIngredient>> inputs) {
            RecyclingHelper.replaceRecipeShaped(name, output, inputs);
        }

        public static void replaceRecipeShaped(ItemStack oldOutput, ItemStack newOutput, List<List<IIngredient>> inputs) {
            RecyclingHelper.replaceRecipeShaped(oldOutput, newOutput, inputs);
        }

        public static void replaceRecipeOutput(String name, ItemStack output) {
            if (name.contains(":")) {
                RecyclingHelpers.replaceRecipeOutput(new ResourceLocation(name), output);
            } else {
                RecyclingHelpers.replaceRecipeOutput(GTUtility.gregtechId((String)name), output);
            }
        }

        public static void replaceRecipeOutput(ResourceLocation name, ItemStack newOutput) {
            RecyclingHelper.replaceRecipeOutput(name, newOutput);
        }

        public static void replaceRecipeOutput(ItemStack oldOutput, ItemStack newOutput) {
            RecyclingHelper.replaceRecipeOutput(oldOutput, newOutput);
        }

        public static void replaceRecipeInput(String name, List<List<IIngredient>> inputs) {
            if (name.contains(":")) {
                RecyclingHelpers.replaceRecipeInput(new ResourceLocation(name), inputs);
            } else {
                RecyclingHelpers.replaceRecipeInput(GTUtility.gregtechId((String)name), inputs);
            }
        }

        public static void replaceRecipeInput(ResourceLocation name, List<List<IIngredient>> newInputs) {
            RecyclingHelper.replaceRecipeInput(name, newInputs);
        }

        public static void replaceRecipeInput(ItemStack oldOutput, List<List<IIngredient>> newInputs) {
            RecyclingHelper.replaceRecipeInput(oldOutput, newInputs);
        }

        public static void createRecipe(String name, ItemStack output, List<List<IIngredient>> input) {
            RecyclingHelper.createRecipe(name, output, input);
        }

        public static void createRecipe(ItemStack output, List<List<IIngredient>> input) {
            RecyclingHelper.createRecipe(output, input);
        }

        public static void changeStackRecycling(ItemStack output, List<IIngredient> ingredients) {
            RecyclingHelper.changeStackRecycling(output, ingredients);
        }

        public static void changeStackRecyclingNBT(ItemStack output, List<IIngredient> ingredients, NBTMatcher matcher, NBTCondition condition) {
            RecyclingHelper.changeStackRecycling(output, ingredients);
            LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerNBTHandling(output, matcher, condition);
        }

        public static void changeStackRecycling(Recipe recipe) {
            RecyclingHelper.changeStackRecycling((List<ItemStack>)recipe.getOutputs(), recipe.getInputs());
        }

        public static void changeStackRecyclingNBT(Recipe recipe, NBTMatcher matcher, NBTCondition condition) {
            if (RecyclingHelper.changeStackRecycling((List<ItemStack>)recipe.getOutputs(), recipe.getInputs())) {
                LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerNBTHandling((ItemStack)recipe.getOutputs().get(0), matcher, condition);
            }
        }

        public static void changeStackRecycling(ItemStack output, VirtualizedRecipeMap map) {
            RecyclingHelpers.changeStackRecycling(output, map.getRecipeMap(), (Recipe r) -> true);
        }

        public static void changeStackRecyclingNBT(ItemStack output, VirtualizedRecipeMap map, NBTMatcher matcher, NBTCondition condition) {
            RecyclingHelpers.changeStackRecyclingNBT(output, map.getRecipeMap(), (Recipe r) -> true, matcher, condition);
        }

        public static void changeStackRecycling(ItemStack output, VirtualizedRecipeMap map, Predicate<Recipe> acceptedRecipe) {
            RecyclingHelper.changeStackRecycling(output, map.getRecipeMap(), acceptedRecipe);
        }

        public static void changeStackRecyclingNBT(ItemStack output, VirtualizedRecipeMap map, Predicate<Recipe> acceptedRecipe, NBTMatcher matcher, NBTCondition condition) {
            if (RecyclingHelper.changeStackRecycling(output, map.getRecipeMap(), acceptedRecipe)) {
                LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerNBTHandling(output, matcher, condition);
            }
        }

        public static void changeStackRecycling(ItemStack output, RecipeMap<?> map) {
            RecyclingHelpers.changeStackRecycling(output, map, (Recipe r) -> true);
        }

        public static void changeStackRecyclingNBT(ItemStack output, RecipeMap<?> map, NBTMatcher matcher, NBTCondition condition) {
            RecyclingHelpers.changeStackRecyclingNBT(output, map, (Recipe r) -> true, matcher, condition);
        }

        public static void changeStackRecycling(ItemStack output, RecipeMap<?> map, Predicate<Recipe> acceptedRecipe) {
            RecyclingHelper.changeStackRecycling(output, map, acceptedRecipe);
        }

        public static void changeStackRecyclingNBT(ItemStack output, RecipeMap<?> map, Predicate<Recipe> acceptedRecipe, NBTMatcher matcher, NBTCondition condition) {
            if (RecyclingHelper.changeStackRecycling(output, map, acceptedRecipe)) {
                LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerNBTHandling(output, matcher, condition);
            }
        }

        public static void removeStackRecycling(ItemStack output) {
            RecyclingHelper.changeStackRecycling(output, Collections.emptyList());
        }
    }

    public static class MaterialHelpers {
        public static void hideMaterial(Material material) {
            MaterialHelpers.hideMaterial(material, true);
        }

        public static void hideMaterial(Material material, boolean inclBucket) {
            MaterialHelper.forMaterialItem(material, (ItemStack stack) -> ((JustEnoughItems)ModSupport.JEI.get()).ingredient.hide(IngredientHelper.toIIngredient((ItemStack)stack)), inclBucket);
            MaterialHelper.forMaterialFluid(material, (Fluid fluid) -> ((JustEnoughItems)ModSupport.JEI.get()).ingredient.hide(IngredientHelper.toIIngredient((FluidStack)MaterialHelpers.toFluidStack(fluid))));
        }

        public static void removeAndHideMaterial(Material material) {
            MaterialHelpers.removeAndHideMaterial(material, true);
        }

        public static void removeAndHideMaterial(Material material, boolean inclBucket) {
            MaterialHelper.forMaterialItem(material, (ItemStack stack) -> ((JustEnoughItems)ModSupport.JEI.get()).ingredient.removeAndHide(IngredientHelper.toIIngredient((ItemStack)stack)), inclBucket);
            MaterialHelper.forMaterialFluid(material, (Fluid fluid) -> ((JustEnoughItems)ModSupport.JEI.get()).ingredient.hide(IngredientHelper.toIIngredient((FluidStack)MaterialHelpers.toFluidStack(fluid))));
        }

        public static void yeetMaterial(Material material) {
            MaterialHelpers.removeAndHideMaterial(material);
        }

        public static void yeetMaterial(Material material, boolean inclBucket) {
            MaterialHelpers.removeAndHideMaterial(material, inclBucket);
        }

        public static void forMaterial(Material material, Closure<Void> itemAction, Closure<Void> fluidAction) {
            MaterialHelpers.forMaterial(material, itemAction, fluidAction, true);
        }

        public static void forMaterial(Material material, Closure<Void> itemAction, Closure<Void> fluidAction, boolean inclBucket) {
            MaterialHelpers.forMaterialItem(material, itemAction, inclBucket);
            MaterialHelpers.forMaterialFluid(material, fluidAction);
        }

        public static void forMaterialItem(Material material, Closure<Void> action) {
            MaterialHelpers.forMaterialItem(material, action, true);
        }

        public static void forMaterialItem(Material material, Closure<Void> action, boolean inclBucket) {
            MaterialHelper.forMaterialItem(material, (ItemStack stack) -> ClosureHelper.call((Closure)action, (Object[])new Object[]{stack}), inclBucket);
        }

        public static void forMaterialFluid(Material material, Closure<Void> action) {
            MaterialHelper.forMaterialFluid(material, (Fluid fluid) -> ClosureHelper.call((Closure)action, (Object[])new Object[]{fluid}));
        }

        private static FluidStack toFluidStack(Fluid fluid) {
            return new FluidStack(fluid, 1);
        }
    }

    public static class JEIHelpers {
        public static void addDescription(ItemStack stack, LabsTranslate.Translatable ... description) {
            LabsJEIPlugin.addGroovyDescription(stack, description);
        }

        public static void addRecipeOutputTooltip(ItemStack stack, ResourceLocation recipeName, LabsTranslate.Translatable ... tooltip) {
            LabsJEIPlugin.addGroovyRecipeOutputTooltip(recipeName, tooltip);
        }

        public static void addRecipeOutputTooltip(String recipeName, LabsTranslate.Translatable ... tooltip) {
            if (recipeName.contains(":")) {
                LabsJEIPlugin.addGroovyRecipeOutputTooltip(new ResourceLocation(recipeName), tooltip);
            } else {
                LabsJEIPlugin.addGroovyRecipeOutputTooltip(new ResourceLocation(GroovyHelper.getPackId(), recipeName), tooltip);
            }
        }

        public static void addRecipeInputTooltip(ResourceLocation recipeName, int slotIndex, LabsTranslate.Translatable ... tooltip) {
            LabsJEIPlugin.addGroovyRecipeInputTooltip(recipeName, slotIndex, tooltip);
        }

        public static void addRecipeInputTooltip(String recipeName, int slotIndex, LabsTranslate.Translatable ... tooltip) {
            if (recipeName.contains(":")) {
                LabsJEIPlugin.addGroovyRecipeInputTooltip(new ResourceLocation(recipeName), slotIndex, tooltip);
            } else {
                LabsJEIPlugin.addGroovyRecipeInputTooltip(new ResourceLocation(GroovyHelper.getPackId(), recipeName), slotIndex, tooltip);
            }
        }

        public static void addRecipeInputTooltip(ResourceLocation recipeName, LabsTranslate.Translatable ... tooltip) {
            for (int i = 0; i < 9; ++i) {
                LabsJEIPlugin.addGroovyRecipeInputTooltip(recipeName, i, tooltip);
            }
        }

        public static void addRecipeInputTooltip(String recipeName, LabsTranslate.Translatable ... tooltip) {
            if (recipeName.contains(":")) {
                JEIHelpers.addRecipeInputTooltip(new ResourceLocation(recipeName), tooltip);
            } else {
                JEIHelpers.addRecipeInputTooltip(new ResourceLocation(GroovyHelper.getPackId(), recipeName), tooltip);
            }
        }

        public static void hideItemIgnoreNBT(ItemStack stack) {
            LabsJEIPlugin.hideItemNBTMatch(stack, tag -> true);
        }

        public static void removeAndHideItemIgnoreNBT(ItemStack stack) {
            LabsJEIPlugin.removeAndHideItemNBTMatch(stack, tag -> true);
        }

        public static void yeetItemIgnoreNBT(ItemStack stack) {
            JEIHelpers.removeAndHideItemIgnoreNBT(stack);
        }

        public static void hideItemNBTMatch(ItemStack stack, Function<NBTTagCompound, Boolean> condition) {
            LabsJEIPlugin.hideItemNBTMatch(stack, condition);
        }

        public static void removeAndHideItemNBTMatch(ItemStack stack, Function<NBTTagCompound, Boolean> condition) {
            LabsJEIPlugin.removeAndHideItemNBTMatch(stack, condition);
        }

        public static void yeetItemNBTMatch(ItemStack stack, Function<NBTTagCompound, Boolean> condition) {
            LabsJEIPlugin.removeAndHideItemNBTMatch(stack, condition);
        }

        public static void overrideRecipeCatalysts(String category, Object ... catalysts) {
            LabsJEIPlugin.addRecipeCatalystOverride(category, catalysts);
        }
    }

    public static class SafeMethodHelpers {
        @Nullable
        public static Object callInstanceMethod(Object caller, @NotNull String methodName, @Nullable List<Object> params) {
            return SafeMethodHelpers.callMethod(caller.getClass(), caller, methodName, params, false);
        }

        @Nullable
        public static Object callInstanceMethodOfClass(Class<?> clazz, Object caller, @NotNull String methodName, @Nullable List<Object> params) {
            return SafeMethodHelpers.callMethod(clazz, caller, methodName, params, true);
        }

        @Nullable
        public static Object callStaticMethod(Class<?> clazz, @NotNull String methodName, @Nullable List<Object> params) {
            return SafeMethodHelpers.callMethod(clazz, null, methodName, params, true);
        }

        @Nullable
        public static Object callMethod(Class<?> clazz, @Nullable Object caller, @NotNull String methodName, @Nullable List<Object> params, boolean strict) {
            try {
                Object[] paramArray = params != null ? params.toArray() : new Object[]{};
                Class[] paramClasses = params != null ? (Class[])params.stream().map(Object::getClass).toArray(Class[]::new) : new Class[]{};
                Method method = strict ? clazz.getDeclaredMethod(methodName, paramClasses) : clazz.getMethod(methodName, paramClasses);
                return method.invoke(caller, paramArray);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
                GroovyLog.get().exception(e);
                return null;
            }
        }
    }

    public static class TooltipHelpers {
        public static void addTooltip(ItemStack item, List<LabsTranslate.Translatable> tr) {
            LabsTooltipHelper.addTooltip(new ItemMeta(item), tr);
        }

        public static void addTooltip(ItemStack item, LabsTranslate.Translatable tr) {
            ArrayList<LabsTranslate.Translatable> list = new ArrayList<LabsTranslate.Translatable>();
            list.add(tr);
            LabsTooltipHelper.addTooltip(new ItemMeta(item), list);
        }
    }

    public static class TranslationHelpers {
        public static String translate(String key, Object ... params) {
            return LabsTranslate.translate(key, params);
        }

        public static String translateFormat(String key, TooltipHelper.GTFormatCode format, Object ... params) {
            return LabsTranslate.translateFormat(key, format, params);
        }

        public static String format(String str, TextFormatting ... formats) {
            return LabsTranslate.format(str, formats);
        }

        public static String format(String str, TooltipHelper.GTFormatCode ... formats) {
            return LabsTranslate.format(str, formats);
        }

        public static String format(String str, LabsTranslate.Format ... formats) {
            return LabsTranslate.format(str, formats);
        }

        public static LabsTranslate.Translatable translatable(String key, Object ... params) {
            return LabsTranslate.translatable(key, params);
        }

        public static LabsTranslate.Translatable translatableLiteral(String text) {
            return LabsTranslate.translatableLiteral(text);
        }

        public static LabsTranslate.Translatable translatableEmpty() {
            return LabsTranslate.translatableEmpty();
        }
    }
}

