/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.command.TextCopyable;
import com.cleanroommc.groovyscript.event.GsHandEvent;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.MaterialStack;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GroovyScriptHandManager {
    public static void addToHand(GsHandEvent event) {
        ItemStack stack = event.stack;
        MaterialStack material = OreDictUnifier.getMaterial((ItemStack)stack);
        if (material == null) {
            return;
        }
        event.messages.add(new TextComponentString(""));
        GroovyScriptHandManager.addToMessage(event, material.copy(1L), false);
        if (material.material.getMaterialComponents() == null || material.material.getMaterialComponents().isEmpty()) {
            return;
        }
        event.messages.add(new TextComponentTranslation("nomilabs.command.gs_hand.material_components", new Object[0]));
        for (MaterialStack component : material.material.getMaterialComponents()) {
            GroovyScriptHandManager.addToMessage(event, component, true);
        }
        String allComponents = material.material.getMaterialComponents().stream().map(comp -> comp.amount > 1L ? "materialstack('" + GroovyScriptHandManager.getName(comp) + "') * " + comp.amount : "materialstack('" + GroovyScriptHandManager.getName(comp) + "')").collect(Collectors.joining(", ", "[", "]"));
        event.messages.add(TextCopyable.translation((String)allComponents, (String)"nomilabs.command.gs_hand.all_material_components", (Object[])new Object[0]).build());
    }

    private static void addToMessage(GsHandEvent event, MaterialStack material, boolean list) {
        String materialText = "material('" + GroovyScriptHandManager.getName(material) + "')";
        String stackText = "materialstack('" + GroovyScriptHandManager.getName(material) + "')";
        if (material.amount > 1L) {
            stackText = stackText + " * " + material.amount;
        }
        ITextComponent materialComp = TextCopyable.translation((String)materialText, (String)"nomilabs.command.gs_hand.material", (Object[])new Object[0]).build().func_150257_a(new TextComponentString(" " + GroovyScriptHandManager.getName(material)).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        ITextComponent stackComp = TextCopyable.translation((String)stackText, (String)"nomilabs.command.gs_hand.material_stack", (Object[])new Object[0]).build().func_150257_a(new TextComponentString(" " + GroovyScriptHandManager.getName(material) + " (" + material.amount + ")").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        if (!list) {
            event.messages.add(materialComp);
            event.messages.add(stackComp);
            return;
        }
        event.messages.add(new TextComponentString(" - ").func_150257_a(new TextComponentString(material.material.getLocalizedName()).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA))));
        event.messages.add(new TextComponentString("   ").func_150257_a(materialComp));
        event.messages.add(new TextComponentString("   ").func_150257_a(stackComp));
    }

    private static String getName(MaterialStack material) {
        return material.material.getModid().equals("gregtech") ? material.material.toString() : material.material.getRegistryName();
    }
}

